  
<?php $__env->startSection('meta'); ?>  
<title>DMCA Policy - <?php echo e($setting->webname); ?> IPTV | Copyright Infringement Claims</title>
<meta name="description" content="<?php echo e($setting->webname); ?> IPTV's DMCA Policy. How to report copyright infringement and our process for handling claims related to our UK IPTV service. Protecting intellectual property.">
<meta name="keywords" content="<?php echo e($setting->webname); ?> IPTV DMCA, IPTV copyright UK, DMCA notice IPTV, report IPTV infringement UK, IPTV intellectual property">
<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "BreadcrumbList",
  "itemListElement": [
    {
      "@type": "ListItem",
      "position": 1,
      "name": "Home",
      "item": "<?php echo e(route('website')); ?>"
    },
    {
      "@type": "ListItem",
      "position": 2,
      "name": "DMCA Policy"
    }
  ]
}
</script>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?> 
  <main class="flex-grow">
  <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 py-12" style="opacity: 1; transform: none;">
    <h1 class="text-3xl font-extrabold text-gray-900 sm:text-4xl mb-8">DMCA Policy (Digital Millennium Copyright Act)</h1>
    <div class="prose prose-lg max-w-none text-gray-700">
    
      <h2 class="text-2xl font-bold mt-6 mb-3">1. Introduction</h2>
      <p><?php echo e($setting->webname); ?> IPTV (" <a href="/" target="_blank" rel="noopener noreferrer" class="text-blue-600 hover:underline"><?php echo e($setting->webname); ?></a>", "we", "us", "our") respects the intellectual property rights of others and expects its users to do the same. In accordance with the Digital Millennium Copyright Act of 1998 (DMCA), the text of which may be found on the U.S. Copyright Office website at <a href="https://www.copyright.gov/legislation/dmca.pdf" target="_blank" rel="noopener noreferrer" class="text-blue-600 hover:underline">www.copyright.gov/legislation/dmca.pdf</a>, we will respond expeditiously to claims of copyright infringement committed using the <?php echo e($setting->webname); ?> IPTV service and/or the <?php echo e($setting->webname); ?> IPTV website (the "Site") if such claims are reported to our Designated Copyright Agent identified below. Our general approach to copyright is also outlined in our <a class="text-blue-600 hover:underline" href="/terms-of-service">Terms of Service</a>. </p>
      <p><?php echo e($setting->webname); ?> IPTV does not host, provide, archive, store, or distribute media of any kind. We act as an index or directory of media posted by other enthusiasts on the internet, which is completely outside of our control. We respect the rights of copyright holders and are committed to addressing infringement claims.</p>
      <h2 class="text-2xl font-bold mt-6 mb-3">2. Notification of Copyright Infringement</h2>
      <p>If you are a copyright owner, authorized to act on behalf of one, or authorized to act under any exclusive right under copyright, please report alleged copyright infringements taking place on or through the Site or Service by completing the following DMCA Notice of Alleged Infringement and delivering it to our Designated Copyright Agent.</p>
      <p>Upon receipt of a DMCA Notice, we will take whatever action, in our sole discretion, we deem appropriate, including removal of the challenged content from the Service listings or disabling access to it.</p>
      <h2 class="text-2xl font-bold mt-6 mb-3">3. DMCA Notice of Alleged Infringement ("Notice")</h2>
      <p>To file a notice of infringing material on <?php echo e($setting->webname); ?> IPTV, please provide a notification containing the following details:</p>
      <ol class="list-decimal pl-6">
        <li>Identify the copyrighted work that you claim has been infringed, or - if multiple copyrighted works are covered by this Notice - you may provide a representative list of the copyrighted works that you claim have been infringed. You can find information about registering copyrights at the <a href="https://www.copyright.gov/" target="_blank" rel="noopener noreferrer" class="text-blue-600 hover:underline">U.S. Copyright Office</a> or the <a href="https://www.gov.uk/topic/intellectual-property/copyright" target="_blank" rel="noopener noreferrer" class="text-blue-600 hover:underline">UK Intellectual Property Office</a>. </li>
        <li>Identify the material or link you claim is infringing (or the subject of infringing activity) and to which access is to be disabled, including at a minimum, if applicable, the URL of the link shown on the Site or the exact location where such material may be found. (Please note: Simply providing a channel name is often insufficient. Please provide specific details that allow us to locate the content, e.g., specific stream URL or M3U playlist URL if known, or specific EPG data if that's the infringing element).</li>
        <li>Provide your company affiliation (if applicable), mailing address, telephone number, and, if available, email address.</li>
        <li>Include both of the following statements in the body of the Notice: <ul class="list-disc pl-6 mt-2">
            <li>"I hereby state that I have a good faith belief that the disputed use of the copyrighted material is not authorized by the copyright owner, its agent, or the law (e.g., as a fair use)."</li>
            <li>"I hereby state that the information in this Notice is accurate and, under penalty of perjury, that I am the owner, or authorized to act on behalf of the owner, of the copyright or of an exclusive right under the copyright that is allegedly infringed."</li>
          </ul>
        </li>
        <li>Provide your full legal name and your electronic or physical signature.</li>
      </ol>
      <p>Deliver this Notice, with all items completed, to <?php echo e($setting->webname); ?> IPTV's Designated Copyright Agent:</p>
      <p>
        <strong>Designated Copyright Agent:</strong>
        <br>Legal Department - Copyright Claims <br><?php echo e($setting->webname); ?> IPTV <br><?php echo e($setting->webname); ?> IPTV HQ, 123 Streaming Avenue, London, UK, SW1A 1AA (Example Address) <br>Email: <a href="mailto:dmca.<?php echo e($setting->webname); ?>" class="text-blue-600 hover:underline">dmca.<?php echo e($setting->webname); ?>@example.com</a> (Please use this email specifically for DMCA notices. This is an example email; actual contact details will be confirmed.)
      </p>
      <p>Please note that DMCA notices must be sent to the designated agent; notices sent to other contacts or through other means, such as our general <a class="text-blue-600 hover:underline" href="/#contact">contact form</a>, may not be processed. </p>
      <h2 class="text-2xl font-bold mt-6 mb-3">4. Counter-Notification Procedures</h2>
      <p>If you believe that material you posted on the site was removed or access to it was disabled by mistake or misidentification, you may file a counter-notification with us (a "Counter-Notice") by submitting written notification to our copyright agent (identified above). Pursuant to the DMCA, the Counter-Notice must include substantially the following:</p>
      <ol class="list-decimal pl-6">
        <li>Your physical or electronic signature.</li>
        <li>An identification of the material that has been removed or to which access has been disabled and the location at which the material appeared before it was removed or access disabled.</li>
        <li>A statement under penalty of perjury that you have a good faith belief that the material was removed or disabled as a result of mistake or misidentification of the material to be removed or disabled.</li>
        <li>Your name, address, telephone number, and, if available, email address, and a statement that you consent to the jurisdiction of the Federal Court for the judicial district in which your address is located, or if your address is outside of the United States, for any judicial district in which <?php echo e($setting->webname); ?> IPTV may be found, and that you will accept service of process from the person who provided notification under subsection (c)(1)(C) or an agent of such person.</li>
      </ol>
      <p>Please note that we may share a copy of your counter-notification with the complaining party.</p>
      <h2 class="text-2xl font-bold mt-6 mb-3">5. Repeat Infringers</h2>
      <p>It is our policy in appropriate circumstances to disable and/or terminate the accounts of users who are repeat infringers, as stated in our <a class="text-blue-600 hover:underline" href="/acceptable-use-policy">Acceptable Use Policy</a>. </p>
      <h2 class="text-2xl font-bold mt-6 mb-3">6. Disclaimer</h2>
      <p>Please be aware that if you knowingly materially misrepresent that material or activity on the Site is infringing your copyright, you may be held liable for damages (including costs and attorneys' fees) under Section 512(f) of the DMCA.</p>
      <p>This DMCA policy does not constitute legal advice. If you have questions about your rights or obligations under the DMCA or other applicable copyright laws, please consult with an attorney. For general information on copyright, the <a href="https://www.wipo.int" target="_blank" rel="noopener noreferrer" class="text-blue-600 hover:underline">World Intellectual Property Organization (WIPO)</a> is a useful resource. </p>
    </div>
  </div>
</main>
    
   <?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u882570979/domains/gbiptv.com/public_html/resources/views/website/service/dmca.blade.php ENDPATH**/ ?>