  
<?php $__env->startSection('meta'); ?>  
<title>Privacy Policy - <?php echo e($setting->webname); ?> IPTV | UK Data Protection</title>
<meta name="description" content="Our Privacy Policy outlines how <?php echo e($setting->webname); ?> IPTV collects, uses, and protects your personal data. Learn about your rights under GDPR and our commitment to data security for UK IPTV users.">
<meta name="keywords" content="<?php echo e($setting->webname); ?> IPTV privacy, IPTV privacy policy UK, UK IPTV data protection, GDPR IPTV, personal data IPTV UK, secure IPTV">
<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "BreadcrumbList",
  "itemListElement": [
    {
      "@type": "ListItem",
      "position": 1,
      "name": "Home",
      "item": "<?php echo e(route('website')); ?>"
    },
    {
      "@type": "ListItem",
      "position": 2,
      "name": "Privacy Policy"
    }
  ]
}
</script>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?> 
  <main class="flex-grow">
  <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 py-12" style="opacity: 1; transform: none;">
    <h1 class="text-3xl font-extrabold text-gray-900 sm:text-4xl mb-8">Privacy Policy</h1>
    <div class="prose prose-lg max-w-none text-gray-700">
     
      <h2 class="text-2xl font-bold mt-6 mb-3">1. Introduction</h2>
      <p><?php echo e($setting->webname); ?> IPTV ("we", "our", "us") is committed to protecting your privacy. This Privacy Policy explains how we collect, use, disclose, and safeguard your information when you visit our website <a href="/" target="_blank" rel="noopener noreferrer" class="text-blue-600 hover:underline"><?php echo e($setting->webname); ?></a> and use our IPTV services (collectively, "Service"). Please read this privacy policy carefully. If you do not agree with the terms of this privacy policy, please do not access the site or use our services. This policy should be read in conjunction with our <a class="text-blue-600 hover:underline" href="/terms-of-service">Terms of Service</a>. </p>
      <h2 class="text-2xl font-bold mt-6 mb-3">2. Information We Collect</h2>
      <p>We may collect information about you in a variety of ways. The information we may collect on the Service includes:</p>
      <ul class="list-disc pl-6">
        <li>
          <strong>Personal Data:</strong> Personally identifiable information, such as your name, email address, and payment information, that you voluntarily give to us when you register for the Service or when you choose to participate in various activities related to the Service.
        </li>
        <li>
          <strong>Usage Data:</strong> Information our servers automatically collect when you access the Service, such as your IP address, your browser type, your operating system, your access times, and the pages you have viewed directly before and after accessing the Service.
        </li>
        <li>
          <strong>Device Information:</strong> Information about the device you use to access our service, such as device model, operating system version, and unique device identifiers.
        </li>
      </ul>
      <h2 class="text-2xl font-bold mt-6 mb-3">3. How We Use Your Information</h2>
      <p>Having accurate information about you permits us to provide you with a smooth, efficient, and customized experience. Specifically, we may use information collected about you via the Service to:</p>
      <ul class="list-disc pl-6">
        <li>Create and manage your account.</li>
        <li>Process your payments and deliver the services you have requested.</li>
        <li>Email you regarding your account or order.</li>
        <li>Improve our website and services.</li>
        <li>Monitor and analyze usage and trends to improve your experience with the Service.</li>
        <li>Prevent fraudulent transactions, monitor against theft, and protect against criminal activity.</li>
        <li>Comply with legal and regulatory requirements, such as those outlined by <a href="https://ico.org.uk/" target="_blank" rel="noopener noreferrer" class="text-blue-600 hover:underline">Information Commissioner's Office (ICO)</a> in the UK. </li>
      </ul>
      <h2 class="text-2xl font-bold mt-6 mb-3">4. Disclosure of Your Information</h2>
      <p>We may share information we have collected about you in certain situations. Your information may be disclosed as follows:</p>
      <ul class="list-disc pl-6">
        <li>
          <strong>By Law or to Protect Rights:</strong> If we believe the release of information about you is necessary to respond to legal process, to investigate or remedy potential violations of our policies, or to protect the rights, property, and safety of others, we may share your information as permitted or required by any applicable law, rule, or regulation.
        </li>
        <li>
          <strong>Third-Party Service Providers:</strong> We may share your information with third parties that perform services for us or on our behalf, including payment processing (e.g., Stripe, PayPal), data analysis, email delivery, hosting services, customer service, and marketing assistance.
        </li>
        <li>
          <strong>Business Transfers:</strong> We may share or transfer your information in connection with, or during negotiations of, any merger, sale of company assets, financing, or acquisition of all or a portion of our business to another company.
        </li>
      </ul>
      <p>We do not sell your personal information to third parties.</p>
      <h2 class="text-2xl font-bold mt-6 mb-3">5. Security of Your Information</h2>
      <p>We use administrative, technical, and physical security measures to help protect your personal information. While we have taken reasonable steps to secure the personal information you provide to us, please be aware that despite our efforts, no security measures are perfect or impenetrable, and no method of data transmission can be guaranteed against any interception or other type of misuse.</p>
      <h2 class="text-2xl font-bold mt-6 mb-3">6. Your Data Protection Rights (GDPR)</h2>
      <p>If you are a resident of the European Economic Area (EEA), you have certain data protection rights. Please refer to our <a class="text-blue-600 hover:underline" href="/gdpr-compliance">GDPR Compliance page</a> for detailed information on these rights and how to exercise them. </p>
      <h2 class="text-2xl font-bold mt-6 mb-3">7. Cookies and Tracking Technologies</h2>
      <p>We may use cookies, web beacons, tracking pixels, and other tracking technologies on the Service to help customize the Service and improve your experience. When you access the Service, your personal information is not collected through the use of tracking technology. Most browsers are set to accept cookies by default. You can remove or reject cookies, but be aware that such action could affect the availability and functionality of the Service. For more information on managing cookies, visit <a href="https://www.aboutcookies.org" target="_blank" rel="noopener noreferrer" class="text-blue-600 hover:underline">aboutcookies.org</a>. </p>
      <h2 class="text-2xl font-bold mt-6 mb-3">8. Third-Party Websites</h2>
      <p>The Service may contain links to third-party websites and applications of interest, including advertisements and external services, that are not affiliated with us. Once you have used these links to leave the Service, any information you provide to these third parties is not covered by this Privacy Policy, and we cannot guarantee the safety and privacy of your information. We are not responsible for the content or privacy and security practices and policies of any third parties.</p>
      <h2 class="text-2xl font-bold mt-6 mb-3">9. Changes to This Privacy Policy</h2>
      <p>We may update this Privacy Policy from time to time. We will notify you of any changes by posting the new Privacy Policy on this page and updating the "Last Updated" date. You are advised to review this Privacy Policy periodically for any changes.</p>
      <h2 class="text-2xl font-bold mt-6 mb-3">10. Contact Us</h2>
      <p>If you have questions or comments about this Privacy Policy, please <a class="text-blue-600 hover:underline" href="/#contact">contact us</a> via the contact methods provided on our website. </p>
    </div>
  </div>
</main>
   <?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u882570979/domains/gbiptv.com/public_html/resources/views/website/service/policy.blade.php ENDPATH**/ ?>