  
<?php $__env->startSection('meta'); ?>  

<title>IPTV Installation Guides - <?php echo e($setting->webname); ?> | Setup on Any Device</title>
<meta name="description" content="Easy-to-follow IPTV installation guides for Smart TV, Firestick, Android Box, iOS, Windows, and more. Set up <?php echo e($setting->webname); ?> IPTV quickly and start streaming UK channels.">
<meta name="keywords" content="IPTV setup guide, <?php echo e($setting->webname); ?> IPTV installation, Firestick IPTV setup, Smart TV IPTV setup, Android Box IPTV, iOS IPTV guide, Windows IPTV player, MAG Box IPTV setup">
<!-- Canonical URL -->
<link rel="canonical" href="<?php echo e(url()->current()); ?>">
<!-- Open Graph / Facebook -->
<meta property="og:title" content="IPTV Installation Guides - <?php echo e($setting->webname); ?>">
<meta property="og:description" content="Step-by-step IPTV setup guides for Smart TV, Firestick, Android Box, iOS, Windows & more. Start streaming UK live channels now.">
<meta property="og:url" content="<?php echo e(url()->current()); ?>">
<meta property="og:type" content="website">
<meta property="og:site_name" content="<?php echo e($setting->webname); ?>">
<!-- Twitter Card -->
<meta name="twitter:card" content="summary_large_image">
<meta name="twitter:title" content="IPTV Installation Guides - <?php echo e($setting->webname); ?>">
<meta name="twitter:description" content="Quick IPTV installation tutorials for any device. Learn how to set up <?php echo e($setting->webname); ?> IPTV on Firestick, Smart TV, Android & more.">
<meta name="twitter:site" content="<?php echo e($setting->webname); ?>"> 


<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@graph": [
    {
      "@type": "BreadcrumbList",
      "@id": "<?php echo e(route('website')); ?>/installation-guides#breadcrumb",
      "itemListElement": [
        {
          "@type": "ListItem",
          "position": 1,
          "name": "Home",
          "item": "<?php echo e(route('website')); ?>/"
        },
        {
          "@type": "ListItem",
          "position": 2,
          "name": "Installation Guides",
          "item": "<?php echo e(route('website')); ?>/installation-guides"
        }
      ]
    },
    {
      "@type": "Article",
      "@id": "<?php echo e(route('website')); ?>/installation-guides#article",
      "mainEntityOfPage": {
        "@type": "WebPage",
        "@id": "<?php echo e(route('website')); ?>/installation-guides"
      },
      "headline": "IPTV Installation Guides for All Devices - <?php echo e($setting->webname); ?>",
      "description": "Step-by-step IPTV installation guides for Firestick, Android, iOS, Smart TVs, and more. Learn how to easily set up IPTV on any device with <?php echo e($setting->webname); ?>.",
      "image": "<?php echo e(route('website')); ?>/path-to-your-featured-image.jpg",
      "author": {
        "@type": "Person",
        "name": "Emilly Florence"
      },
      "publisher": {
        "@type": "Organization",
        "name": "<?php echo e($setting->webname); ?>",
        "logo": {
          "@type": "ImageObject",
          "url": "<?php echo e(route('website')); ?>/path-to-your-logo.png"
        }
      },
     "datePublished": "<?php echo e(now()->subYear()->format('Y-m-d')); ?>",
"dateModified": "<?php echo e(now()->format('Y-m-d')); ?>"

    },
    {
      "@type": "HowTo",
      "name": "How to Install IPTV on Firestick",
      "description": "Learn how to install IPTV on your Firestick device step-by-step using Downloader or Filelinked.",
      "image": "<?php echo e(route('website')); ?>/images/firestick-setup.jpg",
      "totalTime": "PT10M",
      "supply": [
        {
          "@type": "HowToSupply",
          "name": "Firestick"
        },
        {
          "@type": "HowToSupply",
          "name": "Internet connection"
        }
      ],
      "tool": [
        {
          "@type": "HowToTool",
          "name": "Downloader App"
        }
      ],
      "step": [
        {
          "@type": "HowToStep",
          "text": "Go to Settings > My Fire TV > Developer Options > Enable Apps from Unknown Sources."
        },
        {
          "@type": "HowToStep",
          "text": "Open the Downloader app and enter the IPTV APK URL provided by <?php echo e($setting->webname); ?>."
        },
        {
          "@type": "HowToStep",
          "text": "Download and install the IPTV app, then open it and enter your login credentials."
        }
      ]
    }
  ]
}
</script>




<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?> 
 <main class="flex-grow">
  <div class="bg-white text-gray-800 min-h-screen py-12" style="opacity: 1;">
    <div class="max-w-5xl mx-auto px-4 sm:px-6 lg:px-8">
      <div class="text-center mb-12" style="opacity: 1; transform: none;">
        <h1 class="text-4xl sm:text-5xl font-extrabold tracking-tight text-gray-900">Installation Guides</h1>
        <p class="mt-4 text-lg sm:text-xl text-gray-600 max-w-2xl mx-auto">Step-by-step instructions to set up <?php echo e($setting->webname); ?> IPTV on your favorite devices. Get ready to stream in minutes!</p>
      </div>
      <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6 mb-16">
        <a href="#guide-item-firestick" class="bg-white p-6 rounded-xl shadow-lg hover:shadow-xl transition-shadow duration-300 ease-in-out flex flex-col items-center text-center border border-gray-100 cursor-pointer" style="opacity: 1; transform: none;">
          <div class="text-blue-600 mb-4">
            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="w-12 h-12">
              <path d="M21 8a2 2 0 0 0-1-1.73l-7-4a2 2 0 0 0-2 0l-7 4A2 2 0 0 0 3 8v8a2 2 0 0 0 1 1.73l7 4a2 2 0 0 0 2 0l7-4A2 2 0 0 0 21 16Z"></path>
              <path d="m3.3 7 8.7 5 8.7-5"></path>
              <path d="M12 22V12"></path>
            </svg>
          </div>
          <h3 class="text-xl font-semibold text-gray-900 mb-2">Firestick / Fire TV / Fire Cube</h3>
          <p class="text-sm text-gray-600 flex-grow mb-4">Popular Apps: IPTV Smarters Pro (APK), TiviMate (APK)...</p>
         
        </a>
        <a href="#guide-item-android-devices" class="bg-white p-6 rounded-xl shadow-lg hover:shadow-xl transition-shadow duration-300 ease-in-out flex flex-col items-center text-center border border-gray-100 cursor-pointer" style="opacity: 1; transform: none;">
          <div class="text-blue-600 mb-4">
            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="w-12 h-12">
              <rect width="14" height="20" x="5" y="2" rx="2" ry="2"></rect>
              <path d="M12 18h.01"></path>
            </svg>
          </div>
          <h3 class="text-xl font-semibold text-gray-900 mb-2">Android Devices (Phones, Boxes, TVs)</h3>
          <p class="text-sm text-gray-600 flex-grow mb-4">Popular Apps: IPTV Smarters Pro, TiviMate...</p>
          
        </a>
        <a href="#guide-item-smart-tv" class="bg-white p-6 rounded-xl shadow-lg hover:shadow-xl transition-shadow duration-300 ease-in-out flex flex-col items-center text-center border border-gray-100 cursor-pointer" style="opacity: 1; transform: none;">
          <div class="text-blue-600 mb-4">
            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="w-12 h-12">
              <rect width="20" height="15" x="2" y="7" rx="2" ry="2"></rect>
              <polyline points="17 2 12 7 7 2"></polyline>
            </svg>
          </div>
          <h3 class="text-xl font-semibold text-gray-900 mb-2">Smart TVs (All Brands)</h3>
          <p class="text-sm text-gray-600 flex-grow mb-4">Popular Apps: IPTV Smarters Pro, TiviMate...</p>
         
        </a>
        <a href="#guide-item-windows" class="bg-white p-6 rounded-xl shadow-lg hover:shadow-xl transition-shadow duration-300 ease-in-out flex flex-col items-center text-center border border-gray-100 cursor-pointer" style="opacity: 1; transform: none;">
          <div class="text-blue-600 mb-4">
            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="w-12 h-12">
              <rect width="20" height="14" x="2" y="3" rx="2"></rect>
              <line x1="8" x2="16" y1="21" y2="21"></line>
              <line x1="12" x2="12" y1="17" y2="21"></line>
            </svg>
          </div>
          <h3 class="text-xl font-semibold text-gray-900 mb-2">Windows PCs &amp; Laptops</h3>
          <p class="text-sm text-gray-600 flex-grow mb-4">Popular Apps: VLC Media Player, IPTV Smarters Pro...</p>
         
        </a>
        <a href="#guide-item-ios" class="bg-white p-6 rounded-xl shadow-lg hover:shadow-xl transition-shadow duration-300 ease-in-out flex flex-col items-center text-center border border-gray-100 cursor-pointer" style="opacity: 1; transform: none;">
          <div class="text-blue-600 mb-4">
            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="w-12 h-12">
              <path d="M12 20.94c1.5 0 2.75 1.06 4 1.06 3 0 6-8 6-12.22A4.91 4.91 0 0 0 17 5c-2.22 0-4 1.44-5 2-1-.56-2.78-2-5-2a4.9 4.9 0 0 0-5 4.78C2 14 5 22 8 22c1.25 0 2.5-1.06 4-1.06Z"></path>
              <path d="M10 2c1 .5 2 2 2 5"></path>
            </svg>
          </div>
          <h3 class="text-xl font-semibold text-gray-900 mb-2">iOS (iPhones, iPads, Apple TV)</h3>
          <p class="text-sm text-gray-600 flex-grow mb-4">Popular Apps: GSE Smart IPTV, IPTV Smarters Player...</p>
       
        </a>
        <a href="#guide-item-mac" class="bg-white p-6 rounded-xl shadow-lg hover:shadow-xl transition-shadow duration-300 ease-in-out flex flex-col items-center text-center border border-gray-100 cursor-pointer" style="opacity: 1; transform: none;">
          <div class="text-blue-600 mb-4">
            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="w-12 h-12">
              <path d="M20 16V7a2 2 0 0 0-2-2H6a2 2 0 0 0-2 2v9m16 0H4m16 0 1.28 2.55a1 1 0 0 1-.9 1.45H3.62a1 1 0 0 1-.9-1.45L4 16"></path>
            </svg>
          </div>
          <h3 class="text-xl font-semibold text-gray-900 mb-2">macOS (MacBooks, iMacs)</h3>
          <p class="text-sm text-gray-600 flex-grow mb-4">Popular Apps: VLC Media Player, GSE Smart IPTV...</p>
        
        </a>
        <a href="#guide-item-mag" class="bg-white p-6 rounded-xl shadow-lg hover:shadow-xl transition-shadow duration-300 ease-in-out flex flex-col items-center text-center border border-gray-100 cursor-pointer" style="opacity: 1; transform: none;">
          <div class="text-blue-600 mb-4">
            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="w-12 h-12">
              <path d="M21 8a2 2 0 0 0-1-1.73l-7-4a2 2 0 0 0-2 0l-7 4A2 2 0 0 0 3 8v8a2 2 0 0 0 1 1.73l7 4a2 2 0 0 0 2 0l7-4A2 2 0 0 0 21 16Z"></path>
              <path d="m3.3 7 8.7 5 8.7-5"></path>
              <path d="M12 22V12"></path>
            </svg>
          </div>
          <h3 class="text-xl font-semibold text-gray-900 mb-2">MAG Devices (STB, TVIP, Formuler)</h3>
          <p class="text-sm text-gray-600 flex-grow mb-4">Popular Apps: STB Emulator, Built-in MAG Portal</p>
         
        </a>
        <a href="#guide-item-enigma2" class="bg-white p-6 rounded-xl shadow-lg hover:shadow-xl transition-shadow duration-300 ease-in-out flex flex-col items-center text-center border border-gray-100 cursor-pointer" style="opacity: 1; transform: none;">
          <div class="text-blue-600 mb-4">
            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="w-12 h-12">
              <path d="M13 7 9 3 5 7l4 4"></path>
              <path d="m17 11 4 4-4 4-4-4"></path>
              <path d="m8 12 4 4 6-6-4-4Z"></path>
              <path d="m16 8 3-3"></path>
              <path d="M9 21a6 6 0 0 0-6-6"></path>
            </svg>
          </div>
          <h3 class="text-xl font-semibold text-gray-900 mb-2">Enigma2 / ZGEMMA</h3>
          <p class="text-sm text-gray-600 flex-grow mb-4">Popular Apps: PuTTY (Telnet/SSH), FileZilla (FTP)...</p>
         
        </a>
        <a href="#guide-item-chromecast" class="bg-white p-6 rounded-xl shadow-lg hover:shadow-xl transition-shadow duration-300 ease-in-out flex flex-col items-center text-center border border-gray-100 cursor-pointer" style="opacity: 1; transform: none;">
          <div class="text-blue-600 mb-4">
            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="w-12 h-12">
              <path d="M2 8V6a2 2 0 0 1 2-2h16a2 2 0 0 1 2 2v12a2 2 0 0 1-2 2h-6"></path>
              <path d="M2 12a9 9 0 0 1 8 8"></path>
              <path d="M2 16a5 5 0 0 1 4 4"></path>
              <line x1="2" x2="2.01" y1="20" y2="20"></line>
            </svg>
          </div>
          <h3 class="text-xl font-semibold text-gray-900 mb-2">Chromecast with Google TV</h3>
          <p class="text-sm text-gray-600 flex-grow mb-4">Popular Apps: IPTV Smarters Pro, TiviMate...</p>
        
        </a>
      </div>
      <h2 class="text-3xl sm:text-4xl font-extrabold text-center mb-12 text-gray-900">Detailed Setup Instructions</h2>
      <div class="w-full space-y-6" data-orientation="vertical">
        <div id="guide-item-firestick" style="opacity: 1; transform: none;">
          <div data-state="closed" data-orientation="vertical" class="rounded-xl shadow-xl overflow-hidden transition-colors duration-200 border bg-gray-50 border-gray-200 hover:bg-gray-100">
            <h3 data-orientation="vertical" data-state="closed" class="flex">
              <button type="button" aria-controls="radix-:r1:" aria-expanded="false" data-state="closed" data-orientation="vertical" id="radix-:r0:" class="flex flex-1 items-center justify-between transition-all hover:underline [&amp;[data-state=open]&gt;svg]:rotate-180 px-6 py-4 text-left text-lg font-semibold w-full text-gray-800 hover:text-blue-600" data-radix-collection-item="">
                <div class="flex items-center">
                  <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="w-8 h-8 text-blue-600">
                    <path d="M21 8a2 2 0 0 0-1-1.73l-7-4a2 2 0 0 0-2 0l-7 4A2 2 0 0 0 3 8v8a2 2 0 0 0 1 1.73l7 4a2 2 0 0 0 2 0l7-4A2 2 0 0 0 21 16Z"></path>
                    <path d="m3.3 7 8.7 5 8.7-5"></path>
                    <path d="M12 22V12"></path>
                  </svg>
                  <span class="ml-3">Firestick / Fire TV / Fire Cube</span>
                </div>
                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-4 w-4 shrink-0 transition-transform duration-200">
                  <path d="m6 9 6 6 6-6"></path>
                </svg>
              </button>
            </h3>
            <div data-state="closed" id="radix-:r1:" hidden="" role="region" aria-labelledby="radix-:r0:" data-orientation="vertical" class="overflow-hidden text-sm transition-all data-[state=closed]:animate-accordion-up data-[state=open]:animate-accordion-down px-6 pt-0 pb-6 bg-white text-gray-700" style="--radix-accordion-content-height: var(--radix-collapsible-content-height); --radix-accordion-content-width: var(--radix-collapsible-content-width);">
              
<div class="pb-4 pt-0"><div class="prose prose-sm max-w-none"><p class="mb-4">Follow these steps to install <?php echo e($setting->webname); ?> IPTV on your Firestick / Fire TV / Fire Cube:</p><ol class="list-decimal pl-5 space-y-2"><li>Enable 'Apps from Unknown Sources' in your Firestick settings.</li><li>Install the 'Downloader' app from the Amazon Appstore.</li><li>Use Downloader to install your preferred IPTV app (e.g., IPTV Smarters Pro).</li><li>Open the IPTV app and log in with your <?php echo e($setting->webname); ?> IPTV credentials.</li><li>For a detailed, step-by-step walkthrough, click the button below.</li></ol><p class="mt-4">Recommended Apps: <strong>IPTV Smarters Pro (APK), TiviMate (APK), XCIPTV (APK)</strong></p><p class="mt-4 text-xs">Note: App availability and exact steps might vary slightly depending on your device model and software version. Always refer to the subscription email from <?php echo e($setting->webname); ?> IPTV for specific links or credentials.</p></div></div>


            </div>
          </div>
        </div>
        <div id="guide-item-android-devices" style="opacity: 1; transform: none;">
          <div data-state="closed" data-orientation="vertical" class="rounded-xl shadow-xl overflow-hidden transition-colors duration-200 border bg-gray-50 border-gray-200 hover:bg-gray-100">
            <h3 data-orientation="vertical" data-state="closed" class="flex">
              <button type="button" aria-controls="radix-:r3:" aria-expanded="false" data-state="closed" data-orientation="vertical" id="radix-:r2:" class="flex flex-1 items-center justify-between transition-all hover:underline [&amp;[data-state=open]&gt;svg]:rotate-180 px-6 py-4 text-left text-lg font-semibold w-full text-gray-800 hover:text-blue-600" data-radix-collection-item="">
                <div class="flex items-center">
                  <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="w-8 h-8 text-blue-600">
                    <rect width="14" height="20" x="5" y="2" rx="2" ry="2"></rect>
                    <path d="M12 18h.01"></path>
                  </svg>
                  <span class="ml-3">Android Devices (Phones, Boxes, TVs)</span>
                </div>
                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-4 w-4 shrink-0 transition-transform duration-200">
                  <path d="m6 9 6 6 6-6"></path>
                </svg>
              </button>
            </h3>
            <div data-state="closed" id="radix-:r3:" hidden="" role="region" aria-labelledby="radix-:r2:" data-orientation="vertical" class="overflow-hidden text-sm transition-all data-[state=closed]:animate-accordion-up data-[state=open]:animate-accordion-down px-6 pt-0 pb-6 bg-white text-gray-700" style="--radix-accordion-content-height: var(--radix-collapsible-content-height); --radix-accordion-content-width: var(--radix-collapsible-content-width);">

<div class="pb-4 pt-0"><div class="prose prose-sm max-w-none"><p class="mb-4">Follow these steps to install <?php echo e($setting->webname); ?> IPTV on your Android Devices (Phones, Boxes, TVs):</p><ol class="list-decimal pl-5 space-y-2"><li>Open the Google Play Store on your Android device (Phone, Tablet, TV, or Box).</li><li>Search for an IPTV player app. Recommended: 'IPTV Smarters Pro', 'TiviMate', 'Perfect Player', 'GSE Smart IPTV'.</li><li>Download and install your preferred app.</li><li>Open the app and choose to add a playlist or log in.</li><li>Enter your <?php echo e($setting->webname); ?> IPTV M3U URL or Xtream Codes API credentials from your subscription email.</li><li>The channels will load. Enjoy streaming!</li></ol><p class="mt-4">Recommended Apps: <strong>IPTV Smarters Pro, TiviMate, GSE Smart IPTV, Perfect Player, VLC Media Player</strong></p><p class="mt-4 text-xs">Note: App availability and exact steps might vary slightly depending on your device model and software version. Always refer to the subscription email from <?php echo e($setting->webname); ?> IPTV for specific links or credentials.</p></div></div>
            </div>
          </div>
        </div>
        <div id="guide-item-smart-tv" style="opacity: 1; transform: none;">
          <div data-state="closed" data-orientation="vertical" class="rounded-xl shadow-xl overflow-hidden transition-colors duration-200 border bg-gray-50 border-gray-200 hover:bg-gray-100">
            <h3 data-orientation="vertical" data-state="closed" class="flex">
              <button type="button" aria-controls="radix-:r5:" aria-expanded="false" data-state="closed" data-orientation="vertical" id="radix-:r4:" class="flex flex-1 items-center justify-between transition-all hover:underline [&amp;[data-state=open]&gt;svg]:rotate-180 px-6 py-4 text-left text-lg font-semibold w-full text-gray-800 hover:text-blue-600" data-radix-collection-item="">
                <div class="flex items-center">
                  <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="w-8 h-8 text-blue-600">
                    <rect width="20" height="15" x="2" y="7" rx="2" ry="2"></rect>
                    <polyline points="17 2 12 7 7 2"></polyline>
                  </svg>
                  <span class="ml-3">Smart TVs (All Brands)</span>
                </div>
                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-4 w-4 shrink-0 transition-transform duration-200">
                  <path d="m6 9 6 6 6-6"></path>
                </svg>
              </button>
            </h3>
            <div data-state="closed" id="radix-:r5:" hidden="" role="region" aria-labelledby="radix-:r4:" data-orientation="vertical" class="overflow-hidden text-sm transition-all data-[state=closed]:animate-accordion-up data-[state=open]:animate-accordion-down px-6 pt-0 pb-6 bg-white text-gray-700" style="--radix-accordion-content-height: var(--radix-collapsible-content-height); --radix-accordion-content-width: var(--radix-collapsible-content-width);">
<div class="pb-4 pt-0"><div class="prose prose-sm max-w-none"><p class="mb-4">Follow these steps to install <?php echo e($setting->webname); ?> IPTV on your Smart TVs (All Brands):</p><ol class="list-decimal pl-5 space-y-2"><li>Turn on your Smart TV (Samsung, LG, Sony, etc.) and ensure it's connected to the internet.</li><li>Navigate to your TV's App Store (e.g., Samsung App Store, LG Content Store).</li><li>Search for an IPTV player app. Recommended: 'IPTV Smarters Pro', 'TiviMate', 'GSE Smart IPTV', or 'Smart IPTV (SIPTV)'.</li><li>Download and install your chosen app.</li><li>Open the app. You will be asked to add a playlist using an M3U URL or log in with Xtream Codes API.</li><li>Enter the details provided by <?php echo e($setting->webname); ?> IPTV in your subscription email.</li><li>For the 'Smart IPTV (SIPTV)' app, you must visit their website (siptv.app), enter your TV's MAC address, and upload the M3U playlist URL we provide.</li><li>Once configured, the channels will load. Enjoy!</li></ol><p class="mt-4">Recommended Apps: <strong>IPTV Smarters Pro, TiviMate, GSE Smart IPTV, Smart IPTV (SIPTV)</strong></p><p class="mt-4 text-xs">Note: App availability and exact steps might vary slightly depending on your device model and software version. Always refer to the subscription email from <?php echo e($setting->webname); ?> IPTV for specific links or credentials.</p></div></div>

            </div>
          </div>
        </div>
        <div id="guide-item-windows" style="opacity: 1; transform: none;">
          <div data-state="closed" data-orientation="vertical" class="rounded-xl shadow-xl overflow-hidden transition-colors duration-200 border bg-gray-50 border-gray-200 hover:bg-gray-100">
            <h3 data-orientation="vertical" data-state="closed" class="flex">
              <button type="button" aria-controls="radix-:r7:" aria-expanded="false" data-state="closed" data-orientation="vertical" id="radix-:r6:" class="flex flex-1 items-center justify-between transition-all hover:underline [&amp;[data-state=open]&gt;svg]:rotate-180 px-6 py-4 text-left text-lg font-semibold w-full text-gray-800 hover:text-blue-600" data-radix-collection-item="">
                <div class="flex items-center">
                  <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="w-8 h-8 text-blue-600">
                    <rect width="20" height="14" x="2" y="3" rx="2"></rect>
                    <line x1="8" x2="16" y1="21" y2="21"></line>
                    <line x1="12" x2="12" y1="17" y2="21"></line>
                  </svg>
                  <span class="ml-3">Windows PCs &amp; Laptops</span>
                </div>
                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-4 w-4 shrink-0 transition-transform duration-200">
                  <path d="m6 9 6 6 6-6"></path>
                </svg>
              </button>
            </h3>
            <div data-state="closed" id="radix-:r7:" hidden="" role="region" aria-labelledby="radix-:r6:" data-orientation="vertical" class="overflow-hidden text-sm transition-all data-[state=closed]:animate-accordion-up data-[state=open]:animate-accordion-down px-6 pt-0 pb-6 bg-white text-gray-700" style="--radix-accordion-content-height: var(--radix-collapsible-content-height); --radix-accordion-content-width: var(--radix-collapsible-content-width);"><div class="pb-4 pt-0"><div class="prose prose-sm max-w-none"><p class="mb-4">Follow these steps to install <?php echo e($setting->webname); ?> IPTV on your Windows PCs &amp; Laptops:</p><ol class="list-decimal pl-5 space-y-2"><li>Download an IPTV player for Windows. Recommended: 'VLC Media Player', 'IPTV Smarters Pro for Windows', or 'MyIPTV Player' (from Microsoft Store).</li><li>Install the player on your PC.</li><li>For VLC: Open VLC &gt; Media &gt; Open Network Stream. Paste your M3U URL and click Play.</li><li>For IPTV Smarters Pro: Download from their official website, install, and log in with your Xtream Codes API or M3U URL.</li><li>For MyIPTV Player: Install from Microsoft Store. Go to Settings &gt; Add new playlist and remote source. Enter your M3U URL and a name for the playlist.</li><li>Your channels will load. Enjoy watching!</li></ol><p class="mt-4">Recommended Apps: <strong>VLC Media Player, IPTV Smarters Pro, MyIPTV Player, Kodi</strong></p><p class="mt-4 text-xs">Note: App availability and exact steps might vary slightly depending on your device model and software version. Always refer to the subscription email from <?php echo e($setting->webname); ?> IPTV for specific links or credentials.</p></div></div></div>
          </div>
        </div>
        <div id="guide-item-ios" style="opacity: 1; transform: none;">
          <div data-state="closed" data-orientation="vertical" class="rounded-xl shadow-xl overflow-hidden transition-colors duration-200 border bg-gray-50 border-gray-200 hover:bg-gray-100">
            <h3 data-orientation="vertical" data-state="closed" class="flex">
              <button type="button" aria-controls="radix-:r9:" aria-expanded="false" data-state="closed" data-orientation="vertical" id="radix-:r8:" class="flex flex-1 items-center justify-between transition-all hover:underline [&amp;[data-state=open]&gt;svg]:rotate-180 px-6 py-4 text-left text-lg font-semibold w-full text-gray-800 hover:text-blue-600" data-radix-collection-item="">
                <div class="flex items-center">
                  <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="w-8 h-8 text-blue-600">
                    <path d="M12 20.94c1.5 0 2.75 1.06 4 1.06 3 0 6-8 6-12.22A4.91 4.91 0 0 0 17 5c-2.22 0-4 1.44-5 2-1-.56-2.78-2-5-2a4.9 4.9 0 0 0-5 4.78C2 14 5 22 8 22c1.25 0 2.5-1.06 4-1.06Z"></path>
                    <path d="M10 2c1 .5 2 2 2 5"></path>
                  </svg>
                  <span class="ml-3">iOS (iPhones, iPads, Apple TV)</span>
                </div>
                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-4 w-4 shrink-0 transition-transform duration-200">
                  <path d="m6 9 6 6 6-6"></path>
                </svg>
              </button>
            </h3>
            <div data-state="closed" id="radix-:r9:" hidden="" role="region" aria-labelledby="radix-:r8:" data-orientation="vertical" class="overflow-hidden text-sm transition-all data-[state=closed]:animate-accordion-up data-[state=open]:animate-accordion-down px-6 pt-0 pb-6 bg-white text-gray-700" style="--radix-accordion-content-height: var(--radix-collapsible-content-height); --radix-accordion-content-width: var(--radix-collapsible-content-width);"><div class="pb-4 pt-0"><div class="prose prose-sm max-w-none"><p class="mb-4">Follow these steps to install <?php echo e($setting->webname); ?> IPTV on your iOS (iPhones, iPads, Apple TV):</p><ol class="list-decimal pl-5 space-y-2"><li>Open the App Store on your iPhone, iPad, or Apple TV.</li><li>Search for an IPTV player. Recommended apps: 'GSE Smart IPTV', 'IPTV Smarters Player', 'iPlayTV' (Apple TV - paid).</li><li>Download and install the app.</li><li>Open the app and look for an option to add a playlist ('+' icon) or log in.</li><li>Enter the M3U URL or Xtream Codes API details provided by <?php echo e($setting->webname); ?> IPTV.</li><li>Your channels will appear. Start watching!</li></ol><p class="mt-4">Recommended Apps: <strong>GSE Smart IPTV, IPTV Smarters Player, iPlayTV (Apple TV - paid), Cloud Stream IPTV Player</strong></p><p class="mt-4 text-xs">Note: App availability and exact steps might vary slightly depending on your device model and software version. Always refer to the subscription email from <?php echo e($setting->webname); ?> IPTV for specific links or credentials.</p></div></div></div>
          </div>
        </div>
        <div id="guide-item-mac" style="opacity: 1; transform: none;">
          <div data-state="closed" data-orientation="vertical" class="rounded-xl shadow-xl overflow-hidden transition-colors duration-200 border bg-gray-50 border-gray-200 hover:bg-gray-100">
            <h3 data-orientation="vertical" data-state="closed" class="flex">
              <button type="button" aria-controls="radix-:rb:" aria-expanded="false" data-state="closed" data-orientation="vertical" id="radix-:ra:" class="flex flex-1 items-center justify-between transition-all hover:underline [&amp;[data-state=open]&gt;svg]:rotate-180 px-6 py-4 text-left text-lg font-semibold w-full text-gray-800 hover:text-blue-600" data-radix-collection-item="">
                <div class="flex items-center">
                  <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="w-8 h-8 text-blue-600">
                    <path d="M20 16V7a2 2 0 0 0-2-2H6a2 2 0 0 0-2 2v9m16 0H4m16 0 1.28 2.55a1 1 0 0 1-.9 1.45H3.62a1 1 0 0 1-.9-1.45L4 16"></path>
                  </svg>
                  <span class="ml-3">macOS (MacBooks, iMacs)</span>
                </div>
                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-4 w-4 shrink-0 transition-transform duration-200">
                  <path d="m6 9 6 6 6-6"></path>
                </svg>
              </button>
            </h3>
            <div data-state="closed" id="radix-:rb:" hidden="" role="region" aria-labelledby="radix-:ra:" data-orientation="vertical" class="overflow-hidden text-sm transition-all data-[state=closed]:animate-accordion-up data-[state=open]:animate-accordion-down px-6 pt-0 pb-6 bg-white text-gray-700" style="--radix-accordion-content-height: var(--radix-collapsible-content-height); --radix-accordion-content-width: var(--radix-collapsible-content-width);"><div class="pb-4 pt-0"><div class="prose prose-sm max-w-none"><p class="mb-4">Follow these steps to install <?php echo e($setting->webname); ?> IPTV on your macOS (MacBooks, iMacs):</p><ol class="list-decimal pl-5 space-y-2"><li>Download an IPTV player for macOS. Recommended: 'VLC Media Player', 'GSE Smart IPTV' (from App Store), or 'IPTV Smarters Pro'.</li><li>Install your chosen application.</li><li>For VLC: Open VLC &gt; File &gt; Open Network. Paste your M3U URL and click Open.</li><li>For GSE Smart IPTV / IPTV Smarters: Open the app and log in using the Xtream Codes API or M3U URL from your subscription email.</li><li>Your playlist will load, and you can start streaming.</li></ol><p class="mt-4">Recommended Apps: <strong>VLC Media Player, GSE Smart IPTV, IPTV Smarters Pro, Kodi</strong></p><p class="mt-4 text-xs">Note: App availability and exact steps might vary slightly depending on your device model and software version. Always refer to the subscription email from <?php echo e($setting->webname); ?> IPTV for specific links or credentials.</p></div></div></div>
          </div>
        </div>
        <div id="guide-item-mag" style="opacity: 1; transform: none;">
          <div data-state="closed" data-orientation="vertical" class="rounded-xl shadow-xl overflow-hidden transition-colors duration-200 border bg-gray-50 border-gray-200 hover:bg-gray-100">
            <h3 data-orientation="vertical" data-state="closed" class="flex">
              <button type="button" aria-controls="radix-:rd:" aria-expanded="false" data-state="closed" data-orientation="vertical" id="radix-:rc:" class="flex flex-1 items-center justify-between transition-all hover:underline [&amp;[data-state=open]&gt;svg]:rotate-180 px-6 py-4 text-left text-lg font-semibold w-full text-gray-800 hover:text-blue-600" data-radix-collection-item="">
                <div class="flex items-center">
                  <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="w-8 h-8 text-blue-600">
                    <path d="M21 8a2 2 0 0 0-1-1.73l-7-4a2 2 0 0 0-2 0l-7 4A2 2 0 0 0 3 8v8a2 2 0 0 0 1 1.73l7 4a2 2 0 0 0 2 0l7-4A2 2 0 0 0 21 16Z"></path>
                    <path d="m3.3 7 8.7 5 8.7-5"></path>
                    <path d="M12 22V12"></path>
                  </svg>
                  <span class="ml-3">MAG Devices (STB, TVIP, Formuler)</span>
                </div>
                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-4 w-4 shrink-0 transition-transform duration-200">
                  <path d="m6 9 6 6 6-6"></path>
                </svg>
              </button>
            </h3>
            <div data-state="closed" id="radix-:rd:" hidden="" role="region" aria-labelledby="radix-:rc:" data-orientation="vertical" class="overflow-hidden text-sm transition-all data-[state=closed]:animate-accordion-up data-[state=open]:animate-accordion-down px-6 pt-0 pb-6 bg-white text-gray-700" style="--radix-accordion-content-height: var(--radix-collapsible-content-height); --radix-accordion-content-width: var(--radix-collapsible-content-width);"><div class="pb-4 pt-0"><div class="prose prose-sm max-w-none"><p class="mb-4">Follow these steps to install <?php echo e($setting->webname); ?> IPTV on your MAG Devices (STB, TVIP, Formuler):</p><ol class="list-decimal pl-5 space-y-2"><li>Connect your MAG box to your TV and internet.</li><li>Go to Settings &gt; System Settings &gt; Servers &gt; Portals.</li><li>For 'Portal 1' (or an empty portal), enter the Portal URL provided by <?php echo e($setting->webname); ?> IPTV in your subscription email.</li><li>Save and reboot the device/portal.</li><li>The portal should load, giving you access to channels.</li><li>For STB Emulator App: Install the app. Go to Settings &gt; Profiles &gt; Add Profile. Configure the MAC address (we will advise if needed, often starts with 00:1A:79:XX:XX:XX) and the Portal URL.</li><li>Save and load the profile.</li></ol><p class="mt-4">Recommended Apps: <strong>STB Emulator, Built-in MAG Portal</strong></p><p class="mt-4 text-xs">Note: App availability and exact steps might vary slightly depending on your device model and software version. Always refer to the subscription email from <?php echo e($setting->webname); ?> IPTV for specific links or credentials.</p></div></div></div>
          </div>
        </div>
        <div id="guide-item-enigma2" style="opacity: 1; transform: none;">
          <div data-state="closed" data-orientation="vertical" class="rounded-xl shadow-xl overflow-hidden transition-colors duration-200 border bg-gray-50 border-gray-200 hover:bg-gray-100">
            <h3 data-orientation="vertical" data-state="closed" class="flex">
              <button type="button" aria-controls="radix-:rf:" aria-expanded="false" data-state="closed" data-orientation="vertical" id="radix-:re:" class="flex flex-1 items-center justify-between transition-all hover:underline [&amp;[data-state=open]&gt;svg]:rotate-180 px-6 py-4 text-left text-lg font-semibold w-full text-gray-800 hover:text-blue-600" data-radix-collection-item="">
                <div class="flex items-center">
                  <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="w-8 h-8 text-blue-600">
                    <path d="M13 7 9 3 5 7l4 4"></path>
                    <path d="m17 11 4 4-4 4-4-4"></path>
                    <path d="m8 12 4 4 6-6-4-4Z"></path>
                    <path d="m16 8 3-3"></path>
                    <path d="M9 21a6 6 0 0 0-6-6"></path>
                  </svg>
                  <span class="ml-3">Enigma2 / ZGEMMA</span>
                </div>
                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-4 w-4 shrink-0 transition-transform duration-200">
                  <path d="m6 9 6 6 6-6"></path>
                </svg>
              </button>
            </h3>
            <div data-state="closed" id="radix-:rf:" hidden="" role="region" aria-labelledby="radix-:re:" data-orientation="vertical" class="overflow-hidden text-sm transition-all data-[state=closed]:animate-accordion-up data-[state=open]:animate-accordion-down px-6 pt-0 pb-6 bg-white text-gray-700" style="--radix-accordion-content-height: var(--radix-collapsible-content-height); --radix-accordion-content-width: var(--radix-collapsible-content-width);"><div class="pb-4 pt-0"><div class="prose prose-sm max-w-none"><p class="mb-4">Follow these steps to install <?php echo e($setting->webname); ?> IPTV on your Enigma2 / ZGEMMA:</p><ol class="list-decimal pl-5 space-y-2"><li>Ensure your Enigma2 device is connected to your network.</li><li>Using a computer on the same network, connect to your device via an FTP client (like FileZilla) or SSH (like PuTTY).</li><li>Navigate to the '/etc/enigma2/' directory.</li><li>You will need to create a bouquet file (e.g., 'userbouquet.<?php echo e($setting->webname); ?>') and add it to the 'bouquets.tv' file.</li><li>Alternatively, use a script command. <?php echo e($setting->webname); ?> IPTV will provide the exact script/command line to run via Telnet/PuTTY.</li><li>After running the command or uploading the files, restart the Enigma2 GUI (Graphical User Interface).</li><li>Your <?php echo e($setting->webname); ?> IPTV channels will appear in your channel list.</li></ol><p class="mt-4">Recommended Apps: <strong>PuTTY (Telnet/SSH), FileZilla (FTP), JediMaker Xtream</strong></p><p class="mt-4 text-xs">Note: App availability and exact steps might vary slightly depending on your device model and software version. Always refer to the subscription email from <?php echo e($setting->webname); ?> IPTV for specific links or credentials.</p></div></div></div>
          </div>
        </div>
        <div id="guide-item-chromecast" style="opacity: 1; transform: none;">
          <div data-state="closed" data-orientation="vertical" class="rounded-xl shadow-xl overflow-hidden transition-colors duration-200 border bg-gray-50 border-gray-200 hover:bg-gray-100">
            <h3 data-orientation="vertical" data-state="closed" class="flex">
              <button type="button" aria-controls="radix-:rh:" aria-expanded="false" data-state="closed" data-orientation="vertical" id="radix-:rg:" class="flex flex-1 items-center justify-between transition-all hover:underline [&amp;[data-state=open]&gt;svg]:rotate-180 px-6 py-4 text-left text-lg font-semibold w-full text-gray-800 hover:text-blue-600" data-radix-collection-item="">
                <div class="flex items-center">
                  <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="w-8 h-8 text-blue-600">
                    <path d="M2 8V6a2 2 0 0 1 2-2h16a2 2 0 0 1 2 2v12a2 2 0 0 1-2 2h-6"></path>
                    <path d="M2 12a9 9 0 0 1 8 8"></path>
                    <path d="M2 16a5 5 0 0 1 4 4"></path>
                    <line x1="2" x2="2.01" y1="20" y2="20"></line>
                  </svg>
                  <span class="ml-3">Chromecast with Google TV</span>
                </div>
                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-4 w-4 shrink-0 transition-transform duration-200">
                  <path d="m6 9 6 6 6-6"></path>
                </svg>
              </button>
            </h3>
            <div data-state="closed" id="radix-:rh:" hidden="" role="region" aria-labelledby="radix-:rg:" data-orientation="vertical" class="overflow-hidden text-sm transition-all data-[state=closed]:animate-accordion-up data-[state=open]:animate-accordion-down px-6 pt-0 pb-6 bg-white text-gray-700" style="--radix-accordion-content-height: var(--radix-collapsible-content-height); --radix-accordion-content-width: var(--radix-collapsible-content-width);"><div class="pb-4 pt-0"><div class="prose prose-sm max-w-none"><p class="mb-4">Follow these steps to install <?php echo e($setting->webname); ?> IPTV on your Chromecast with Google TV:</p><ol class="list-decimal pl-5 space-y-2"><li>Since Chromecast with Google TV runs on Android TV OS, the process is the same as for other Android TV devices.</li><li>From the Google TV home screen, go to the 'Apps' tab.</li><li>Search for an IPTV player like 'IPTV Smarters Pro', 'TiviMate', or 'GSE Smart IPTV'.</li><li>Install your chosen app from the Play Store.</li><li>Open the app and log in using the M3U URL or Xtream Codes API details from your <?php echo e($setting->webname); ?> IPTV subscription email.</li><li>For older Chromecasts (without Google TV), you must cast from another device. Install an IPTV app on your phone, load the playlist, and use the 'Cast' icon to send the stream to your Chromecast.</li></ol><p class="mt-4">Recommended Apps: <strong>IPTV Smarters Pro, TiviMate, GSE Smart IPTV, BubbleUPnP (for casting)</strong></p><p class="mt-4 text-xs">Note: App availability and exact steps might vary slightly depending on your device model and software version. Always refer to the subscription email from <?php echo e($setting->webname); ?> IPTV for specific links or credentials.</p></div></div></div>
          </div>
        </div>
      </div>



<script>
  document.querySelectorAll('[data-radix-collection-item]').forEach(button => {
    button.addEventListener('click', () => {
      const contentId = button.getAttribute('aria-controls');
      const content = document.getElementById(contentId);

      const isOpen = button.getAttribute('aria-expanded') === 'true';

      // Close all other items (optional if you want only one open at a time)
      document.querySelectorAll('[data-radix-collection-item]').forEach(btn => {
        btn.setAttribute('aria-expanded', 'false');
        btn.setAttribute('data-state', 'closed');
      });
      document.querySelectorAll('[role="region"]').forEach(panel => {
        panel.setAttribute('data-state', 'closed');
        panel.hidden = true;
      });

      if (!isOpen) {
        button.setAttribute('aria-expanded', 'true');
        button.setAttribute('data-state', 'open');
        content.setAttribute('data-state', 'open');
        content.hidden = false;
      } else {
        button.setAttribute('aria-expanded', 'false');
        button.setAttribute('data-state', 'closed');
        content.setAttribute('data-state', 'closed');
        content.hidden = true;
      }
    });
  });
</script>

<style>
  button[data-state="open"] svg:last-child {
  transform: rotate(180deg);
  transition: transform 0.3s;
}

</style>






      <div class="mt-16 p-8 rounded-xl shadow-xl bg-gray-100 border border-gray-200" style="opacity: 1;">
        <h2 class="text-2xl font-bold mb-6 text-center text-gray-900">Troubleshooting Tips</h2>
        <ul class="space-y-3">
          <li class="flex items-start p-4 rounded-lg shadow-sm bg-white text-gray-700" style="opacity: 1; transform: none;">
            <div class="flex-shrink-0 mt-1">
              <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="w-5 h-5 mr-3 text-red-500">
                <line x1="2" x2="22" y1="2" y2="22"></line>
                <path d="M8.5 16.5a5 5 0 0 1 7 0"></path>
                <path d="M2 8.82a15 15 0 0 1 4.17-2.65"></path>
                <path d="M10.66 5c4.01-.36 8.14.9 11.34 3.76"></path>
                <path d="M16.85 11.25a10 10 0 0 1 2.22 1.68"></path>
                <path d="M5 13a10 10 0 0 1 5.24-2.76"></path>
                <line x1="12" x2="12.01" y1="20" y2="20"></line>
              </svg>
            </div>
            <span>Check your internet connection. A stable connection of at least 15-20 Mbps is recommended for HD streaming.</span>
          </li>
          <li class="flex items-start p-4 rounded-lg shadow-sm bg-white text-gray-700" style="opacity: 1; transform: none;">
            <div class="flex-shrink-0 mt-1">
              <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="w-5 h-5 mr-3 text-yellow-500">
                <path d="m21.73 18-8-14a2 2 0 0 0-3.48 0l-8 14A2 2 0 0 0 4 21h16a2 2 0 0 0 1.73-3Z"></path>
                <path d="M12 9v4"></path>
                <path d="M12 17h.01"></path>
              </svg>
            </div>
            <span>Ensure your M3U URL or Xtream Codes API details are entered correctly. They are case-sensitive.</span>
          </li>
          <li class="flex items-start p-4 rounded-lg shadow-sm bg-white text-gray-700" style="opacity: 1; transform: none;">
            <div class="flex-shrink-0 mt-1">
              <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="w-5 h-5 mr-3 text-blue-500">
                <path d="M4 14.899A7 7 0 1 1 15.71 8h1.79a4.5 4.5 0 0 1 2.5 8.242"></path>
                <path d="M12 12v9"></path>
                <path d="m8 17 4 4 4-4"></path>
              </svg>
            </div>
            <span>Update your IPTV player app to the latest version.</span>
          </li>
          <li class="flex items-start p-4 rounded-lg shadow-sm bg-white text-gray-700" style="opacity: 1; transform: none;">
            <div class="flex-shrink-0 mt-1">
              <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="w-5 h-5 mr-3 text-green-500">
                <circle cx="12" cy="12" r="10"></circle>
                <polygon points="10 8 16 12 10 16 10 8"></polygon>
              </svg>
            </div>
            <span>Restart your device and your router/modem.</span>
          </li>
          <li class="flex items-start p-4 rounded-lg shadow-sm bg-white text-gray-700" style="opacity: 1; transform: none;">
            <div class="flex-shrink-0 mt-1">
              <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="w-5 h-5 mr-3 text-purple-500">
                <path d="m3 17 2 2 4-4"></path>
                <path d="m3 7 2 2 4-4"></path>
                <path d="M13 6h8"></path>
                <path d="M13 12h8"></path>
                <path d="M13 18h8"></path>
              </svg>
            </div>
            <span>If using a VPN, try connecting to a different server or temporarily disabling it to see if it resolves the issue (though we generally recommend using a VPN for privacy).</span>
          </li>
          <li class="flex items-start p-4 rounded-lg shadow-sm bg-white text-gray-700" style="opacity: 1; transform: none;">
            <div class="flex-shrink-0 mt-1">
              <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="w-5 h-5 mr-3 text-pink-500">
                <path d="m21.64 3.64-1.28-1.28a1.21 1.21 0 0 0-1.72 0L2.36 18.64a1.21 1.21 0 0 0 0 1.72l1.28 1.28a1.2 1.2 0 0 0 1.72 0L21.64 5.36a1.2 1.2 0 0 0 0-1.72Z"></path>
                <path d="m14 7 3 3"></path>
                <path d="M5 6v4"></path>
                <path d="M19 14v4"></path>
                <path d="M10 2v2"></path>
                <path d="M7 8H3"></path>
                <path d="M21 16h-4"></path>
                <path d="M11 3H9"></path>
              </svg>
            </div>
            <span>Clear the cache of your IPTV player app.</span>
          </li>
          <li class="flex items-start p-4 rounded-lg shadow-sm bg-white text-gray-700" style="opacity: 1; transform: none;">
            <div class="flex-shrink-0 mt-1">
              <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="w-5 h-5 mr-3 text-gray-500">
                <circle cx="12" cy="12" r="10"></circle>
                <path d="M12 16v-4"></path>
                <path d="M12 8h.01"></path>
              </svg>
            </div>
            <span>Some ISPs may block IPTV services. If you suspect this, a VPN can often help bypass these restrictions.</span>
          </li>
        </ul>
      </div>
      <div class="mt-16 text-center" style="opacity: 1; transform: none;">
        <div class="bg-gray-100 p-8 rounded-lg shadow-inner">
          <h3 class="text-2xl font-bold text-gray-800 mb-4">Still need help?</h3>
          <p class="text-lg text-gray-700 mb-6">Our expert support team is ready to assist you 24/7.</p>
          <a href="https://wa.me/<?php echo e($setting->whatsapp); ?>?text=Hello%20<?php echo e($setting->webname); ?>%20IPTV%2C%20I%20need%20help%20with%20installation." target="_blank" rel="noopener noreferrer" class="inline-flex items-center justify-center text-sm ring-offset-background focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-ring focus-visible:ring-offset-2 disabled:pointer-events-none disabled:opacity-50 h-11 rounded-md px-8 bg-blue-600 hover:bg-blue-700 text-white font-semibold shadow-lg transform hover:scale-105 transition-transform duration-200">
            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="w-5 h-5 mr-2">
              <path d="M21 15a2 2 0 0 1-2 2H7l-4 4V5a2 2 0 0 1 2-2h14a2 2 0 0 1 2 2z"></path>
            </svg> Contact Support via WhatsApp </a>
        </div>
      </div>
    </div>
  </div>
</main>
           <?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u882570979/domains/gbiptv.com/public_html/resources/views/website/service/installation.blade.php ENDPATH**/ ?>