  
<?php $__env->startSection('meta'); ?>  
<title>Acceptable Use Policy - <?php echo e($setting->webname); ?> IPTV | UK IPTV Guidelines</title>
<meta name="description" content="<?php echo e($setting->webname); ?> IPTV's Acceptable Use Policy (AUP). Guidelines for using our UK IPTV service responsibly, including prohibited activities and content responsibility.">
<meta name="keywords" content="<?php echo e($setting->webname); ?> IPTV AUP, IPTV acceptable use UK, UK IPTV rules, IPTV guidelines, responsible IPTV use">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?> 
  <main class="flex-grow">
  <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 py-12" style="opacity: 1; transform: none;">
    <h1 class="text-3xl font-extrabold text-gray-900 sm:text-4xl mb-8">Acceptable Use Policy</h1>
    <div class="prose prose-lg max-w-none text-gray-700">
           <h2 class="text-2xl font-bold mt-6 mb-3">1. Introduction</h2>
      <p>This Acceptable Use Policy ("AUP") governs your use of the <?php echo e($setting->webname); ?> IPTV service ("Service") provided via <a href="/" target="_blank" rel="noopener noreferrer" class="text-blue-600 hover:underline"><?php echo e($setting->webname); ?></a>. By using the Service, you agree to comply with this AUP and our <a class="text-blue-600 hover:underline" href="/terms-of-service">Terms of Service</a>. Violations of this AUP may result in suspension or termination of your access to the Service, without refund, and may also result in civil or criminal liability. </p>
      <h2 class="text-2xl font-bold mt-6 mb-3">2. Prohibited Activities</h2>
      <p>You may not use the Service to engage in, foster, or promote illegal, abusive, or irresponsible behavior, including but not limited to:</p>
      <ul class="list-disc pl-6">
        <li>
          <strong>Illegal Content:</strong> Accessing, distributing, or promoting content that is illegal under the laws of the United Kingdom or your local jurisdiction. This includes, but is not limited to, child pornography, incitement to violence, or content that infringes on intellectual property rights. For information on UK law, visit <a href="https://www.gov.uk/browse/justice/courts-sentencing-tribunals" target="_blank" rel="noopener noreferrer" class="text-blue-600 hover:underline">GOV.UK Justice</a>.
        </li>
        <li>
          <strong>Copyright Infringement:</strong> Transmitting, distributing, or storing any material in violation of any applicable law or regulation, including material protected by copyright, trademark, trade secret, or other intellectual property right used without proper authorization. Refer to our <a class="text-blue-600 hover:underline" href="/dmca">DMCA Policy</a>.
        </li>
        <li>
          <strong>Unauthorized Access:</strong> Accessing or using any system or network without permission, including attempting to probe, scan, or test the vulnerability of a system or network or to breach security or authentication measures.
        </li>
        <li>
          <strong>Reselling or Redistribution:</strong> Reselling, redistributing, or rebroadcasting the Service or any part of its content without explicit written permission from <?php echo e($setting->webname); ?> IPTV.
        </li>
        <li>
          <strong>Account Sharing:</strong> Sharing your account credentials with individuals outside your household or allowing unauthorized users to access your account. The number of simultaneous streams is limited by your subscription plan detailed on our <a class="text-blue-600 hover:underline" href="/pricing">Pricing Page</a>.
        </li>
        <li>
          <strong>Circumvention of Restrictions:</strong> Using VPNs, proxies, or other methods to circumvent geographical restrictions or access content not licensed for your region, if such use is intended to violate content licensing terms or applicable laws.
        </li>
        <li>
          <strong>Interference with Service:</strong> Any activity that interferes with or disrupts the Service or the servers and networks connected to the Service, including transmitting any worms, viruses, or any code of a destructive nature.
        </li>
        <li>
          <strong>Excessive Use:</strong> Consuming an unusually large amount of bandwidth or resources that negatively impacts the experience of other users, as determined by <?php echo e($setting->webname); ?> IPTV in its sole discretion.
        </li>
        <li>
          <strong>Misrepresentation:</strong> Impersonating any person or entity, or falsely stating or otherwise misrepresenting your affiliation with a person or entity.
        </li>
        <li>
          <strong>Harmful Activities:</strong> Engaging in any activity that is harmful to the Service, our users, or any third party, including distributing malware, phishing, or engaging in denial-of-service attacks. Information on reporting such activities can be found at <a href="https://www.ncsc.gov.uk/" target="_blank" rel="noopener noreferrer" class="text-blue-600 hover:underline">National Cyber Security Centre (NCSC)</a>.
        </li>
      </ul>
      <h2 class="text-2xl font-bold mt-6 mb-3">3. Content Responsibility</h2>
      <p><?php echo e($setting->webname); ?> IPTV acts as a conduit for a vast amount of content. We do not monitor or control the content accessed through our Service. You are solely responsible for the content you choose to access and for ensuring that your use of such content is lawful and compliant with this AUP and our <a class="text-blue-600 hover:underline" href="/terms-of-service">Terms of Service</a>. </p>
      <p>You acknowledge that by using the Service, you may be exposed to content that you find offensive, indecent, or objectionable. <?php echo e($setting->webname); ?> IPTV shall have no liability to you for content that may be found to be offensive, indecent, or objectionable.</p>
      <h2 class="text-2xl font-bold mt-6 mb-3">4. Enforcement</h2>
      <p><?php echo e($setting->webname); ?> IPTV reserves the right, but does not assume the obligation, to investigate any violation of this AUP or misuse of the Service. We may:</p>
      <ul class="list-disc pl-6">
        <li>Investigate violations of this AUP or misuse of the Service.</li>
        <li>Remove, block, filter, or restrict by any other means any materials that <?php echo e($setting->webname); ?> IPTV, in its sole discretion, deems to be in violation of this AUP or any applicable law.</li>
        <li>Suspend or terminate your access to the Service for violations of this AUP.</li>
        <li>Report any activity that we suspect violates any law or regulation to appropriate law enforcement officials, regulators, or other appropriate third parties.</li>
      </ul>
      <p>We reserve the right to act immediately and without notice to suspend or terminate your access if, in our sole judgment, your use of the Service may subject <?php echo e($setting->webname); ?> IPTV to immediate harm or liability.</p>
      <h2 class="text-2xl font-bold mt-6 mb-3">5. Reporting Violations</h2>
      <p>If you become aware of any violation of this AUP, you agree to notify <?php echo e($setting->webname); ?> IPTV immediately. You can report violations via the contact methods provided on our <a class="text-blue-600 hover:underline" href="/#contact">contact page</a>. </p>
      <h2 class="text-2xl font-bold mt-6 mb-3">6. Modifications</h2>
      <p><?php echo e($setting->webname); ?> IPTV reserves the right to modify this AUP at any time, effective upon posting of the modified AUP on our website. You are responsible for regularly reviewing this AUP. Continued use of the Service after any such changes shall constitute your consent to such changes.</p>
      <h2 class="text-2xl font-bold mt-6 mb-3">7. Contact Us</h2>
      <p>If you have any questions about this Acceptable Use Policy, please <a class="text-blue-600 hover:underline" href="/#contact">contact us</a>. </p>
    </div>
  </div>
</main>
    
   <?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u882570979/domains/gbiptv.com/public_html/resources/views/website/service/acceptable.blade.php ENDPATH**/ ?>