<?php

use Illuminate\Support\Facades\Route;



Auth::routes();





Route::get('/home', 'HomeController@index')->name('home');
Route::get('/blog', 'HomeController@blog')->name('blog');

// Front End Routes
Route::get('/', 'FrontEndController@home')->name('website');
Route::get('/blog', 'FrontEndController@blog')->name('website.blog');
Route::get('/about-us', 'FrontEndController@about')->name('website.about');
Route::get('/services', 'FrontEndController@services')->name('website.services');
Route::get('/team', 'FrontEndController@team')->name('website.team');
Route::get('/category/{slug}', 'FrontEndController@category')->name('website.category');

Route::get('/contact', 'FrontEndController@contact')->name('website.contact');
Route::get('/page/{slug}', 'FrontEndController@post')->name('website.post');

 // services routes
Route::get('/installation-guides', 'FrontEndController@installation')->name('website.service.installation');
Route::get('/pricing', 'FrontEndController@pricing')->name('website.service.pricing');
Route::get('/trial', 'FrontEndController@trial')->name('website.service.trial');
Route::get('/reviews', 'FrontEndController@reviews')->name('website.service.reviews');
Route::get('/terms-of-service', 'FrontEndController@terms')->name('website.service.terms');
Route::get('/privacy-policy', 'FrontEndController@policy')->name('website.service.policy');
Route::get('/refund-policy', 'FrontEndController@refund')->name('website.service.refund');
Route::get('/acceptable-use-policy', 'FrontEndController@acceptable')->name('website.service.acceptable');
Route::get('/gdpr-compliance', 'FrontEndController@gdpr')->name('website.service.gdpr');
Route::get('/dmca', 'FrontEndController@dmca')->name('website.service.dmca');
Route::get('/affiliate-marketing', 'FrontEndController@affiliate')->name('website.service.affiliate');


Route::get('tags', 'PostController@tag');
Route::get('tags/{title}', 'PostController@singletagdata');



Route::get('/post-tag/{title}', [App\Http\Controllers\FrontEndController::class, 'posttags'])->name('website.posttags');

Route::get('/adi.xml', 'FrontEndController@sitemap')->name('website.sitemap');








Route::post('/contact/send', 'FrontEndController@send_message')->name('website.contact.send');

// Admin Panel Routes
Route::group(['prefix' => 'admin', 'middleware' => ['auth']], function () {
    Route::get('/dashboard','DashboardController@index')->name('dashboard');

    Route::resource('category', 'CategoryController');
    Route::resource('tag', 'TagController');
    Route::resource('post', 'PostController');
    Route::resource('user', 'UserController');
    Route::get('/profile', 'UserController@profile')->name('user.profile');
    Route::post('/profile', 'UserController@profile_update')->name('user.profile.update');
    
    // setting
    Route::get('setting', 'SettingController@edit')->name('setting.index');
    Route::post('setting', 'SettingController@update')->name('setting.update');

    // Contact message
    Route::get('/contact', 'ContactController@index')->name('contact.index');
    Route::get('/contact/show/{id}', 'ContactController@show')->name('contact.show');
    Route::delete('/contact/delete/{id}', 'ContactController@destroy')->name('contact.destroy');
});



