@extends('layouts.master')  
@section('meta')  
<title>IPTV Pricing Plans - {{ $setting->webname }} | Affordable UK IPTV Subscriptions | 28,000+ Channels</title>
<meta name="description" content="Explore {{ $setting->webname }} IPTV's flexible and affordable pricing plans for 28,000+ channels. Choose the best UK IPTV subscription (Monthly, 3 Months, Quarterly, Annual) to suit your needs. Get HD streaming, VOD, and 30-day money-back guarantee.">
<meta name="keywords" content="IPTV pricing UK, {{ $setting->webname }} IPTV plans, IPTV subscription cost UK, cheap IPTV UK, affordable IPTV UK, best IPTV deals UK, UK IPTV monthly plan, UK IPTV annual plan, IPTV offers, 28000 channels IPTV pricing">
<meta name="author" content="{{ $setting->webname }}">
<!-- Canonical URL -->
<link rel="canonical" href="{{ url()->current() }}">

<!-- Open Graph / Facebook -->
<meta property="og:title" content="Pricing Plans - {{ $setting->webname }} | Affordable UK IPTV Subscriptions">
<meta property="og:description" content="Find the best IPTV pricing plans with 28,000+ channels, HD streaming, and VOD. {{ $setting->webname }} offers monthly to annual subscriptions with money-back guarantee.">
<meta property="og:url" content="{{ url()->current() }}">
<meta property="og:type" content="website">
<meta property="og:site_name" content="{{ $setting->webname }}">
<!-- Twitter Card -->
<meta name="twitter:card" content="summary_large_image">
<meta name="twitter:title" content="Affordable UK IPTV Pricing Plans | {{ $setting->webname }}">
<meta name="twitter:description" content="Choose from Monthly, 3 Months, Quarterly & Annual IPTV plans. Enjoy 28,000+ channels, VOD & HD streaming with {{ $setting->webname }} IPTV.">
<meta name="twitter:site" content="{{ $setting->webname }}"> <!-- Replace if available -->



<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "BreadcrumbList",
  "itemListElement": [
    {
      "@type": "ListItem",
      "position": 1,
      "name": "Home",
      "item": "{{ route('website') }}"
    },
    {
      "@type": "ListItem",
      "position": 2,
      "name": "IPTV Pricing Plans"
    }
  ]
}
</script>
@endsection
@section('content') 
   <main class="flex-grow">
  <div style="opacity: 1;">
    <section id="pricing" class="py-20 bg-gray-50">
      <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center" style="opacity: 1; transform: none;">
          <h2 class="text-3xl font-extrabold text-gray-900 sm:text-4xl">Simple, Transparent Pricing</h2>
          <p class="mt-4 max-w-2xl text-xl text-gray-500 mx-auto">Choose the plan that works best for you. All plans include our 30-Day Money-Back Guarantee.</p>
        </div>
        <div class="my-8 p-4 bg-gradient-to-r from-red-500 to-orange-500 rounded-xl shadow-lg text-white text-center" style="opacity: 1; transform: none;">
          <div class="flex items-center justify-center mb-2">
            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-8 w-8 mr-3 animate-bounce">
              <circle cx="12" cy="13" r="8"></circle>
              <path d="M12 9v4l2 2"></path>
              <path d="M5 3 2 6"></path>
              <path d="m22 6-3-3"></path>
              <path d="M6.38 18.7 4 21"></path>
              <path d="M17.64 18.67 20 21"></path>
            </svg>
            <h3 class="text-2xl font-bold tracking-wider">Limited Time Flash Sale!</h3>
          </div>
          <p class="text-lg mb-3">Prices will return to normal after the timer ends.</p>
          <div class="flex justify-center space-x-4">
            <div class="flex flex-col items-center">
              <span class="text-4xl font-extrabold bg-white/20 px-3 py-1 rounded-lg">02</span>
              <span class="text-xs font-semibold uppercase tracking-wider mt-1">Hours</span>
            </div>
            <div class="text-4xl font-extrabold">:</div>
            <div class="flex flex-col items-center">
              <span class="text-4xl font-extrabold bg-white/20 px-3 py-1 rounded-lg">47</span>
              <span class="text-xs font-semibold uppercase tracking-wider mt-1">Minutes</span>
            </div>
            <div class="text-4xl font-extrabold">:</div>
            <div class="flex flex-col items-center">
              <span class="text-4xl font-extrabold bg-white/20 px-3 py-1 rounded-lg">20</span>
              <span class="text-xs font-semibold uppercase tracking-wider mt-1">Seconds</span>
            </div>
          </div>
        </div>
        <div class="mt-16 grid gap-8 lg:grid-cols-4 md:grid-cols-2 sm:grid-cols-1">
          <div class="pricing-card relative rounded-xl shadow-lg overflow-hidden flex flex-col transition-all duration-300 ease-in-out border border-gray-200 hover:shadow-blue-100" style="opacity: 1; transform: none;">
            <div class="p-8 bg-white">
              <h3 class="text-2xl font-bold text-gray-900">Monthly</h3>
              <div class="mt-4 flex items-baseline text-gray-900">
                <span class="text-5xl font-extrabold tracking-tight">£12.99</span>
                <span class="ml-1 text-xl font-semibold">per month</span>
              </div>
              <p class="mt-5 text-base text-gray-500">Perfect for trying out our service</p>
            </div>
            <div class="pt-6 pb-8 px-6 bg-white flex-grow flex flex-col justify-between">
              <ul role="list" class="space-y-3">
                <li class="flex items-start">
                  <div class="flex-shrink-0">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-5 w-5 text-green-500" aria-hidden="true">
                      <polyline points="20 6 9 17 4 12"></polyline>
                    </svg>
                  </div>
                  <p class="ml-3 text-sm text-gray-700">28,000+ Live TV Channels</p>
                </li>
                <li class="flex items-start">
                  <div class="flex-shrink-0">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-5 w-5 text-green-500" aria-hidden="true">
                      <polyline points="20 6 9 17 4 12"></polyline>
                    </svg>
                  </div>
                  <p class="ml-3 text-sm text-gray-700">Full HD &amp; 4K Quality</p>
                </li>
                <li class="flex items-start">
                  <div class="flex-shrink-0">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-5 w-5 text-green-500" aria-hidden="true">
                      <polyline points="20 6 9 17 4 12"></polyline>
                    </svg>
                  </div>
                  <p class="ml-3 text-sm text-gray-700">7-Day Catch Up</p>
                </li>
                <li class="flex items-start">
                  <div class="flex-shrink-0">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-5 w-5 text-green-500" aria-hidden="true">
                      <polyline points="20 6 9 17 4 12"></polyline>
                    </svg>
                  </div>
                  <p class="ml-3 text-sm text-gray-700">VOD Library (Movies &amp; Series)</p>
                </li>
                <li class="flex items-start">
                  <div class="flex-shrink-0">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-5 w-5 text-green-500" aria-hidden="true">
                      <polyline points="20 6 9 17 4 12"></polyline>
                    </svg>
                  </div>
                  <p class="ml-3 text-sm text-gray-700">Use on 1 Device</p>
                </li>
                <li class="flex items-start">
                  <div class="flex-shrink-0">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-5 w-5 text-green-500" aria-hidden="true">
                      <polyline points="20 6 9 17 4 12"></polyline>
                    </svg>
                  </div>
                  <p class="ml-3 text-sm text-gray-700">24/7 Support via WhatsApp</p>
                </li>
              </ul>
              <div class="mt-8">
                <a href="https://wa.me/{{ $setting->whatsapp }}?text=Hello%20{{ $setting->webname }}%20IPTV%2C%20I'm%20interested%20in%20the%20Monthly%20plan." target="_blank" rel="noopener noreferrer" class="inline-flex items-center justify-center rounded-md text-sm font-medium ring-offset-background transition-colors focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-ring focus-visible:ring-offset-2 disabled:pointer-events-none disabled:opacity-50 h-10 px-4 py-2 w-full bg-blue-600 hover:bg-blue-700 text-white">Get Started</a>
              </div>
            </div>
          </div>
          <div class="pricing-card relative rounded-xl shadow-lg overflow-hidden flex flex-col transition-all duration-300 ease-in-out border border-gray-200 hover:shadow-blue-100" style="opacity: 1; transform: none;">
            <div class="p-8 bg-white">
              <h3 class="text-2xl font-bold text-gray-900">3 Months</h3>
              <div class="mt-4 flex items-baseline text-gray-900">
                <span class="text-5xl font-extrabold tracking-tight">£29.99</span>
                <span class="ml-1 text-xl font-semibold">every 3 months</span>
              </div>
              <p class="mt-5 text-base text-gray-500">Great value for short term</p>
            </div>
            <div class="pt-6 pb-8 px-6 bg-white flex-grow flex flex-col justify-between">
              <ul role="list" class="space-y-3">
                <li class="flex items-start">
                  <div class="flex-shrink-0">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-5 w-5 text-green-500" aria-hidden="true">
                      <polyline points="20 6 9 17 4 12"></polyline>
                    </svg>
                  </div>
                  <p class="ml-3 text-sm text-gray-700">28,000+ Live TV Channels</p>
                </li>
                <li class="flex items-start">
                  <div class="flex-shrink-0">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-5 w-5 text-green-500" aria-hidden="true">
                      <polyline points="20 6 9 17 4 12"></polyline>
                    </svg>
                  </div>
                  <p class="ml-3 text-sm text-gray-700">Full HD &amp; 4K Quality</p>
                </li>
                <li class="flex items-start">
                  <div class="flex-shrink-0">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-5 w-5 text-green-500" aria-hidden="true">
                      <polyline points="20 6 9 17 4 12"></polyline>
                    </svg>
                  </div>
                  <p class="ml-3 text-sm text-gray-700">7-Day Catch Up</p>
                </li>
                <li class="flex items-start">
                  <div class="flex-shrink-0">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-5 w-5 text-green-500" aria-hidden="true">
                      <polyline points="20 6 9 17 4 12"></polyline>
                    </svg>
                  </div>
                  <p class="ml-3 text-sm text-gray-700">VOD Library (Movies &amp; Series)</p>
                </li>
                <li class="flex items-start">
                  <div class="flex-shrink-0">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-5 w-5 text-green-500" aria-hidden="true">
                      <polyline points="20 6 9 17 4 12"></polyline>
                    </svg>
                  </div>
                  <p class="ml-3 text-sm text-gray-700">Use on 2 Devices Simultaneously</p>
                </li>
                <li class="flex items-start">
                  <div class="flex-shrink-0">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-5 w-5 text-green-500" aria-hidden="true">
                      <polyline points="20 6 9 17 4 12"></polyline>
                    </svg>
                  </div>
                  <p class="ml-3 text-sm text-gray-700">24/7 Support via WhatsApp</p>
                </li>
                <li class="flex items-start">
                  <div class="flex-shrink-0">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-5 w-5 text-green-500" aria-hidden="true">
                      <polyline points="20 6 9 17 4 12"></polyline>
                    </svg>
                  </div>
                  <p class="ml-3 text-sm text-gray-700">Save over 20% vs Monthly</p>
                </li>
              </ul>
              <div class="mt-8">
                <a href="https://wa.me/{{ $setting->whatsapp }}?text=Hello%20{{ $setting->webname }}%20IPTV%2C%20I'm%20interested%20in%20the%203%20Months%20plan." target="_blank" rel="noopener noreferrer" class="inline-flex items-center justify-center rounded-md text-sm font-medium ring-offset-background transition-colors focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-ring focus-visible:ring-offset-2 disabled:pointer-events-none disabled:opacity-50 h-10 px-4 py-2 w-full bg-blue-600 hover:bg-blue-700 text-white">Get Started</a>
              </div>
            </div>
          </div>
          <div class="pricing-card relative rounded-xl shadow-lg overflow-hidden flex flex-col transition-all duration-300 ease-in-out border-4 border-orange-500 transform scale-105 ring-4 ring-orange-500 ring-opacity-50" style="opacity: 1; transform: none;">
            <div class="absolute top-0 -right-1 transform translate-x-0 -translate-y-0">
              <div class="absolute top-0 right-0 h-16 w-16">
                <div class="absolute transform rotate-45 bg-gradient-to-r from-orange-500 to-red-500 text-center text-white font-semibold py-1 right-[-34px] top-[32px] w-[170px] shadow-md">Hot Sale!</div>
              </div>
            </div>
            <div class="p-8 bg-orange-50">
              <h3 class="text-2xl font-bold text-gray-900">Annual</h3>
              <div class="mt-4 flex items-baseline text-gray-900">
                <span class="text-5xl font-extrabold tracking-tight">£45</span>
                <span class="ml-1 text-xl font-semibold">per year</span>
              </div>
              <p class="mt-5 text-base text-gray-500">Best value for loyal customers</p>
              <div class="mt-4 p-3 bg-red-100 border-l-4 border-red-500 rounded-r-lg">
                <p class="font-bold text-red-800">12 Months + 2 Months FREE</p>
                <div class="flex items-center mt-1 text-sm text-red-600">
                  <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-4 w-4 mr-1.5">
                    <circle cx="12" cy="12" r="10"></circle>
                    <polyline points="12 6 12 12 16 14"></polyline>
                  </svg>
                  <span>Offer valid for next 5 hours!</span>
                </div>
              </div>
            </div>
            <div class="pt-6 pb-8 px-6 bg-white flex-grow flex flex-col justify-between">
              <ul role="list" class="space-y-3">
                <li class="flex items-start">
                  <div class="flex-shrink-0">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-5 w-5 text-green-500" aria-hidden="true">
                      <polyline points="20 6 9 17 4 12"></polyline>
                    </svg>
                  </div>
                  <p class="ml-3 text-sm text-gray-700">28,000+ Live TV Channels</p>
                </li>
                <li class="flex items-start">
                  <div class="flex-shrink-0">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-5 w-5 text-green-500" aria-hidden="true">
                      <polyline points="20 6 9 17 4 12"></polyline>
                    </svg>
                  </div>
                  <p class="ml-3 text-sm text-gray-700">Full HD &amp; 4K Quality</p>
                </li>
                <li class="flex items-start">
                  <div class="flex-shrink-0">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-5 w-5 text-green-500" aria-hidden="true">
                      <polyline points="20 6 9 17 4 12"></polyline>
                    </svg>
                  </div>
                  <p class="ml-3 text-sm text-gray-700">7-Day Catch Up &amp; Recording</p>
                </li>
                <li class="flex items-start">
                  <div class="flex-shrink-0">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-5 w-5 text-green-500" aria-hidden="true">
                      <polyline points="20 6 9 17 4 12"></polyline>
                    </svg>
                  </div>
                  <p class="ml-3 text-sm text-gray-700">Premium VOD Library (Updated Daily)</p>
                </li>
                <li class="flex items-start">
                  <div class="flex-shrink-0">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-5 w-5 text-green-500" aria-hidden="true">
                      <polyline points="20 6 9 17 4 12"></polyline>
                    </svg>
                  </div>
                  <p class="ml-3 text-sm text-gray-700">Use on 3 Devices Simultaneously</p>
                </li>
                <li class="flex items-start">
                  <div class="flex-shrink-0">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-5 w-5 text-green-500" aria-hidden="true">
                      <polyline points="20 6 9 17 4 12"></polyline>
                    </svg>
                  </div>
                  <p class="ml-3 text-sm text-gray-700">VIP 24/7 Support</p>
                </li>
                <li class="flex items-start">
                  <div class="flex-shrink-0">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-5 w-5 text-green-500" aria-hidden="true">
                      <polyline points="20 6 9 17 4 12"></polyline>
                    </svg>
                  </div>
                  <p class="ml-3 text-sm text-gray-700">Save over 60% vs Monthly</p>
                </li>
                <li class="flex items-start">
                  <div class="flex-shrink-0">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-5 w-5 text-green-500" aria-hidden="true">
                      <polyline points="20 6 9 17 4 12"></polyline>
                    </svg>
                  </div>
                  <p class="ml-3 text-sm text-gray-700">Free Setup Assistance</p>
                </li>
              </ul>
              <div class="mt-8">
                <a href="https://wa.me/{{ $setting->whatsapp }}?text=Hello%20{{ $setting->webname }}%20IPTV%2C%20I'm%20interested%20in%20the%20Annual%20plan." target="_blank" rel="noopener noreferrer" class="inline-flex items-center justify-center rounded-md text-sm font-medium ring-offset-background transition-colors focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-ring focus-visible:ring-offset-2 disabled:pointer-events-none disabled:opacity-50 bg-primary hover:bg-primary/90 h-10 px-4 py-2 w-full bg-gradient-to-r from-orange-500 to-red-600 hover:from-orange-600 hover:to-red-700 text-white shadow-lg hover:shadow-xl">Get Started</a>
              </div>
            </div>
          </div>
          <div class="pricing-card relative rounded-xl shadow-lg overflow-hidden flex flex-col transition-all duration-300 ease-in-out border border-gray-200 hover:shadow-blue-100" style="opacity: 1; transform: none;">
            <div class="p-8 bg-white">
              <h3 class="text-2xl font-bold text-gray-900">Quarterly</h3>
              <div class="mt-4 flex items-baseline text-gray-900">
                <span class="text-5xl font-extrabold tracking-tight">£34.99</span>
                <span class="ml-1 text-xl font-semibold">per quarter</span>
              </div>
              <p class="mt-5 text-base text-gray-500">Popular choice for commitment</p>
            </div>
            <div class="pt-6 pb-8 px-6 bg-white flex-grow flex flex-col justify-between">
              <ul role="list" class="space-y-3">
                <li class="flex items-start">
                  <div class="flex-shrink-0">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-5 w-5 text-green-500" aria-hidden="true">
                      <polyline points="20 6 9 17 4 12"></polyline>
                    </svg>
                  </div>
                  <p class="ml-3 text-sm text-gray-700">28,000+ Live TV Channels</p>
                </li>
                <li class="flex items-start">
                  <div class="flex-shrink-0">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-5 w-5 text-green-500" aria-hidden="true">
                      <polyline points="20 6 9 17 4 12"></polyline>
                    </svg>
                  </div>
                  <p class="ml-3 text-sm text-gray-700">Full HD &amp; 4K Quality</p>
                </li>
                <li class="flex items-start">
                  <div class="flex-shrink-0">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-5 w-5 text-green-500" aria-hidden="true">
                      <polyline points="20 6 9 17 4 12"></polyline>
                    </svg>
                  </div>
                  <p class="ml-3 text-sm text-gray-700">7-Day Catch Up &amp; Recording</p>
                </li>
                <li class="flex items-start">
                  <div class="flex-shrink-0">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-5 w-5 text-green-500" aria-hidden="true">
                      <polyline points="20 6 9 17 4 12"></polyline>
                    </svg>
                  </div>
                  <p class="ml-3 text-sm text-gray-700">Extensive VOD Library</p>
                </li>
                <li class="flex items-start">
                  <div class="flex-shrink-0">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-5 w-5 text-green-500" aria-hidden="true">
                      <polyline points="20 6 9 17 4 12"></polyline>
                    </svg>
                  </div>
                  <p class="ml-3 text-sm text-gray-700">Use on 2 Devices Simultaneously</p>
                </li>
                <li class="flex items-start">
                  <div class="flex-shrink-0">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-5 w-5 text-green-500" aria-hidden="true">
                      <polyline points="20 6 9 17 4 12"></polyline>
                    </svg>
                  </div>
                  <p class="ml-3 text-sm text-gray-700">Priority 24/7 Support</p>
                </li>
                <li class="flex items-start">
                  <div class="flex-shrink-0">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-5 w-5 text-green-500" aria-hidden="true">
                      <polyline points="20 6 9 17 4 12"></polyline>
                    </svg>
                  </div>
                  <p class="ml-3 text-sm text-gray-700">Early access to new features</p>
                </li>
              </ul>
              <div class="mt-8">
                <a href="https://wa.me/{{ $setting->whatsapp }}?text=Hello%20{{ $setting->webname }}%20IPTV%2C%20I'm%20interested%20in%20the%20Quarterly%20plan." target="_blank" rel="noopener noreferrer" class="inline-flex items-center justify-center rounded-md text-sm font-medium ring-offset-background transition-colors focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-ring focus-visible:ring-offset-2 disabled:pointer-events-none disabled:opacity-50 h-10 px-4 py-2 w-full bg-blue-600 hover:bg-blue-700 text-white">Get Started</a>
              </div>
            </div>
          </div>
        </div>
        <div class="mt-12 py-8 bg-gray-100 rounded-lg">
          <div class="text-center" style="opacity: 1; transform: none;">
            <div class="flex items-center justify-center mb-4">
              <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-8 w-8 text-green-500 mr-2">
                <path d="M12 22s8-4 8-10V5l-8-3-8 3v7c0 6 8 10 8 10"></path>
                <path d="m9 12 2 2 4-4"></path>
              </svg>
              <h4 class="text-xl font-semibold text-gray-800">Secure Payment Options</h4>
            </div>
            <p class="text-gray-600 mb-6">We accept various secure payment methods for your convenience.</p>
            <div class="flex justify-center items-center space-x-6 sm:space-x-12">
              <div class="flex flex-col items-center text-center" style="opacity: 1; transform: none;">
                <div class="p-3 bg-white rounded-full shadow-md mb-2">
                  <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-10 w-10 text-blue-600">
                    <rect width="20" height="14" x="2" y="5" rx="2"></rect>
                    <line x1="2" x2="22" y1="10" y2="10"></line>
                  </svg>
                </div>
                <span class="text-sm font-medium text-gray-700">Card Payments</span>
              </div>
              <div class="flex flex-col items-center text-center" style="opacity: 1; transform: none;">
                <div class="p-3 bg-white rounded-full shadow-md mb-2">
                  <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-10 w-10 text-blue-500">
                    <polyline points="22 7 13.5 15.5 8.5 10.5 2 17"></polyline>
                    <polyline points="16 7 22 7 22 13"></polyline>
                  </svg>
                </div>
                <span class="text-sm font-medium text-gray-700">PayPal</span>
              </div>
              <div class="flex flex-col items-center text-center" style="opacity: 1; transform: none;">
                <div class="p-3 bg-white rounded-full shadow-md mb-2">
                  <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-10 w-10 text-green-600">
                    <rect width="20" height="12" x="2" y="6" rx="2"></rect>
                    <circle cx="12" cy="12" r="2"></circle>
                    <path d="M6 12h.01M18 12h.01"></path>
                  </svg>
                </div>
                <span class="text-sm font-medium text-gray-700">Bank Transfer</span>
              </div>
            </div>
          </div>
        </div>
        <div class="mt-16 bg-gradient-to-r from-blue-600 to-indigo-700 rounded-lg shadow-xl p-8 md:p-12 border border-blue-700 text-white" style="opacity: 1; transform: none;">
          <div class="text-center">
            <h3 class="text-3xl font-extrabold sm:text-4xl">Ready for a Longer Test Drive?</h3>
            <p class="mt-4 text-lg sm:text-xl text-blue-100 max-w-3xl mx-auto">Experience the full power of {{ $setting->webname }} IPTV with our exclusive 24-hour free trial. Access all 28,000+ channels, VOD, and premium features with no obligation. It's the perfect way to see why we're the UK's favourite IPTV provider!</p>
            <div class="mt-8">
              <a class="inline-flex items-center justify-center ring-offset-background focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-ring focus-visible:ring-offset-2 disabled:pointer-events-none disabled:opacity-50 h-11 rounded-md bg-white text-blue-600 hover:bg-gray-100 shadow-md hover:shadow-lg transform hover:scale-105 transition-all duration-300 px-10 py-3 text-lg font-semibold" href="/trial">Request 24hr Trial Now</a>
            </div>
          </div>
        </div>
      </div>
    </section>
    <section id="money-back-guarantee" class="py-20 bg-blue-600 text-white">
      <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
        <div style="opacity: 1; transform: none;">
          <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-20 w-20 mx-auto mb-6 text-green-400">
            <path d="M12 22s8-4 8-10V5l-8-3-8 3v7c0 6 8 10 8 10"></path>
            <path d="m9 12 2 2 4-4"></path>
          </svg>
          <h2 class="text-3xl font-extrabold sm:text-4xl mb-4">Our 30-Day Money-Back Guarantee</h2>
          <p class="text-xl text-blue-100 mb-8 max-w-2xl mx-auto">We are confident you'll love {{ $setting->webname }} IPTV. However, if you're not completely satisfied within the first 30 days of your subscription, we'll give you a full refund. No hassle, no questions asked. Your satisfaction is our priority!</p>
          <div class="flex items-center justify-center text-lg text-blue-200">
            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-6 w-6 mr-2 text-yellow-400">
              <circle cx="12" cy="12" r="10"></circle>
              <path d="M8 14s1.5 2 4 2 4-2 4-2"></path>
              <line x1="9" x2="9.01" y1="9" y2="9"></line>
              <line x1="15" x2="15.01" y1="9" y2="9"></line>
            </svg>
            <span>Risk-Free Trial - Experience the Best in UK IPTV!</span>
          </div>
        </div>
      </div>
    </section>
    <section class="py-16 md:py-24 bg-gray-800 text-gray-200" style="opacity: 1;">
      <div class="max-w-5xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center mb-12" style="opacity: 1; transform: none;">
          <h2 class="text-3xl sm:text-4xl font-extrabold text-white tracking-tight">Experience <span class="text-blue-400 font-semibold">Unmatched IPTV</span> Performance </h2>
          <p class="mt-4 text-lg text-gray-400 max-w-3xl mx-auto">Discover why {{ $setting->webname }} IPTV is the preferred choice for viewers across the UK. We're committed to delivering a seamless, high-quality entertainment experience.</p>
        </div>
        <div class="mb-12 p-6 md:p-8 bg-gray-700 rounded-xl shadow-2xl" style="opacity: 1; transform: none;">
          <div class="flex items-center mb-4">
            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-8 w-8 text-yellow-400 mr-3">
              <polygon points="13 2 3 14 12 14 11 22 21 10 12 10 13 2"></polygon>
            </svg>
            <h3 class="text-2xl font-bold text-white">NO IPTV FREEZING, NO IPTV BUFFERING</h3>
          </div>
          <p class="text-gray-300 leading-relaxed">Tired of interruptions? Our <span class="text-blue-400 font-semibold">ALL IN ONE SMARTER IPTV</span> solution ensures a smooth viewing experience. You don’t have to pay hefty monthly subscriptions anymore. With our service, pay once for your chosen period and enjoy all sports packages, your favorite channels in <span class="text-blue-400 font-semibold">SD, HD, and FHD quality</span>, even with slower internet speeds. This IPTV is designed for you, and we'll make it work seamlessly. </p>
        </div>
        <div class="grid md:grid-cols-2 gap-8 mb-12" style="opacity: 1; transform: none;">
          <div class="p-6 bg-gray-700 rounded-xl shadow-xl">
            <div class="flex items-center mb-3">
              <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-7 w-7 text-blue-400 mr-3">
                <rect width="20" height="15" x="2" y="7" rx="2" ry="2"></rect>
                <polyline points="17 2 12 7 7 2"></polyline>
              </svg>
              <h4 class="text-xl font-semibold text-white">Best IPTV UK Subscription</h4>
            </div>
            <p class="text-gray-300">Welcome to the new age of television. UK IPTV is the beacon of modern TV, providing an exceptional viewing experience. Our subscription is undoubtedly the best in the UK, with over <span class="text-blue-400 font-semibold">28,000+ total channels</span> including <span class="text-blue-400 font-semibold">5,500+ dedicated sports channels</span>. Never miss a moment of action, be it football, cricket, or golf. Enjoy seamless, high-quality streaming directly to your living room. </p>
          </div>
          <div class="p-6 bg-gray-700 rounded-xl shadow-xl">
            <div class="flex items-center mb-3">
              <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-7 w-7 text-green-400 mr-3">
                <path d="M12 22s8-4 8-10V5l-8-3-8 3v7c0 6 8 10 8 10"></path>
                <path d="m9 12 2 2 4-4"></path>
              </svg>
              <h4 class="text-xl font-semibold text-white">Why Choose Premium IPTV Services UK?</h4>
            </div>
            <p class="text-gray-300">We stand ahead of the pack. Our service delivers high-quality viewing across diverse genres: news, documentaries, movies, music, and an impressive sports lineup. It's your one-stop entertainment solution, supporting <span class="text-blue-400 font-semibold">all types of devices</span>. Watch anytime, anywhere, and try risk-free with our <span class="text-blue-400 font-semibold">7-day money-back guarantee</span> (Note: main guarantee is 30 days, this might be a specific offer). </p>
          </div>
        </div>
        <div class="mb-12 p-6 md:p-8 bg-gray-700 rounded-xl shadow-2xl" style="opacity: 1; transform: none;">
          <div class="flex items-center mb-4">
            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-8 w-8 text-purple-400 mr-3">
              <rect width="18" height="18" x="3" y="3" rx="2"></rect>
              <path d="M7 3v18"></path>
              <path d="M3 7.5h4"></path>
              <path d="M3 12h18"></path>
              <path d="M3 16.5h4"></path>
              <path d="M17 3v18"></path>
              <path d="M17 7.5h4"></path>
              <path d="M17 16.5h4"></path>
            </svg>
            <h3 class="text-2xl font-bold text-white">Best IPTV UK Subscription Provider For Firestick 2024 &amp; More</h3>
          </div>
          <p class="text-gray-300 leading-relaxed">{{ $setting->webname }} IPTV is a great service allowing you to watch over <span class="text-blue-400 font-semibold">28,000+ live IPTV channels</span> and an extensive library of over <span class="text-blue-400 font-semibold">99,000+ videos on demand (VOD)</span>. We offer a cost-effective service with stable channels, mostly in Full HD. Say goodbye to expensive cable bills. Our IPTV Service boasts <span class="text-blue-400 font-semibold">99.99% uptime</span>! Enjoy a solid, buffer-free, and freeze-free experience (stable internet required). You get a 100% satisfaction guarantee at a better price. </p>
        </div>
        <div class="grid md:grid-cols-2 gap-8" style="opacity: 1; transform: none;">
          <div class="p-6 bg-gray-700 rounded-xl shadow-xl">
            <div class="flex items-center mb-3">
              <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-7 w-7 text-teal-400 mr-3">
                <path d="M3 14h3a2 2 0 0 1 2 2v3a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2v-7a9 9 0 0 1 18 0v7a2 2 0 0 1-2 2h-1a2 2 0 0 1-2-2v-3a2 2 0 0 1 2-2h3"></path>
              </svg>
              <h4 class="text-xl font-semibold text-white">Top Quality Support</h4>
            </div>
            <p class="text-gray-300">We've got you covered. Our dedicated team ensures your IPTV experience is smooth and hassle-free. For any questions or issues, top-quality support is just a message away.</p>
          </div>
          <div class="p-6 bg-gray-700 rounded-xl shadow-xl">
            <div class="flex items-center mb-3">
              <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-7 w-7 text-red-400 mr-3">
                <path d="M5 13a10 10 0 0 1 14 0"></path>
                <path d="M8.5 16.5a5 5 0 0 1 7 0"></path>
                <path d="M2 8.82a15 15 0 0 1 20 0"></path>
                <line x1="12" x2="12.01" y1="20" y2="20"></line>
              </svg>
              <h4 class="text-xl font-semibold text-white">VPN Usage &amp; Channel Coverage</h4>
            </div>
            <p class="text-gray-300">While some providers might require a VPN, it's <span class="text-blue-400 font-semibold">not needed with our service</span>. However, we are VPN friendly if you choose to use one. Our channel coverage spans worldwide countries including the USA, Canada, UK, Italy, Spain, UAE, Germany, France, South America, Turkey, and many more. We also have <span class="text-blue-400 font-semibold">EPG (Electronic Program Guide)</span> installed so you can see what’s on or coming up, just like a traditional TV guide. </p>
          </div>
        </div>
        <div class="mt-12 text-center" style="opacity: 1; transform: none;">
          <p class="text-gray-400 text-sm">Channel counts and VOD numbers are approximate and subject to updates to provide the best possible selection.</p>
        </div>
      </div>
    </section>
  </div>
</main>
    
   @endsection