@extends('layouts.master')  
@section('meta')  
   <!-- Primary Meta Tags -->

    <title>{{ $setting->seotitle }}</title>
    <meta name="description" content="{{ $setting->description }}">
    <meta name="keywords" content="IP TV download app,IP TV APK,ip-tv player,IPTV Smart Player,Ip TV download for PC,IPTV pakistan olx,Nayatel IPTV Packages,IPTV Pakistan app">  
    <meta name="author" content="{{ $setting->webname }}">

    <!-- Open Graph / Facebook -->
    <meta property="og:type" content="website">
    <meta property="og:title" content="{{ $setting->seotitle }}">
    <meta property="og:description" content="{{ $setting->description }}">
    <meta property="og:image" content="{{ asset($setting->image) }}">
    <meta property="og:url" content="{{ url()->current() }}">
    <meta property="og:site_name" content="{{ $setting->webname }}">

    <!-- Twitter Card -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="{{ $setting->seotitle }}">
    <meta name="twitter:description" content="{{ $setting->description }}">
    <meta name="twitter:image" content="{{ asset($setting->image) }}">
    <meta name="twitter:site" content="{{ $setting->webname }}">  

    <!-- Canonical URL -->
    <link rel="canonical" href="{{ url()->current() }}">

    <!-- Additional SEO Enhancements -->
    <meta name="referrer" content="strict-origin-when-cross-origin">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
@endsection
@section('content') 



        <main class="flex-grow">
          <div class="relative overflow-hidden bg-gray-200">
            <div class="max-w-7xl mx-auto">
              <div class="relative z-10 pb-8 bg-gray-200 sm:pb-16 md:pb-20 lg:max-w-2xl lg:w-full lg:pb-28 xl:pb-32">
                <svg class="hidden lg:block absolute right-0 inset-y-0 h-full w-48 text-gray-200 transform translate-x-1/2" fill="currentColor" viewBox="0 0 100 100" preserveAspectRatio="none" aria-hidden="true">
                  <polygon points="50,0 100,0 50,100 0,100"></polygon>
                </svg>
                <main class="pt-10 mx-auto max-w-7xl px-4 sm:pt-12 sm:px-6 md:pt-16 lg:pt-20 lg:px-8 xl:pt-28">
                  <div class="sm:text-center lg:text-left">
                    <h1 class="text-4xl tracking-tight font-extrabold text-gray-900 sm:text-5xl md:text-6xl" style="opacity: 1; transform: none;">
                      <span class="block xl:inline">Premium UK</span>
                      <span class="block text-blue-600 xl:inline">IPTV Service</span>
                    </h1>
                    <p class="mt-3 text-base text-gray-500 sm:mt-5 sm:text-lg sm:max-w-xl sm:mx-auto md:mt-5 md:text-xl lg:mx-0" style="opacity: 1; transform: none;">Experience the full power of {{ $setting->webname }} IPTV with our exclusive 24-hour free trial. Access all 28,000+ channels, VOD, and premium features with no obligation. It's the perfect way to see why we're the UK's favourite IPTV provider!</p>
                    <div class="mt-5 sm:mt-8 sm:flex sm:justify-center lg:justify-start space-y-3 sm:space-y-0 sm:space-x-3" style="opacity: 1; transform: none;">
                      <div class="rounded-md shadow">
                        <a href="https://wa.me/{{ $setting->whatsapp }}?text=Hello {{ $setting->webname }} IPTV, I'm interested in getting started after seeing your homepage!" target="_blank" rel="noopener noreferrer" class="ring-offset-background transition-colors focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-ring focus-visible:ring-offset-2 disabled:pointer-events-none disabled:opacity-50 h-10 w-full flex items-center justify-center px-8 py-3 text-base font-medium rounded-md text-white bg-blue-600 hover:bg-blue-700 md:py-4 md:text-lg md:px-10">Get Started</a>
                      </div>
                      <div class="rounded-md shadow">
                        <a class="ring-offset-background transition-colors focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-ring focus-visible:ring-offset-2 disabled:pointer-events-none disabled:opacity-50 border hover:text-accent-foreground h-10 w-full flex items-center justify-center px-8 py-3 text-base font-medium rounded-md text-green-700 bg-green-100 hover:bg-green-200 md:py-4 md:text-lg md:px-10 border-green-300 hover:border-green-400" href="/trial">24hr Free Trial</a>
                      </div>
                    </div>
                    <div class="mt-8 bg-gradient-to-r from-yellow-300 via-orange-400 to-red-400 p-4 rounded-lg shadow-lg border-2 border-orange-500" style="opacity: 1; transform: none;">
                      <div class="text-center">
                        <div class="flex items-center justify-center text-gray-800 font-bold text-xl mb-2">
                          <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-6 w-6 mr-2 text-yellow-500 animate-pulse">
                            <polygon points="13 2 3 14 12 14 11 22 21 10 12 10 13 2"></polygon>
                          </svg>FLASH SALE!
                        </div>
                        <p class="text-gray-700 font-semibold">Get 12 Months + 2 Months FREE!</p>
                        <div class="my-3">
                          <div class="flex justify-center items-center space-x-2 text-gray-800">
                            <div class="flex flex-col items-center">
                              <span class="text-2xl font-bold">04</span>
                              <span class="text-xs uppercase">Hrs</span>
                            </div>
                            <div class="text-2xl font-bold">:</div>
                            <div class="flex flex-col items-center">
                              <span class="text-2xl font-bold">54</span>
                              <span class="text-xs uppercase">Mins</span>
                            </div>
                            <div class="text-2xl font-bold">:</div>
                            <div class="flex flex-col items-center">
                              <span class="text-2xl font-bold">44</span>
                              <span class="text-xs uppercase">Secs</span>
                            </div>
                          </div>
                        </div>
                        <a href="https://wa.me/{{ $setting->whatsapp }}?text=Hello%20{{ $setting->webname }}%20IPTV%2C%20I%20want%20to%20claim%20the%20special%20offer%20for%20the%20Annual%20Plan%20(12%20Months%20%2B%202%20Months%20FREE)!" target="_blank" rel="noopener noreferrer" class="inline-flex items-center justify-center rounded-md text-sm font-medium ring-offset-background focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-ring focus-visible:ring-offset-2 disabled:pointer-events-none disabled:opacity-50 bg-primary hover:bg-primary/90 h-10 px-4 py-2 w-full bg-gradient-to-r from-orange-500 to-red-600 text-white shadow-md hover:shadow-lg transform hover:scale-105 transition-transform duration-300">Claim Offer Now</a>
                      </div>
                    </div>
                  </div>
                </main>
              </div>
            </div>
            <div class="lg:absolute lg:inset-y-0 lg:right-0 lg:w-1/2">
              <img class="h-56 w-full object-cover sm:h-72 md:h-96 lg:w-full lg:h-full" alt="{{ $setting->webname }} IPTV interface shown on multiple devices like TV, tablet, and laptop" src="{{ asset($setting->banner) }}">
            </div>
          </div>
          <section id="why-choose-us" class="py-20 bg-white">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
              <div class="text-center">
                <h2 class="text-3xl font-extrabold text-gray-900 sm:text-4xl" style="opacity: 1; transform: none;">Why Choose {{ $setting->webname }} IPTV?</h2>
                <p class="mt-4 max-w-2xl text-xl text-gray-500 mx-auto" style="opacity: 1; transform: none;">We provide a premium viewing experience with unparalleled features and support. Discover the {{ $setting->webname }} IPTV difference.</p>
              </div>
              <div class="mt-16 grid grid-cols-1 gap-10 sm:grid-cols-2 lg:grid-cols-3">
                <div class="feature-card bg-gray-50 p-8 rounded-xl shadow-lg hover:shadow-2xl transition-all duration-300 ease-in-out" style="opacity: 1; transform: none;">
                  <div class="flex items-center justify-center h-16 w-16 rounded-full bg-blue-500 text-white mb-6 shadow-md">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-8 w-8">
                      <rect width="20" height="15" x="2" y="7" rx="2" ry="2"></rect>
                      <polyline points="17 2 12 7 7 2"></polyline>
                    </svg>
                  </div>
                  <h3 class="text-xl font-semibold text-gray-900 mb-3">28,000+ Channels</h3>
                  <p class="text-base text-gray-600">Access to all UK channels plus vast international content.</p>
                </div>
                <div class="feature-card bg-gray-50 p-8 rounded-xl shadow-lg hover:shadow-2xl transition-all duration-300 ease-in-out" style="opacity: 1; transform: none;">
                  <div class="flex items-center justify-center h-16 w-16 rounded-full bg-blue-500 text-white mb-6 shadow-md">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-8 w-8">
                      <polygon points="13 2 3 14 12 14 11 22 21 10 12 10 13 2"></polygon>
                    </svg>
                  </div>
                  <h3 class="text-xl font-semibold text-gray-900 mb-3">HD &amp; 4K Quality</h3>
                  <p class="text-base text-gray-600">Crystal clear HD and 4K streaming quality for an immersive experience.</p>
                </div>
                <div class="feature-card bg-gray-50 p-8 rounded-xl shadow-lg hover:shadow-2xl transition-all duration-300 ease-in-out" style="opacity: 1; transform: none;">
                  <div class="flex items-center justify-center h-16 w-16 rounded-full bg-blue-500 text-white mb-6 shadow-md">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-8 w-8">
                      <circle cx="12" cy="12" r="10"></circle>
                      <line x1="2" x2="22" y1="12" y2="12"></line>
                      <path d="M12 2a15.3 15.3 0 0 1 4 10 15.3 15.3 0 0 1-4 10 15.3 15.3 0 0 1-4-10 15.3 15.3 0 0 1 4-10z"></path>
                    </svg>
                  </div>
                  <h3 class="text-xl font-semibold text-gray-900 mb-3">Multi-Device</h3>
                  <p class="text-base text-gray-600">Watch on Smart TV, mobile, tablet, or computer seamlessly.</p>
                </div>
                <div class="feature-card bg-gray-50 p-8 rounded-xl shadow-lg hover:shadow-2xl transition-all duration-300 ease-in-out" style="opacity: 1; transform: none;">
                  <div class="flex items-center justify-center h-16 w-16 rounded-full bg-blue-500 text-white mb-6 shadow-md">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-8 w-8">
                      <path d="M12 22s8-4 8-10V5l-8-3-8 3v7c0 6 8 10 8 10"></path>
                    </svg>
                  </div>
                  <h3 class="text-xl font-semibold text-gray-900 mb-3">99.9% Uptime</h3>
                  <p class="text-base text-gray-600">Reliable service with robust infrastructure and 24/7 customer support.</p>
                </div>
                <div class="feature-card bg-gray-50 p-8 rounded-xl shadow-lg hover:shadow-2xl transition-all duration-300 ease-in-out" style="opacity: 1; transform: none;">
                  <div class="flex items-center justify-center h-16 w-16 rounded-full bg-green-500 text-white mb-6 shadow-md">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-8 w-8">
                      <path d="M3 12a9 9 0 0 1 9-9 9.75 9.75 0 0 1 6.74 2.74L21 8"></path>
                      <path d="M21 3v5h-5"></path>
                      <path d="M21 12a9 9 0 0 1-9 9 9.75 9.75 0 0 1-6.74-2.74L3 16"></path>
                      <path d="M8 16H3v5"></path>
                    </svg>
                  </div>
                  <h3 class="text-xl font-semibold text-gray-900 mb-3">30-Day Money Back</h3>
                  <p class="text-base text-gray-600">Not satisfied? Get a full refund within 30 days, no questions asked.</p>
                </div>
                <div class="feature-card bg-gray-50 p-8 rounded-xl shadow-lg hover:shadow-2xl transition-all duration-300 ease-in-out" style="opacity: 1; transform: none;">
                  <div class="flex items-center justify-center h-16 w-16 rounded-full bg-green-500 text-white mb-6 shadow-md">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-8 w-8">
                      <rect width="18" height="11" x="3" y="11" rx="2" ry="2"></rect>
                      <path d="M7 11V7a5 5 0 0 1 10 0v4"></path>
                    </svg>
                  </div>
                  <h3 class="text-xl font-semibold text-gray-900 mb-3">Secure Payment</h3>
                  <p class="text-base text-gray-600">Your transactions are safe with our encrypted payment system.</p>
                </div>
              </div>
            </div>
          </section>



<div class="wd-negative-gap elementor-element elementor-element-80ee5de wd-section-stretch e-flex e-con-boxed e-con e-parent e-lazyloaded" data-id="80ee5de" data-element_type="container" data-settings="{&quot;background_background&quot;:&quot;gradient&quot;}">
  <div class="e-con-inner">
    <div class="elementor-element elementor-element-da0586d e-con-full e-flex e-con e-child" data-id="da0586d" data-element_type="container">
      <div class="elementor-element elementor-element-99dfc98 elementor-widget elementor-widget-wd_image_or_svg" data-id="99dfc98" data-element_type="widget" data-widget_type="wd_image_or_svg.default">
        <div class="elementor-widget-container">
          <div class="wd-image text-center">
            <img loading="lazy" decoding="async" width="1366" height="768" src="{{ asset($setting->banner2) }}" class="attachment-full size-full" alt="IPTV UK" sizes="(max-width: 1366px) 100vw, 1366px">
          </div>
        </div>
      </div>
    </div>
    <div class="elementor-element elementor-element-c55ed30 e-con-full e-flex e-con e-child" data-id="c55ed30" data-element_type="container">
      <div class="elementor-element elementor-element-736b925 wd-width-100 elementor-widget elementor-widget-wd_title" data-id="736b925" data-element_type="widget" data-widget_type="wd_title.default">
        <div class="elementor-widget-container">
          <div class="title-wrapper wd-set-mb reset-last-child wd-title-color-white wd-title-style-default wd-title-size-default text-left">
            <div class="liner-continer">
              <h4 class="woodmart-title-container title wd-fontsize-l">IPTV UK Compatible with all Devices.</h4>
            </div>
          </div>
        </div>
      </div>
      <div class="elementor-element elementor-element-b68e260 elementor-widget elementor-widget-wd_text_block" data-id="b68e260" data-element_type="widget" data-widget_type="wd_text_block.default">
        <div class="elementor-widget-container">
          <div class="wd-text-block reset-last-child text-left color-scheme-light">
            <p>Enjoy IPTV UK at affordable prices.</p>
          </div>
        </div>
      </div>
      <div class="elementor-element elementor-element-a03ae8c e-con-full e-flex e-con e-child" data-id="a03ae8c" data-element_type="container">
        <div class="elementor-element elementor-element-5d05749 e-con-full e-flex e-con e-child" data-id="5d05749" data-element_type="container">
          <div class="elementor-element elementor-element-e113363 elementor-widget__width-initial elementor-widget elementor-widget-wd_list" data-id="e113363" data-element_type="widget" data-widget_type="wd_list.default">
            <div class="elementor-widget-container">
              <ul class="wd-list color-scheme-custom wd-fontsize-m wd-type-image wd-style-default text-left">
                <li class="elementor-repeater-item-dd2635d">
                  <span class="wd-list-content list-content"> Stable Server </span>
                </li>
              </ul>
            </div>
          </div>
          <div class="elementor-element elementor-element-9071d71 elementor-widget__width-initial elementor-widget elementor-widget-wd_list" data-id="9071d71" data-element_type="widget" data-widget_type="wd_list.default">
            <div class="elementor-widget-container">
              <ul class="wd-list color-scheme-custom wd-fontsize-m wd-type-image wd-style-default text-left">
                <li class="elementor-repeater-item-dd2635d">
                  <span class="wd-list-content list-content"> Security and Privacy </span>
                </li>
              </ul>
            </div>
          </div>
        </div>
        <div class="elementor-element elementor-element-fe5b788 e-con-full e-flex e-con e-child" data-id="fe5b788" data-element_type="container">
          <div class="elementor-element elementor-element-98e6396 elementor-widget__width-initial elementor-widget elementor-widget-wd_list" data-id="98e6396" data-element_type="widget" data-widget_type="wd_list.default">
            <div class="elementor-widget-container">
              <ul class="wd-list color-scheme-custom wd-fontsize-m wd-type-image wd-style-default text-left">
                <li class="elementor-repeater-item-dd2635d">
                  <span class="wd-list-content list-content"> 26 000 live TV channels </span>
                </li>
              </ul>
            </div>
          </div>
          <div class="elementor-element elementor-element-77e7876 elementor-widget__width-initial elementor-widget elementor-widget-wd_list" data-id="77e7876" data-element_type="widget" data-widget_type="wd_list.default">
            <div class="elementor-widget-container">
              <ul class="wd-list color-scheme-custom wd-fontsize-m wd-type-image wd-style-default text-left">
                <li class="elementor-repeater-item-dd2635d">
                  <span class="wd-list-content list-content"> Electronic Program guide(EPG) </span>
                </li>
              </ul>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>


        <style>


.wd-negative-gap {
  display: flex;
  justify-content: space-between;
  align-items: center;
  background: linear-gradient(to right, #ff6c00, #000000);
  padding: 50px 100px;
  min-height: 400px;
  position: relative;
}

.e-con-inner {
  display: flex;
  width: 100%;
  justify-content: space-between;
  align-items: center;
  max-width: 1200px;
  margin: 0 auto;
}

.e-con-full {
  display: flex;
  flex-direction: column;
  align-items: flex-start;
}

.wd-image img {
  max-width: 100%;
  height: auto;
  border-radius: 0;
  box-shadow: none;
}

.title-wrapper h4 {
  color: white;
  font-size: 2.8em;
  margin: 0 0 15px;
  font-weight: 700;
  text-transform: uppercase;
  line-height: 1.2;
}

.wd-text-block p {
  color: white;
  font-size: 14px;
  margin: 0;
  font-weight: 400;
  opacity: 0.9;
}

.wd-list {
  list-style: none;
  padding: 0;
  margin: 20px 0 0;
  display: flex;
  flex-wrap: wrap;
  gap: 20px;
}

.wd-list li {
  display: flex;
  align-items: center;
  background: white;
  color: #333;
  padding: 12px 30px;
  border-radius: 25px;
  font-size: 1.1em;
  box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);
  width: 250px;
  justify-content: center;
  text-align: center;
}

.wd-icon img {
  width: 24px;
  height: 24px;
  margin-right: 12px;
}



@media (max-width: 768px) {
  .wd-negative-gap {
    flex-direction: column;
    text-align: center;
    padding: 30px 20px;
    min-height: 700px;
  }

  .e-con-inner {
    flex-direction: column;
    align-items: center;
  }

  .wd-image img {
    max-width: 100%;
    margin-bottom: 30px;
  }

  .title-wrapper h4 {
    font-size: 2em;
  }

  .wd-text-block p {
    font-size: 1.2em;
  }

  .wd-list {
    flex-direction: column;
    align-items: center;
    gap: 15px;
  }

  .wd-list li {
    width: 90%;
    font-size: 1em;
  }
}
        </style>











          <section id="features" class="py-20 bg-gray-50">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
              <div class="text-center">
                <h2 class="text-3xl font-extrabold text-gray-900 sm:text-4xl" style="opacity: 1; transform: none;">Everything You Need for Perfect Entertainment</h2>
                <p class="mt-4 max-w-2xl text-xl text-gray-500 mx-auto" style="opacity: 1; transform: none;">Our IPTV service is packed with features designed to give you the ultimate viewing experience.</p>
              </div>
              <div class="mt-16 grid gap-8 md:grid-cols-2 lg:grid-cols-3">
                <div class="feature-card relative bg-white p-8 rounded-xl shadow-lg border border-gray-100 hover:shadow-blue-100" style="opacity: 1; transform: none;">
                  <div class="text-blue-600 mb-5 inline-block bg-blue-100 p-3 rounded-full">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-8 w-8">
                      <rect width="20" height="15" x="2" y="7" rx="2" ry="2"></rect>
                      <polyline points="17 2 12 7 7 2"></polyline>
                    </svg>
                  </div>
                  <h3 class="text-xl font-semibold text-gray-900 mb-3">28,000+ Live Channels</h3>
                  <p class="text-base text-gray-600">Access all major UK channels, international sports, movies, news, and kids' entertainment.</p>
                </div>
                <div class="feature-card relative bg-white p-8 rounded-xl shadow-lg border border-gray-100 hover:shadow-blue-100" style="opacity: 1; transform: none;">
                  <div class="text-blue-600 mb-5 inline-block bg-blue-100 p-3 rounded-full">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-8 w-8">
                      <circle cx="12" cy="12" r="10"></circle>
                      <polyline points="12 6 12 12 16 14"></polyline>
                    </svg>
                  </div>
                  <h3 class="text-xl font-semibold text-gray-900 mb-3">7-Day Catch Up &amp; Recording</h3>
                  <p class="text-base text-gray-600">Missed your favorite show? No problem. Watch it anytime or record for later viewing.</p>
                </div>
                <div class="feature-card relative bg-white p-8 rounded-xl shadow-lg border border-gray-100 hover:shadow-blue-100" style="opacity: 1; transform: none;">
                  <div class="text-blue-600 mb-5 inline-block bg-blue-100 p-3 rounded-full">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-8 w-8">
                      <rect width="18" height="18" x="3" y="3" rx="2"></rect>
                      <path d="M7 3v18"></path>
                      <path d="M3 7.5h4"></path>
                      <path d="M3 12h18"></path>
                      <path d="M3 16.5h4"></path>
                      <path d="M17 3v18"></path>
                      <path d="M17 7.5h4"></path>
                      <path d="M17 16.5h4"></path>
                    </svg>
                  </div>
                  <h3 class="text-xl font-semibold text-gray-900 mb-3">Extensive VOD Library</h3>
                  <p class="text-base text-gray-600">Thousands of movies and TV series on demand, updated daily with new releases.</p>
                </div>
                <div class="feature-card relative bg-white p-8 rounded-xl shadow-lg border border-gray-100 hover:shadow-blue-100" style="opacity: 1; transform: none;">
                  <div class="text-blue-600 mb-5 inline-block bg-blue-100 p-3 rounded-full">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-8 w-8">
                      <rect width="14" height="20" x="5" y="2" rx="2" ry="2"></rect>
                      <path d="M12 18h.01"></path>
                    </svg>
                  </div>
                  <h3 class="text-xl font-semibold text-gray-900 mb-3">Multi-Device Support</h3>
                  <p class="text-base text-gray-600">Watch on your Smart TV, smartphone, tablet, computer, or streaming device.</p>
                </div>
                <div class="feature-card relative bg-white p-8 rounded-xl shadow-lg border border-gray-100 hover:shadow-blue-100" style="opacity: 1; transform: none;">
                  <div class="text-blue-600 mb-5 inline-block bg-blue-100 p-3 rounded-full">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-8 w-8">
                      <polygon points="13 19 22 12 13 5 13 19"></polygon>
                      <polygon points="2 19 11 12 2 5 2 19"></polygon>
                    </svg>
                  </div>
                  <h3 class="text-xl font-semibold text-gray-900 mb-3">EPG Integration</h3>
                  <p class="text-base text-gray-600">User-friendly Electronic Program Guide with detailed show information and scheduling.</p>
                </div>
                <div class="feature-card relative bg-white p-8 rounded-xl shadow-lg border border-gray-100 hover:shadow-blue-100" style="opacity: 1; transform: none;">
                  <div class="text-blue-600 mb-5 inline-block bg-blue-100 p-3 rounded-full">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-8 w-8">
                      <path d="m12 3-1.912 5.813a2 2 0 0 1-1.275 1.275L3 12l5.813 1.912a2 2 0 0 1 1.275 1.275L12 21l1.912-5.813a2 2 0 0 1 1.275-1.275L21 12l-5.813-1.912a2 2 0 0 1-1.275-1.275L12 3Z"></path>
                      <path d="M5 3v4"></path>
                      <path d="M19 17v4"></path>
                      <path d="M3 5h4"></path>
                      <path d="M17 19h4"></path>
                    </svg>
                  </div>
                  <h3 class="text-xl font-semibold text-gray-900 mb-3">Buffer-Free Streaming</h3>
                  <p class="text-base text-gray-600">Enjoy uninterrupted viewing with our high-speed servers and advanced technology.</p>
                </div>
              </div>
              <div class="mt-20 text-center">
                <h3 class="text-2xl font-bold text-gray-900 mb-12" style="opacity: 1; transform: none;">Compatible With All Your Favourite Devices</h3>
                <div class="grid grid-cols-2 md:grid-cols-3 lg:grid-cols-6 gap-8">
                  <div class="flex flex-col items-center p-4 bg-white rounded-lg shadow-md hover:shadow-lg transition-shadow" style="opacity: 1; transform: none;">
                    <div class="text-blue-600 p-3 rounded-full mb-3">
                      <svg xmlns="http://www.w3.org/2000/svg" width="40" height="40" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-10 w-10">
                        <rect width="20" height="15" x="2" y="7" rx="2" ry="2"></rect>
                        <polyline points="17 2 12 7 7 2"></polyline>
                      </svg>
                    </div>
                    <span class="text-gray-700 font-medium text-sm">Smart TV (Samsung, LG, Sony etc.)</span>
                  </div>
                  <div class="flex flex-col items-center p-4 bg-white rounded-lg shadow-md hover:shadow-lg transition-shadow" style="opacity: 1; transform: none;">
                    <div class="text-blue-600 p-3 rounded-full mb-3">
                      <svg xmlns="http://www.w3.org/2000/svg" width="40" height="40" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-10 w-10">
                        <rect width="14" height="20" x="5" y="2" rx="2" ry="2"></rect>
                        <path d="M12 18h.01"></path>
                      </svg>
                    </div>
                    <span class="text-gray-700 font-medium text-sm">Mobile (iOS &amp; Android)</span>
                  </div>
                  <div class="flex flex-col items-center p-4 bg-white rounded-lg shadow-md hover:shadow-lg transition-shadow" style="opacity: 1; transform: none;">
                    <div class="text-blue-600 p-3 rounded-full mb-3">
                      <svg xmlns="http://www.w3.org/2000/svg" width="40" height="40" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-10 w-10">
                        <rect width="16" height="20" x="4" y="2" rx="2" ry="2"></rect>
                        <line x1="12" x2="12.01" y1="18" y2="18"></line>
                      </svg>
                    </div>
                    <span class="text-gray-700 font-medium text-sm">Tablets (iPad &amp; Android)</span>
                  </div>
                  <div class="flex flex-col items-center p-4 bg-white rounded-lg shadow-md hover:shadow-lg transition-shadow" style="opacity: 1; transform: none;">
                    <div class="text-blue-600 p-3 rounded-full mb-3">
                      <svg xmlns="http://www.w3.org/2000/svg" width="40" height="40" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-10 w-10">
                        <path d="M20 16V7a2 2 0 0 0-2-2H6a2 2 0 0 0-2 2v9m16 0H4m16 0 1.28 2.55a1 1 0 0 1-.9 1.45H3.62a1 1 0 0 1-.9-1.45L4 16"></path>
                      </svg>
                    </div>
                    <span class="text-gray-700 font-medium text-sm">Computers (Windows &amp; Mac)</span>
                  </div>
                  <div class="flex flex-col items-center p-4 bg-white rounded-lg shadow-md hover:shadow-lg transition-shadow" style="opacity: 1; transform: none;">
                    <div class="text-blue-600 p-3 rounded-full mb-3">
                      <svg xmlns="http://www.w3.org/2000/svg" width="40" height="40" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-10 w-10">
                        <rect width="20" height="14" x="2" y="3" rx="2"></rect>
                        <line x1="8" x2="16" y1="21" y2="21"></line>
                        <line x1="12" x2="12" y1="17" y2="21"></line>
                      </svg>
                    </div>
                    <span class="text-gray-700 font-medium text-sm">Android Box / Firestick</span>
                  </div>
                  <div class="flex flex-col items-center p-4 bg-white rounded-lg shadow-md hover:shadow-lg transition-shadow" style="opacity: 1; transform: none;">
                    <div class="text-blue-600 p-3 rounded-full mb-3">
                      <svg xmlns="http://www.w3.org/2000/svg" width="40" height="40" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-10 w-10">
                        <path d="M16 21v-2a4 4 0 0 0-4-4H6a4 4 0 0 0-4 4v2"></path>
                        <circle cx="9" cy="7" r="4"></circle>
                        <path d="M22 21v-2a4 4 0 0 0-3-3.87"></path>
                        <path d="M16 3.13a4 4 0 0 1 0 7.75"></path>
                      </svg>
                    </div>
                    <span class="text-gray-700 font-medium text-sm">MAG Box / Formuler</span>
                  </div>
                </div>
                <p class="mt-8 text-gray-600">And many more! If your device supports IPTV, it works with {{ $setting->webname }}.</p>
              </div>
            </div>
          </section>
          
          
          
          
          
          <div class="bg-white text-black text-center py-10">
    <h2 class="text-2xl font-bold mb-6">How To Get Your IPTV Subscription?</h2>
    <div class="flex justify-center space-x-6">
        <div class="w-1/4 p-4 bg-gray-100 rounded shadow">
            <div class="flex justify-center mb-4">
                <svg class="w-12 h-12" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
                </svg>
            </div>
            <h3 class="text-lg font-semibold">1. Place your order</h3>
            <p class="text-sm mt-2">Place your order by choosing your preferred subscription period:<br>1, 3, 6, or 12 months.</p>
        </div>
        <div class="w-1/4 p-4 bg-gray-100 rounded shadow">
            <div class="flex justify-center mb-4">
                <svg class="w-12 h-12" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5.121 17.121L3 15m0 0l4-4m-4 4l4 4m6-11a3 3 0 11-6 0 3 3 0 016 0z"></path>
                </svg>
            </div>
            <h3 class="text-lg font-semibold">2. Get your account</h3>
            <p class="text-sm mt-2">The process can take 15 to 30 minutes. Please check your inbox and your spam folder.<br> To speed up the process, please Contact us on WhatsApp.</p>
        </div>
        <div class="w-1/4 p-4 bg-gray-100 rounded shadow">
            <div class="flex justify-center mb-4">
                <svg class="w-12 h-12" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 4v16m10-12v8m-4-8v8"></path>
                </svg>
            </div>
            <h3 class="text-lg font-semibold">3. Enjoy your IPTV UK service!</h3>
            <p class="text-sm mt-2">Enjoy all channels, films and series now!</p>
        </div>
    </div>
</div>
       
          <section id="pricing" class="py-20 bg-gray-50">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
              <div class="text-center" style="opacity: 1; transform: none;">
                <h2 class="text-3xl font-extrabold text-gray-900 sm:text-4xl">Simple, Transparent Pricing</h2>
                <p class="mt-4 max-w-2xl text-xl text-gray-500 mx-auto">Choose the plan that works best for you. All plans include our 30-Day Money-Back Guarantee.</p>
              </div>
              <div class="my-8 p-4 bg-gradient-to-r from-red-500 to-orange-500 rounded-xl shadow-lg text-white text-center" style="opacity: 1; transform: none;">
                <div class="flex items-center justify-center mb-2">
                  <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-8 w-8 mr-3 animate-bounce">
                    <circle cx="12" cy="13" r="8"></circle>
                    <path d="M12 9v4l2 2"></path>
                    <path d="M5 3 2 6"></path>
                    <path d="m22 6-3-3"></path>
                    <path d="M6.38 18.7 4 21"></path>
                    <path d="M17.64 18.67 20 21"></path>
                  </svg>
                  <h3 class="text-2xl font-bold tracking-wider">Limited Time Flash Sale!</h3>
                </div>
                <p class="text-lg mb-3">Prices will return to normal after the timer ends.</p>
                <div class="flex justify-center space-x-4">
                  <div class="flex flex-col items-center">
                    <span class="text-4xl font-extrabold bg-white/20 px-3 py-1 rounded-lg">04</span>
                    <span class="text-xs font-semibold uppercase tracking-wider mt-1">Hours</span>
                  </div>
                  <div class="text-4xl font-extrabold">:</div>
                  <div class="flex flex-col items-center">
                    <span class="text-4xl font-extrabold bg-white/20 px-3 py-1 rounded-lg">54</span>
                    <span class="text-xs font-semibold uppercase tracking-wider mt-1">Minutes</span>
                  </div>
                  <div class="text-4xl font-extrabold">:</div>
                  <div class="flex flex-col items-center">
                    <span class="text-4xl font-extrabold bg-white/20 px-3 py-1 rounded-lg">44</span>
                    <span class="text-xs font-semibold uppercase tracking-wider mt-1">Seconds</span>
                  </div>
                </div>
              </div>
              <div class="mt-16 grid gap-8 lg:grid-cols-4 md:grid-cols-2 sm:grid-cols-1">
                <div class="pricing-card relative rounded-xl shadow-lg overflow-hidden flex flex-col transition-all duration-300 ease-in-out border border-gray-200 hover:shadow-blue-100" style="opacity: 1; transform: none;">
                  <div class="p-8 bg-white">
                    <h3 class="text-2xl font-bold text-gray-900">Monthly</h3>
                    <div class="mt-4 flex items-baseline text-gray-900">
                      <span class="text-5xl font-extrabold tracking-tight">£12.99</span>
                      <span class="ml-1 text-xl font-semibold">per month</span>
                    </div>
                    <p class="mt-5 text-base text-gray-500">Perfect for trying out our service</p>
                  </div>
                  <div class="pt-6 pb-8 px-6 bg-white flex-grow flex flex-col justify-between">
                    <ul role="list" class="space-y-3">
                      <li class="flex items-start">
                        <div class="flex-shrink-0">
                          <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-5 w-5 text-green-500" aria-hidden="true">
                            <polyline points="20 6 9 17 4 12"></polyline>
                          </svg>
                        </div>
                        <p class="ml-3 text-sm text-gray-700">28,000+ Live TV Channels</p>
                      </li>
                      <li class="flex items-start">
                        <div class="flex-shrink-0">
                          <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-5 w-5 text-green-500" aria-hidden="true">
                            <polyline points="20 6 9 17 4 12"></polyline>
                          </svg>
                        </div>
                        <p class="ml-3 text-sm text-gray-700">Full HD &amp; 4K Quality</p>
                      </li>
                      <li class="flex items-start">
                        <div class="flex-shrink-0">
                          <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-5 w-5 text-green-500" aria-hidden="true">
                            <polyline points="20 6 9 17 4 12"></polyline>
                          </svg>
                        </div>
                        <p class="ml-3 text-sm text-gray-700">7-Day Catch Up</p>
                      </li>
                      <li class="flex items-start">
                        <div class="flex-shrink-0">
                          <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-5 w-5 text-green-500" aria-hidden="true">
                            <polyline points="20 6 9 17 4 12"></polyline>
                          </svg>
                        </div>
                        <p class="ml-3 text-sm text-gray-700">VOD Library (Movies &amp; Series)</p>
                      </li>
                      <li class="flex items-start">
                        <div class="flex-shrink-0">
                          <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-5 w-5 text-green-500" aria-hidden="true">
                            <polyline points="20 6 9 17 4 12"></polyline>
                          </svg>
                        </div>
                        <p class="ml-3 text-sm text-gray-700">Use on 1 Device</p>
                      </li>
                      <li class="flex items-start">
                        <div class="flex-shrink-0">
                          <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-5 w-5 text-green-500" aria-hidden="true">
                            <polyline points="20 6 9 17 4 12"></polyline>
                          </svg>
                        </div>
                        <p class="ml-3 text-sm text-gray-700">24/7 Support via WhatsApp</p>
                      </li>
                    </ul>
                    <div class="mt-8">
                      <a href="https://wa.me/{{ $setting->whatsapp }}?text=Hello%20{{ $setting->webname }}%20IPTV%2C%20I'm%20interested%20in%20the%20Monthly%20plan." target="_blank" rel="noopener noreferrer" class="inline-flex items-center justify-center rounded-md text-sm font-medium ring-offset-background transition-colors focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-ring focus-visible:ring-offset-2 disabled:pointer-events-none disabled:opacity-50 h-10 px-4 py-2 w-full bg-blue-600 hover:bg-blue-700 text-white">Get Started</a>
                    </div>
                  </div>
                </div>
                <div class="pricing-card relative rounded-xl shadow-lg overflow-hidden flex flex-col transition-all duration-300 ease-in-out border border-gray-200 hover:shadow-blue-100" style="opacity: 1; transform: none;">
                  <div class="p-8 bg-white">
                    <h3 class="text-2xl font-bold text-gray-900">3 Months</h3>
                    <div class="mt-4 flex items-baseline text-gray-900">
                      <span class="text-5xl font-extrabold tracking-tight">£29.99</span>
                      <span class="ml-1 text-xl font-semibold">every 3 months</span>
                    </div>
                    <p class="mt-5 text-base text-gray-500">Great value for short term</p>
                  </div>
                  <div class="pt-6 pb-8 px-6 bg-white flex-grow flex flex-col justify-between">
                    <ul role="list" class="space-y-3">
                      <li class="flex items-start">
                        <div class="flex-shrink-0">
                          <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-5 w-5 text-green-500" aria-hidden="true">
                            <polyline points="20 6 9 17 4 12"></polyline>
                          </svg>
                        </div>
                        <p class="ml-3 text-sm text-gray-700">28,000+ Live TV Channels</p>
                      </li>
                      <li class="flex items-start">
                        <div class="flex-shrink-0">
                          <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-5 w-5 text-green-500" aria-hidden="true">
                            <polyline points="20 6 9 17 4 12"></polyline>
                          </svg>
                        </div>
                        <p class="ml-3 text-sm text-gray-700">Full HD &amp; 4K Quality</p>
                      </li>
                      <li class="flex items-start">
                        <div class="flex-shrink-0">
                          <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-5 w-5 text-green-500" aria-hidden="true">
                            <polyline points="20 6 9 17 4 12"></polyline>
                          </svg>
                        </div>
                        <p class="ml-3 text-sm text-gray-700">7-Day Catch Up</p>
                      </li>
                      <li class="flex items-start">
                        <div class="flex-shrink-0">
                          <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-5 w-5 text-green-500" aria-hidden="true">
                            <polyline points="20 6 9 17 4 12"></polyline>
                          </svg>
                        </div>
                        <p class="ml-3 text-sm text-gray-700">VOD Library (Movies &amp; Series)</p>
                      </li>
                      <li class="flex items-start">
                        <div class="flex-shrink-0">
                          <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-5 w-5 text-green-500" aria-hidden="true">
                            <polyline points="20 6 9 17 4 12"></polyline>
                          </svg>
                        </div>
                        <p class="ml-3 text-sm text-gray-700">Use on 2 Devices Simultaneously</p>
                      </li>
                      <li class="flex items-start">
                        <div class="flex-shrink-0">
                          <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-5 w-5 text-green-500" aria-hidden="true">
                            <polyline points="20 6 9 17 4 12"></polyline>
                          </svg>
                        </div>
                        <p class="ml-3 text-sm text-gray-700">24/7 Support via WhatsApp</p>
                      </li>
                      <li class="flex items-start">
                        <div class="flex-shrink-0">
                          <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-5 w-5 text-green-500" aria-hidden="true">
                            <polyline points="20 6 9 17 4 12"></polyline>
                          </svg>
                        </div>
                        <p class="ml-3 text-sm text-gray-700">Save over 20% vs Monthly</p>
                      </li>
                    </ul>
                    <div class="mt-8">
                      <a href="https://wa.me/{{ $setting->whatsapp }}?text=Hello%20{{ $setting->webname }}%20IPTV%2C%20I'm%20interested%20in%20the%203%20Months%20plan." target="_blank" rel="noopener noreferrer" class="inline-flex items-center justify-center rounded-md text-sm font-medium ring-offset-background transition-colors focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-ring focus-visible:ring-offset-2 disabled:pointer-events-none disabled:opacity-50 h-10 px-4 py-2 w-full bg-blue-600 hover:bg-blue-700 text-white">Get Started</a>
                    </div>
                  </div>
                </div>
                <div class="pricing-card relative rounded-xl shadow-lg overflow-hidden flex flex-col transition-all duration-300 ease-in-out border-4 border-orange-500 transform scale-105 ring-4 ring-orange-500 ring-opacity-50" style="opacity: 1; transform: none;">
                  <div class="absolute top-0 -right-1 transform translate-x-0 -translate-y-0">
                    <div class="absolute top-0 right-0 h-16 w-16">
                      <div class="absolute transform rotate-45 bg-gradient-to-r from-orange-500 to-red-500 text-center text-white font-semibold py-1 right-[-34px] top-[32px] w-[170px] shadow-md">Hot Sale!</div>
                    </div>
                  </div>
                  <div class="p-8 bg-orange-50">
                    <h3 class="text-2xl font-bold text-gray-900">Annual</h3>
                    <div class="mt-4 flex items-baseline text-gray-900">
                      <span class="text-5xl font-extrabold tracking-tight">£45</span>
                      <span class="ml-1 text-xl font-semibold">per year</span>
                    </div>
                    <p class="mt-5 text-base text-gray-500">Best value for loyal customers</p>
                    <div class="mt-4 p-3 bg-red-100 border-l-4 border-red-500 rounded-r-lg">
                      <p class="font-bold text-red-800">12 Months + 2 Months FREE</p>
                      <div class="flex items-center mt-1 text-sm text-red-600">
                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-4 w-4 mr-1.5">
                          <circle cx="12" cy="12" r="10"></circle>
                          <polyline points="12 6 12 12 16 14"></polyline>
                        </svg>
                        <span>Offer valid for next 5 hours!</span>
                      </div>
                    </div>
                  </div>
                  <div class="pt-6 pb-8 px-6 bg-white flex-grow flex flex-col justify-between">
                    <ul role="list" class="space-y-3">
                      <li class="flex items-start">
                        <div class="flex-shrink-0">
                          <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-5 w-5 text-green-500" aria-hidden="true">
                            <polyline points="20 6 9 17 4 12"></polyline>
                          </svg>
                        </div>
                        <p class="ml-3 text-sm text-gray-700">28,000+ Live TV Channels</p>
                      </li>
                      <li class="flex items-start">
                        <div class="flex-shrink-0">
                          <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-5 w-5 text-green-500" aria-hidden="true">
                            <polyline points="20 6 9 17 4 12"></polyline>
                          </svg>
                        </div>
                        <p class="ml-3 text-sm text-gray-700">Full HD &amp; 4K Quality</p>
                      </li>
                      <li class="flex items-start">
                        <div class="flex-shrink-0">
                          <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-5 w-5 text-green-500" aria-hidden="true">
                            <polyline points="20 6 9 17 4 12"></polyline>
                          </svg>
                        </div>
                        <p class="ml-3 text-sm text-gray-700">7-Day Catch Up &amp; Recording</p>
                      </li>
                      <li class="flex items-start">
                        <div class="flex-shrink-0">
                          <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-5 w-5 text-green-500" aria-hidden="true">
                            <polyline points="20 6 9 17 4 12"></polyline>
                          </svg>
                        </div>
                        <p class="ml-3 text-sm text-gray-700">Premium VOD Library (Updated Daily)</p>
                      </li>
                      <li class="flex items-start">
                        <div class="flex-shrink-0">
                          <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-5 w-5 text-green-500" aria-hidden="true">
                            <polyline points="20 6 9 17 4 12"></polyline>
                          </svg>
                        </div>
                        <p class="ml-3 text-sm text-gray-700">Use on 3 Devices Simultaneously</p>
                      </li>
                      <li class="flex items-start">
                        <div class="flex-shrink-0">
                          <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-5 w-5 text-green-500" aria-hidden="true">
                            <polyline points="20 6 9 17 4 12"></polyline>
                          </svg>
                        </div>
                        <p class="ml-3 text-sm text-gray-700">VIP 24/7 Support</p>
                      </li>
                      <li class="flex items-start">
                        <div class="flex-shrink-0">
                          <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-5 w-5 text-green-500" aria-hidden="true">
                            <polyline points="20 6 9 17 4 12"></polyline>
                          </svg>
                        </div>
                        <p class="ml-3 text-sm text-gray-700">Save over 60% vs Monthly</p>
                      </li>
                      <li class="flex items-start">
                        <div class="flex-shrink-0">
                          <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-5 w-5 text-green-500" aria-hidden="true">
                            <polyline points="20 6 9 17 4 12"></polyline>
                          </svg>
                        </div>
                        <p class="ml-3 text-sm text-gray-700">Free Setup Assistance</p>
                      </li>
                    </ul>
                    <div class="mt-8">
                      <a href="https://wa.me/{{ $setting->whatsapp }}?text=Hello%20{{ $setting->webname }}%20IPTV%2C%20I'm%20interested%20in%20the%20Annual%20plan." target="_blank" rel="noopener noreferrer" class="inline-flex items-center justify-center rounded-md text-sm font-medium ring-offset-background transition-colors focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-ring focus-visible:ring-offset-2 disabled:pointer-events-none disabled:opacity-50 bg-primary hover:bg-primary/90 h-10 px-4 py-2 w-full bg-gradient-to-r from-orange-500 to-red-600 hover:from-orange-600 hover:to-red-700 text-white shadow-lg hover:shadow-xl">Get Started</a>
                    </div>
                  </div>
                </div>
                <div class="pricing-card relative rounded-xl shadow-lg overflow-hidden flex flex-col transition-all duration-300 ease-in-out border border-gray-200 hover:shadow-blue-100" style="opacity: 1; transform: none;">
                  <div class="p-8 bg-white">
                    <h3 class="text-2xl font-bold text-gray-900">Quarterly</h3>
                    <div class="mt-4 flex items-baseline text-gray-900">
                      <span class="text-5xl font-extrabold tracking-tight">£34.99</span>
                      <span class="ml-1 text-xl font-semibold">per quarter</span>
                    </div>
                    <p class="mt-5 text-base text-gray-500">Popular choice for commitment</p>
                  </div>
                  <div class="pt-6 pb-8 px-6 bg-white flex-grow flex flex-col justify-between">
                    <ul role="list" class="space-y-3">
                      <li class="flex items-start">
                        <div class="flex-shrink-0">
                          <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-5 w-5 text-green-500" aria-hidden="true">
                            <polyline points="20 6 9 17 4 12"></polyline>
                          </svg>
                        </div>
                        <p class="ml-3 text-sm text-gray-700">28,000+ Live TV Channels</p>
                      </li>
                      <li class="flex items-start">
                        <div class="flex-shrink-0">
                          <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-5 w-5 text-green-500" aria-hidden="true">
                            <polyline points="20 6 9 17 4 12"></polyline>
                          </svg>
                        </div>
                        <p class="ml-3 text-sm text-gray-700">Full HD &amp; 4K Quality</p>
                      </li>
                      <li class="flex items-start">
                        <div class="flex-shrink-0">
                          <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-5 w-5 text-green-500" aria-hidden="true">
                            <polyline points="20 6 9 17 4 12"></polyline>
                          </svg>
                        </div>
                        <p class="ml-3 text-sm text-gray-700">7-Day Catch Up &amp; Recording</p>
                      </li>
                      <li class="flex items-start">
                        <div class="flex-shrink-0">
                          <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-5 w-5 text-green-500" aria-hidden="true">
                            <polyline points="20 6 9 17 4 12"></polyline>
                          </svg>
                        </div>
                        <p class="ml-3 text-sm text-gray-700">Extensive VOD Library</p>
                      </li>
                      <li class="flex items-start">
                        <div class="flex-shrink-0">
                          <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-5 w-5 text-green-500" aria-hidden="true">
                            <polyline points="20 6 9 17 4 12"></polyline>
                          </svg>
                        </div>
                        <p class="ml-3 text-sm text-gray-700">Use on 2 Devices Simultaneously</p>
                      </li>
                      <li class="flex items-start">
                        <div class="flex-shrink-0">
                          <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-5 w-5 text-green-500" aria-hidden="true">
                            <polyline points="20 6 9 17 4 12"></polyline>
                          </svg>
                        </div>
                        <p class="ml-3 text-sm text-gray-700">Priority 24/7 Support</p>
                      </li>
                      <li class="flex items-start">
                        <div class="flex-shrink-0">
                          <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-5 w-5 text-green-500" aria-hidden="true">
                            <polyline points="20 6 9 17 4 12"></polyline>
                          </svg>
                        </div>
                        <p class="ml-3 text-sm text-gray-700">Early access to new features</p>
                      </li>
                    </ul>
                    <div class="mt-8">
                      <a href="https://wa.me/{{ $setting->whatsapp }}?text=Hello%20{{ $setting->webname }}%20IPTV%2C%20I'm%20interested%20in%20the%20Quarterly%20plan." target="_blank" rel="noopener noreferrer" class="inline-flex items-center justify-center rounded-md text-sm font-medium ring-offset-background transition-colors focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-ring focus-visible:ring-offset-2 disabled:pointer-events-none disabled:opacity-50 h-10 px-4 py-2 w-full bg-blue-600 hover:bg-blue-700 text-white">Get Started</a>
                    </div>
                  </div>
                </div>
              </div>
              <div class="mt-12 py-8 bg-gray-100 rounded-lg">
                <div class="text-center" style="opacity: 1; transform: none;">
                  <div class="flex items-center justify-center mb-4">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-8 w-8 text-green-500 mr-2">
                      <path d="M12 22s8-4 8-10V5l-8-3-8 3v7c0 6 8 10 8 10"></path>
                      <path d="m9 12 2 2 4-4"></path>
                    </svg>
                    <h4 class="text-xl font-semibold text-gray-800">Secure Payment Options</h4>
                  </div>
                  <p class="text-gray-600 mb-6">We accept various secure payment methods for your convenience.</p>
                  <div class="flex justify-center items-center space-x-6 sm:space-x-12">
                    <div class="flex flex-col items-center text-center" style="opacity: 1; transform: none;">
                      <div class="p-3 bg-white rounded-full shadow-md mb-2">
                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-10 w-10 text-blue-600">
                          <rect width="20" height="14" x="2" y="5" rx="2"></rect>
                          <line x1="2" x2="22" y1="10" y2="10"></line>
                        </svg>
                      </div>
                      <span class="text-sm font-medium text-gray-700">Card Payments</span>
                    </div>
                    <div class="flex flex-col items-center text-center" style="opacity: 1; transform: none;">
                      <div class="p-3 bg-white rounded-full shadow-md mb-2">
                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-10 w-10 text-blue-500">
                          <polyline points="22 7 13.5 15.5 8.5 10.5 2 17"></polyline>
                          <polyline points="16 7 22 7 22 13"></polyline>
                        </svg>
                      </div>
                      <span class="text-sm font-medium text-gray-700">PayPal</span>
                    </div>
                    <div class="flex flex-col items-center text-center" style="opacity: 1; transform: none;">
                      <div class="p-3 bg-white rounded-full shadow-md mb-2">
                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-10 w-10 text-green-600">
                          <rect width="20" height="12" x="2" y="6" rx="2"></rect>
                          <circle cx="12" cy="12" r="2"></circle>
                          <path d="M6 12h.01M18 12h.01"></path>
                        </svg>
                      </div>
                      <span class="text-sm font-medium text-gray-700">Bank Transfer</span>
                    </div>
                  </div>
                </div>
              </div>
              <div class="mt-16 bg-gradient-to-r from-blue-600 to-indigo-700 rounded-lg shadow-xl p-8 md:p-12 border border-blue-700 text-white" style="opacity: 1; transform: none;">
                <div class="text-center">
                  <h3 class="text-3xl font-extrabold sm:text-4xl">Ready for a Longer Test Drive?</h3>
                  <p class="mt-4 text-lg sm:text-xl text-blue-100 max-w-3xl mx-auto">Experience the full power of {{ $setting->webname }} IPTV with our exclusive 24-hour free trial. Access all 28,000+ channels, VOD, and premium features with no obligation. It's the perfect way to see why we're the UK's favourite IPTV provider!</p>
                  <div class="mt-8">
                    <a class="inline-flex items-center justify-center ring-offset-background focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-ring focus-visible:ring-offset-2 disabled:pointer-events-none disabled:opacity-50 h-11 rounded-md bg-white text-blue-600 hover:bg-gray-100 shadow-md hover:shadow-lg transform hover:scale-105 transition-all duration-300 px-10 py-3 text-lg font-semibold" href="/trial">Request 24hr Trial Now</a>
                  </div>
                </div>
              </div>
            </div>
          </section>
          <section id="money-back-guarantee" class="py-20 bg-blue-600 text-white">
            <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
              <div style="opacity: 1; transform: none;">
                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-20 w-20 mx-auto mb-6 text-green-400">
                  <path d="M12 22s8-4 8-10V5l-8-3-8 3v7c0 6 8 10 8 10"></path>
                  <path d="m9 12 2 2 4-4"></path>
                </svg>
                <h2 class="text-3xl font-extrabold sm:text-4xl mb-4">Our 30-Day Money-Back Guarantee</h2>
                <p class="text-xl text-blue-100 mb-8 max-w-2xl mx-auto">We are confident you'll love {{ $setting->webname }} IPTV. However, if you're not completely satisfied within the first 30 days of your subscription, we'll give you a full refund. No hassle, no questions asked. Your satisfaction is our priority!</p>
                <div class="flex items-center justify-center text-lg text-blue-200">
                  <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-6 w-6 mr-2 text-yellow-400">
                    <circle cx="12" cy="12" r="10"></circle>
                    <path d="M8 14s1.5 2 4 2 4-2 4-2"></path>
                    <line x1="9" x2="9.01" y1="9" y2="9"></line>
                    <line x1="15" x2="15.01" y1="9" y2="9"></line>
                  </svg>
                  <span>Risk-Free Trial - Experience the Best in UK IPTV!</span>
                </div>
              </div>
            </div>
          </section>
          <section class="py-20 bg-white">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
              <div class="text-center mb-16" style="opacity: 1; transform: none;">
                <h2 class="text-3xl font-extrabold text-gray-900 sm:text-4xl">What Our Customers Say</h2>
                <p class="mt-4 max-w-2xl text-xl text-gray-500 mx-auto">Don't just take our word for it - hear from our satisfied customers</p>
              </div>
              <div class="grid gap-8 md:grid-cols-2 lg:grid-cols-4">
                <div class="testimonial-card bg-gray-50 rounded-lg p-6 shadow-sm border border-gray-200" style="opacity: 1; transform: none;">
                  <div class="flex items-center mb-4">
                    <div class="h-12 w-12 rounded-full bg-blue-600 flex items-center justify-center text-white font-bold text-lg">JW</div>
                    <div class="ml-4">
                      <h4 class="text-lg font-medium text-gray-900">James Wilson</h4>
                      <p class="text-sm text-gray-500">London</p>
                    </div>
                  </div>
                  <div class="flex mb-4">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-5 w-5 text-yellow-400 fill-yellow-400">
                      <polygon points="12 2 15.09 8.26 22 9.27 17 14.14 18.18 21.02 12 17.77 5.82 21.02 7 14.14 2 9.27 8.91 8.26 12 2"></polygon>
                    </svg>
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-5 w-5 text-yellow-400 fill-yellow-400">
                      <polygon points="12 2 15.09 8.26 22 9.27 17 14.14 18.18 21.02 12 17.77 5.82 21.02 7 14.14 2 9.27 8.91 8.26 12 2"></polygon>
                    </svg>
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-5 w-5 text-yellow-400 fill-yellow-400">
                      <polygon points="12 2 15.09 8.26 22 9.27 17 14.14 18.18 21.02 12 17.77 5.82 21.02 7 14.14 2 9.27 8.91 8.26 12 2"></polygon>
                    </svg>
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-5 w-5 text-yellow-400 fill-yellow-400">
                      <polygon points="12 2 15.09 8.26 22 9.27 17 14.14 18.18 21.02 12 17.77 5.82 21.02 7 14.14 2 9.27 8.91 8.26 12 2"></polygon>
                    </svg>
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-5 w-5 text-yellow-400 fill-yellow-400">
                      <polygon points="12 2 15.09 8.26 22 9.27 17 14.14 18.18 21.02 12 17.77 5.82 21.02 7 14.14 2 9.27 8.91 8.26 12 2"></polygon>
                    </svg>
                  </div>
                  <p class="text-gray-600 italic">"I've tried several IPTV services, but {{ $setting->webname }} IPTV is by far the best. The channel selection is amazing, and the quality is superb. I never miss my favorite football matches now!"</p>
                </div>
                <div class="testimonial-card bg-gray-50 rounded-lg p-6 shadow-sm border border-gray-200" style="opacity: 1; transform: none;">
                  <div class="flex items-center mb-4">
                    <div class="h-12 w-12 rounded-full bg-blue-600 flex items-center justify-center text-white font-bold text-lg">ST</div>
                    <div class="ml-4">
                      <h4 class="text-lg font-medium text-gray-900">Sarah Thompson</h4>
                      <p class="text-sm text-gray-500">Manchester</p>
                    </div>
                  </div>
                  <div class="flex mb-4">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-5 w-5 text-yellow-400 fill-yellow-400">
                      <polygon points="12 2 15.09 8.26 22 9.27 17 14.14 18.18 21.02 12 17.77 5.82 21.02 7 14.14 2 9.27 8.91 8.26 12 2"></polygon>
                    </svg>
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-5 w-5 text-yellow-400 fill-yellow-400">
                      <polygon points="12 2 15.09 8.26 22 9.27 17 14.14 18.18 21.02 12 17.77 5.82 21.02 7 14.14 2 9.27 8.91 8.26 12 2"></polygon>
                    </svg>
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-5 w-5 text-yellow-400 fill-yellow-400">
                      <polygon points="12 2 15.09 8.26 22 9.27 17 14.14 18.18 21.02 12 17.77 5.82 21.02 7 14.14 2 9.27 8.91 8.26 12 2"></polygon>
                    </svg>
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-5 w-5 text-yellow-400 fill-yellow-400">
                      <polygon points="12 2 15.09 8.26 22 9.27 17 14.14 18.18 21.02 12 17.77 5.82 21.02 7 14.14 2 9.27 8.91 8.26 12 2"></polygon>
                    </svg>
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-5 w-5 text-yellow-400 fill-yellow-400">
                      <polygon points="12 2 15.09 8.26 22 9.27 17 14.14 18.18 21.02 12 17.77 5.82 21.02 7 14.14 2 9.27 8.91 8.26 12 2"></polygon>
                    </svg>
                  </div>
                  <p class="text-gray-600 italic">"The customer service is exceptional. When I had trouble setting up on my Fire Stick, they guided me through the entire process. Now I can watch all my favorite UK shows even though I live abroad."</p>
                </div>
                <div class="testimonial-card bg-gray-50 rounded-lg p-6 shadow-sm border border-gray-200" style="opacity: 1; transform: none;">
                  <div class="flex items-center mb-4">
                    <div class="h-12 w-12 rounded-full bg-blue-600 flex items-center justify-center text-white font-bold text-lg">DC</div>
                    <div class="ml-4">
                      <h4 class="text-lg font-medium text-gray-900">David Clark</h4>
                      <p class="text-sm text-gray-500">Birmingham</p>
                    </div>
                  </div>
                  <div class="flex mb-4">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-5 w-5 text-yellow-400 fill-yellow-400">
                      <polygon points="12 2 15.09 8.26 22 9.27 17 14.14 18.18 21.02 12 17.77 5.82 21.02 7 14.14 2 9.27 8.91 8.26 12 2"></polygon>
                    </svg>
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-5 w-5 text-yellow-400 fill-yellow-400">
                      <polygon points="12 2 15.09 8.26 22 9.27 17 14.14 18.18 21.02 12 17.77 5.82 21.02 7 14.14 2 9.27 8.91 8.26 12 2"></polygon>
                    </svg>
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-5 w-5 text-yellow-400 fill-yellow-400">
                      <polygon points="12 2 15.09 8.26 22 9.27 17 14.14 18.18 21.02 12 17.77 5.82 21.02 7 14.14 2 9.27 8.91 8.26 12 2"></polygon>
                    </svg>
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-5 w-5 text-yellow-400 fill-yellow-400">
                      <polygon points="12 2 15.09 8.26 22 9.27 17 14.14 18.18 21.02 12 17.77 5.82 21.02 7 14.14 2 9.27 8.91 8.26 12 2"></polygon>
                    </svg>
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-5 w-5 text-gray-300">
                      <polygon points="12 2 15.09 8.26 22 9.27 17 14.14 18.18 21.02 12 17.77 5.82 21.02 7 14.14 2 9.27 8.91 8.26 12 2"></polygon>
                    </svg>
                  </div>
                  <p class="text-gray-600 italic">"Great value for money. The channel selection is vast, and the HD quality is impressive. The catch-up feature is a lifesaver when I miss my favorite programs."</p>
                </div>
                <div class="testimonial-card bg-gray-50 rounded-lg p-6 shadow-sm border border-gray-200" style="opacity: 1; transform: none;">
                  <div class="flex items-center mb-4">
                    <div class="h-12 w-12 rounded-full bg-blue-600 flex items-center justify-center text-white font-bold text-lg">ER</div>
                    <div class="ml-4">
                      <h4 class="text-lg font-medium text-gray-900">Emma Roberts</h4>
                      <p class="text-sm text-gray-500">Glasgow</p>
                    </div>
                  </div>
                  <div class="flex mb-4">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-5 w-5 text-yellow-400 fill-yellow-400">
                      <polygon points="12 2 15.09 8.26 22 9.27 17 14.14 18.18 21.02 12 17.77 5.82 21.02 7 14.14 2 9.27 8.91 8.26 12 2"></polygon>
                    </svg>
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-5 w-5 text-yellow-400 fill-yellow-400">
                      <polygon points="12 2 15.09 8.26 22 9.27 17 14.14 18.18 21.02 12 17.77 5.82 21.02 7 14.14 2 9.27 8.91 8.26 12 2"></polygon>
                    </svg>
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-5 w-5 text-yellow-400 fill-yellow-400">
                      <polygon points="12 2 15.09 8.26 22 9.27 17 14.14 18.18 21.02 12 17.77 5.82 21.02 7 14.14 2 9.27 8.91 8.26 12 2"></polygon>
                    </svg>
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-5 w-5 text-yellow-400 fill-yellow-400">
                      <polygon points="12 2 15.09 8.26 22 9.27 17 14.14 18.18 21.02 12 17.77 5.82 21.02 7 14.14 2 9.27 8.91 8.26 12 2"></polygon>
                    </svg>
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-5 w-5 text-yellow-400 fill-yellow-400">
                      <polygon points="12 2 15.09 8.26 22 9.27 17 14.14 18.18 21.02 12 17.77 5.82 21.02 7 14.14 2 9.27 8.91 8.26 12 2"></polygon>
                    </svg>
                  </div>
                  <p class="text-gray-600 italic">"I've been using {{ $setting->webname }} IPTV for over a year now, and I'm extremely satisfied. The service is reliable, and they keep adding new channels. Highly recommended!"</p>
                </div>
              </div>
              <div class="mt-12 text-center" style="opacity: 1; transform: none;">
                <a href="/reviews">
                  <button class="inline-flex items-center justify-center text-sm font-medium ring-offset-background transition-colors focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-ring focus-visible:ring-offset-2 disabled:pointer-events-none disabled:opacity-50 border bg-background h-11 rounded-md px-8 text-blue-600 border-blue-600 hover:bg-blue-50 hover:text-blue-700">Read More Reviews</button>
                </a>
              </div>
              <div class="mt-16 text-center" style="opacity: 1; transform: none;">
                <p class="text-lg text-gray-600">Join thousands of satisfied customers across the UK and experience premium IPTV service.</p>
                <div class="mt-8">
                  <a href="https://wa.me/{{ $setting->whatsapp }}?text=Hello%20{{ $setting->webname }}%20IPTV%2C%20I'm%20impressed%20by%20your%20customer%20testimonials%20and%20want%20to%20get%20started!" target="_blank" rel="noopener noreferrer" class="justify-center ring-offset-background transition-colors focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-ring focus-visible:ring-offset-2 disabled:pointer-events-none disabled:opacity-50 h-10 inline-flex items-center px-6 py-3 border border-transparent text-base font-medium rounded-md shadow-sm text-white bg-blue-600 hover:bg-blue-700">Get Started Today</a>
                </div>
              </div>
            </div>
          </section>
          <section class="py-16 md:py-24 bg-gray-800 text-gray-200" style="opacity: 1;">
            <div class="max-w-5xl mx-auto px-4 sm:px-6 lg:px-8">
              <div class="text-center mb-12" style="opacity: 1; transform: none;">
                <h2 class="text-3xl sm:text-4xl font-extrabold text-white tracking-tight">Experience <span class="text-blue-400 font-semibold">Unmatched IPTV</span> Performance </h2>
                <p class="mt-4 text-lg text-gray-400 max-w-3xl mx-auto">Discover why {{ $setting->webname }} IPTV is the preferred choice for viewers across the UK. We're committed to delivering a seamless, high-quality entertainment experience.</p>
              </div>
              <div class="mb-12 p-6 md:p-8 bg-gray-700 rounded-xl shadow-2xl" style="opacity: 1; transform: none;">
                <div class="flex items-center mb-4">
                  <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-8 w-8 text-yellow-400 mr-3">
                    <polygon points="13 2 3 14 12 14 11 22 21 10 12 10 13 2"></polygon>
                  </svg>
                  <h3 class="text-2xl font-bold text-white">NO IPTV FREEZING, NO IPTV BUFFERING</h3>
                </div>
                <p class="text-gray-300 leading-relaxed">Tired of interruptions? Our <span class="text-blue-400 font-semibold">ALL IN ONE SMARTER IPTV</span> solution ensures a smooth viewing experience. You don’t have to pay hefty monthly subscriptions anymore. With our service, pay once for your chosen period and enjoy all sports packages, your favorite channels in <span class="text-blue-400 font-semibold">SD, HD, and FHD quality</span>, even with slower internet speeds. This IPTV is designed for you, and we'll make it work seamlessly. </p>
              </div>
              <div class="grid md:grid-cols-2 gap-8 mb-12" style="opacity: 1; transform: none;">
                <div class="p-6 bg-gray-700 rounded-xl shadow-xl">
                  <div class="flex items-center mb-3">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-7 w-7 text-blue-400 mr-3">
                      <rect width="20" height="15" x="2" y="7" rx="2" ry="2"></rect>
                      <polyline points="17 2 12 7 7 2"></polyline>
                    </svg>
                    <h4 class="text-xl font-semibold text-white">Best IPTV UK Subscription</h4>
                  </div>
                  <p class="text-gray-300">Welcome to the new age of television. UK IPTV is the beacon of modern TV, providing an exceptional viewing experience. Our subscription is undoubtedly the best in the UK, with over <span class="text-blue-400 font-semibold">28,000+ total channels</span> including <span class="text-blue-400 font-semibold">5,500+ dedicated sports channels</span>. Never miss a moment of action, be it football, cricket, or golf. Enjoy seamless, high-quality streaming directly to your living room. </p>
                </div>
                <div class="p-6 bg-gray-700 rounded-xl shadow-xl">
                  <div class="flex items-center mb-3">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-7 w-7 text-green-400 mr-3">
                      <path d="M12 22s8-4 8-10V5l-8-3-8 3v7c0 6 8 10 8 10"></path>
                      <path d="m9 12 2 2 4-4"></path>
                    </svg>
                    <h4 class="text-xl font-semibold text-white">Why Choose Premium IPTV Services UK?</h4>
                  </div>
                  <p class="text-gray-300">We stand ahead of the pack. Our service delivers high-quality viewing across diverse genres: news, documentaries, movies, music, and an impressive sports lineup. It's your one-stop entertainment solution, supporting <span class="text-blue-400 font-semibold">all types of devices</span>. Watch anytime, anywhere, and try risk-free with our <span class="text-blue-400 font-semibold">7-day money-back guarantee</span> (Note: main guarantee is 30 days, this might be a specific offer). </p>
                </div>
              </div>
              <div class="mb-12 p-6 md:p-8 bg-gray-700 rounded-xl shadow-2xl" style="opacity: 1; transform: none;">
                <div class="flex items-center mb-4">
                  <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-8 w-8 text-purple-400 mr-3">
                    <rect width="18" height="18" x="3" y="3" rx="2"></rect>
                    <path d="M7 3v18"></path>
                    <path d="M3 7.5h4"></path>
                    <path d="M3 12h18"></path>
                    <path d="M3 16.5h4"></path>
                    <path d="M17 3v18"></path>
                    <path d="M17 7.5h4"></path>
                    <path d="M17 16.5h4"></path>
                  </svg>
                  <h3 class="text-2xl font-bold text-white">Best IPTV UK Subscription Provider For Firestick 2024 &amp; More</h3>
                </div>
                <p class="text-gray-300 leading-relaxed">{{ $setting->webname }} IPTV is a great service allowing you to watch over <span class="text-blue-400 font-semibold">28,000+ live IPTV channels</span> and an extensive library of over <span class="text-blue-400 font-semibold">99,000+ videos on demand (VOD)</span>. We offer a cost-effective service with stable channels, mostly in Full HD. Say goodbye to expensive cable bills. Our IPTV Service boasts <span class="text-blue-400 font-semibold">99.99% uptime</span>! Enjoy a solid, buffer-free, and freeze-free experience (stable internet required). You get a 100% satisfaction guarantee at a better price. </p>
              </div>
              <div class="grid md:grid-cols-2 gap-8" style="opacity: 1; transform: none;">
                <div class="p-6 bg-gray-700 rounded-xl shadow-xl">
                  <div class="flex items-center mb-3">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-7 w-7 text-teal-400 mr-3">
                      <path d="M3 14h3a2 2 0 0 1 2 2v3a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2v-7a9 9 0 0 1 18 0v7a2 2 0 0 1-2 2h-1a2 2 0 0 1-2-2v-3a2 2 0 0 1 2-2h3"></path>
                    </svg>
                    <h4 class="text-xl font-semibold text-white">Top Quality Support</h4>
                  </div>
                  <p class="text-gray-300">We've got you covered. Our dedicated team ensures your IPTV experience is smooth and hassle-free. For any questions or issues, top-quality support is just a message away.</p>
                </div>
                <div class="p-6 bg-gray-700 rounded-xl shadow-xl">
                  <div class="flex items-center mb-3">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-7 w-7 text-red-400 mr-3">
                      <path d="M5 13a10 10 0 0 1 14 0"></path>
                      <path d="M8.5 16.5a5 5 0 0 1 7 0"></path>
                      <path d="M2 8.82a15 15 0 0 1 20 0"></path>
                      <line x1="12" x2="12.01" y1="20" y2="20"></line>
                    </svg>
                    <h4 class="text-xl font-semibold text-white">VPN Usage &amp; Channel Coverage</h4>
                  </div>
                  <p class="text-gray-300">While some providers might require a VPN, it's <span class="text-blue-400 font-semibold">not needed with our service</span>. However, we are VPN friendly if you choose to use one. Our channel coverage spans worldwide countries including the USA, Canada, UK, Italy, Spain, UAE, Germany, France, South America, Turkey, and many more. We also have <span class="text-blue-400 font-semibold">EPG (Electronic Program Guide)</span> installed so you can see what’s on or coming up, just like a traditional TV guide. </p>
                </div>
              </div>
              <div class="mt-12 text-center" style="opacity: 1; transform: none;">
                <p class="text-gray-400 text-sm">Channel counts and VOD numbers are approximate and subject to updates to provide the best possible selection.</p>
              </div>
            </div>
          </section>





<!-- Include Alpine.js in your HTML if not already -->
<script src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js" defer></script>

<section id="faq" class="py-20 bg-gray-50">
  <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
    <div class="text-center mb-16">
      <h2 class="text-3xl font-extrabold text-gray-900 sm:text-4xl">Frequently Asked Questions</h2>
      <p class="mt-4 max-w-2xl text-xl text-gray-500 mx-auto">Find answers to common questions about our IPTV service</p>
    </div>

    <div class="space-y-4">
      <!-- FAQ Item -->
      <div x-data="{ open: false }" class="bg-white rounded-lg shadow-sm border border-gray-200">
        <button @click="open = !open" class="w-full flex items-center justify-between px-6 py-4 text-left text-gray-900 font-medium hover:underline">
          What is IPTV?
          <svg :class="{ 'rotate-180': open }" class="h-4 w-4 transition-transform duration-200" xmlns="http://www.w3.org/2000/svg" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 9l6 6 6-6"/>
          </svg>
        </button>
        <div x-show="open" x-collapse class="px-6 pb-4 text-sm text-gray-600">
          IPTV (Internet Protocol Television) delivers TV content via internet protocol networks instead of traditional cable or satellite.
        </div>
      </div>

      <!-- Duplicate below for more FAQs -->
      <div x-data="{ open: false }" class="bg-white rounded-lg shadow-sm border border-gray-200">
        <button @click="open = !open" class="w-full flex items-center justify-between px-6 py-4 text-left text-gray-900 font-medium hover:underline">
          What devices can I use with {{ $setting->webname }} IPTV?
          <svg :class="{ 'rotate-180': open }" class="h-4 w-4 transition-transform duration-200" xmlns="http://www.w3.org/2000/svg" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 9l6 6 6-6"/>
          </svg>
        </button>
        <div x-show="open" x-collapse class="px-6 pb-4 text-sm text-gray-600">
          You can use {{ $setting->webname }} IPTV on Smart TVs, Android Boxes, Firestick, iOS/Android phones, and web browsers.
        </div>
      </div>

      <!-- Add more FAQs following the same structure -->

        <div x-data="{ open: false }" class="bg-white rounded-lg shadow-sm border border-gray-200">
        <button @click="open = !open" class="w-full flex items-center justify-between px-6 py-4 text-left text-gray-900 font-medium hover:underline">
          How many devices can I use simultaneously?
          <svg :class="{ 'rotate-180': open }" class="h-4 w-4 transition-transform duration-200" xmlns="http://www.w3.org/2000/svg" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 9l6 6 6-6"/>
          </svg>
        </button>
        <div x-show="open" x-collapse class="px-6 pb-4 text-sm text-gray-600">
         The number of simultaneous connections depends on your subscription plan. Our Monthly plan allows 1 device, Quarterly plan allows 2 devices, and Annual plan allows 3 devices to be used at the same time.

        </div>
      </div>


        <div x-data="{ open: false }" class="bg-white rounded-lg shadow-sm border border-gray-200">
        <button @click="open = !open" class="w-full flex items-center justify-between px-6 py-4 text-left text-gray-900 font-medium hover:underline">
         Do you offer a free trial?
          <svg :class="{ 'rotate-180': open }" class="h-4 w-4 transition-transform duration-200" xmlns="http://www.w3.org/2000/svg" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 9l6 6 6-6"/>
          </svg>
        </button>
        <div x-show="open" x-collapse class="px-6 pb-4 text-sm text-gray-600">
        Yes, we offer a 24-hour free trial so you can test our service before committing to a subscription. Please contact our customer support team to request a free trial.


        </div>
      </div>


           <div x-data="{ open: false }" class="bg-white rounded-lg shadow-sm border border-gray-200">
        <button @click="open = !open" class="w-full flex items-center justify-between px-6 py-4 text-left text-gray-900 font-medium hover:underline">
        What channels are included?
          <svg :class="{ 'rotate-180': open }" class="h-4 w-4 transition-transform duration-200" xmlns="http://www.w3.org/2000/svg" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 9l6 6 6-6"/>
          </svg>
        </button>
        <div x-show="open" x-collapse class="px-6 pb-4 text-sm text-gray-600">
       We offer over 10,000 channels from the UK and around the world. This includes all major UK channels (BBC, ITV, Channel 4, Channel 5), premium sports channels (Sky Sports, BT Sport), movie channels (Sky Cinema), entertainment channels, documentaries, news, and international channels.



        </div>
      </div>

           <div x-data="{ open: false }" class="bg-white rounded-lg shadow-sm border border-gray-200">
        <button @click="open = !open" class="w-full flex items-center justify-between px-6 py-4 text-left text-gray-900 font-medium hover:underline">
        Is {{ $setting->webname }} IPTV legal?
          <svg :class="{ 'rotate-180': open }" class="h-4 w-4 transition-transform duration-200" xmlns="http://www.w3.org/2000/svg" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 9l6 6 6-6"/>
          </svg>
        </button>
        <div x-show="open" x-collapse class="px-6 pb-4 text-sm text-gray-600">
      {{ $setting->webname }} IPTV operates as a content aggregator service. We recommend all users ensure they have appropriate subscriptions to the content they access and to use our service in accordance with local laws and regulations.




        </div>
      </div>


        <div x-data="{ open: false }" class="bg-white rounded-lg shadow-sm border border-gray-200">
        <button @click="open = !open" class="w-full flex items-center justify-between px-6 py-4 text-left text-gray-900 font-medium hover:underline">
       What internet speed do I need?
          <svg :class="{ 'rotate-180': open }" class="h-4 w-4 transition-transform duration-200" xmlns="http://www.w3.org/2000/svg" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 9l6 6 6-6"/>
          </svg>
        </button>
        <div x-show="open" x-collapse class="px-6 pb-4 text-sm text-gray-600">
     We recommend a minimum internet speed of 10 Mbps for SD content, 15 Mbps for HD content, and 25 Mbps for 4K content. A stable internet connection is more important than raw speed for uninterrupted viewing.




        </div>
      </div>

        <div x-data="{ open: false }" class="bg-white rounded-lg shadow-sm border border-gray-200">
        <button @click="open = !open" class="w-full flex items-center justify-between px-6 py-4 text-left text-gray-900 font-medium hover:underline">
      How do I set up {{ $setting->webname }} IPTV?
          <svg :class="{ 'rotate-180': open }" class="h-4 w-4 transition-transform duration-200" xmlns="http://www.w3.org/2000/svg" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 9l6 6 6-6"/>
          </svg>
        </button>
        <div x-show="open" x-collapse class="px-6 pb-4 text-sm text-gray-600">
    After subscribing, you'll receive detailed setup instructions via email. The setup process is straightforward and typically takes just a few minutes. If you need assistance, our customer support team is available 24/7 to help you.





        </div>
      </div>

        <div class="mt-12 text-center bg-white p-8 rounded-lg shadow-md border border-gray-200" style="opacity: 1; transform: none;">
                <h3 class="text-xl font-bold text-gray-900">Still have questions?</h3>
                <p class="mt-2 text-gray-600">Our customer support team is available 24/7 to assist you with any questions or concerns.</p>
                <div class="mt-6">
                  <a href="https://wa.me/{{ $setting->whatsapp }}?text=Hello%20{{ $setting->webname }}%20IPTV%2C%20I%20have%20a%20question%20after%20reading%20the%20FAQ." target="_blank" rel="noopener noreferrer" class="justify-center ring-offset-background transition-colors focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-ring focus-visible:ring-offset-2 disabled:pointer-events-none disabled:opacity-50 h-10 inline-flex items-center px-6 py-3 border border-transparent text-base font-medium rounded-md shadow-sm text-white bg-blue-600 hover:bg-blue-700">Contact Us</a>
                </div>
              </div>

    </div>
  </div>
</section>




     
          <section id="contact" class="py-20 bg-white">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
              <div class="text-center mb-16" style="opacity: 1; transform: none;">
                <h2 class="text-3xl font-extrabold text-gray-900 sm:text-4xl">Contact Us</h2>
                <p class="mt-4 max-w-2xl text-xl text-gray-500 mx-auto">Have questions or need assistance? We're here to help!</p>
              </div>
              <div class="grid grid-cols-1 lg:grid-cols-2 gap-12">
                <div style="opacity: 1; transform: none;">
                  <div class="bg-gray-50 p-8 rounded-lg shadow-md border border-gray-200 h-full">
                    <h3 class="text-2xl font-bold text-gray-900 mb-6">Get in Touch</h3>
                    <div class="space-y-6">
                      <a href="https://wa.me/{{ $setting->whatsapp }}?text=Hello%20{{ $setting->webname }}%20IPTV%2C%20I'd%20like%20to%20contact%20you%20via%20email.%20Can%20you%20provide%20the%20best%20address%3F" target="_blank" rel="noopener noreferrer" class="flex items-start group">
                        <div class="flex-shrink-0">
                          <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-6 w-6 text-blue-600 group-hover:text-blue-700">
                            <rect width="20" height="16" x="2" y="4" rx="2"></rect>
                            <path d="m22 7-8.97 5.7a1.94 1.94 0 0 1-2.06 0L2 7"></path>
                          </svg>
                        </div>
                        <div class="ml-4">
                          <h4 class="text-lg font-medium text-gray-900 group-hover:text-blue-700">Email Us</h4>
                          <p class="mt-1 text-gray-600">{{ $setting->webemail }}</p>
                          <p class="mt-1 text-gray-600">Available 24/7</p>
                        </div>
                      </a>
                      <a href="https://wa.me/{{ $setting->whatsapp }}?text=Hello%20{{ $setting->webname }}%20IPTV%2C%20I'd%20like%20to%20call.%20What's%20the%20best%20number%3F" target="_blank" rel="noopener noreferrer" class="flex items-start group">
                        <div class="flex-shrink-0">
                          <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-6 w-6 text-blue-600 group-hover:text-blue-700">
                            <path d="M22 16.92v3a2 2 0 0 1-2.18 2 19.79 19.79 0 0 1-8.63-3.07 19.5 19.5 0 0 1-6-6 19.79 19.79 0 0 1-3.07-8.67A2 2 0 0 1 4.11 2h3a2 2 0 0 1 2 1.72 12.84 12.84 0 0 0 .7 2.81 2 2 0 0 1-.45 2.11L8.09 9.91a16 16 0 0 0 6 6l1.27-1.27a2 2 0 0 1 2.11-.45 12.84 12.84 0 0 0 2.81.7A2 2 0 0 1 22 16.92z"></path>
                          </svg>
                        </div>
                        <div class="ml-4">
                          <h4 class="text-lg font-medium text-gray-900 group-hover:text-blue-700">Call Us</h4>
                          <p class="mt-1 text-gray-600">{{ $setting->webnumber }}</p>
                          <p class="mt-1 text-gray-600">Available 24/7</p>
                        </div>
                      </a>
                      <a href="https://wa.me/{{ $setting->whatsapp }}?text=Hello%20{{ $setting->webname }}%20IPTV%2C%20I'd%20like%20to%20start%20a%20live%20chat." target="_blank" rel="noopener noreferrer" class="flex items-start group">
                        <div class="flex-shrink-0">
                          <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-6 w-6 text-blue-600 group-hover:text-blue-700">
                            <path d="M21 15a2 2 0 0 1-2 2H7l-4 4V5a2 2 0 0 1 2-2h14a2 2 0 0 1 2 2z"></path>
                          </svg>
                        </div>
                        <div class="ml-4">
                          <h4 class="text-lg font-medium text-gray-900 group-hover:text-blue-700">Live Chat</h4>
                          <p class="mt-1 text-gray-600">Available on our website</p>
                          <p class="mt-1 text-gray-600">Response time: Under 5 minutes</p>
                        </div>
                      </a>
                    </div>
                    <div class="mt-8">
                      <h4 class="text-lg font-medium text-gray-900 mb-4">Our Hours</h4>
                      <p class="text-gray-600">Customer Support: 24/7</p>
                      <p class="text-gray-600">Sales Department: Mon-Fri, 9am-6pm GMT</p>
                      <p class="text-gray-600">Technical Support: 24/7</p>
                    </div>
                  </div>
                </div>
                <div style="opacity: 1; transform: none;">
                  <div class="bg-white p-8 rounded-lg shadow-md border border-gray-200">
                    <h3 class="text-2xl font-bold text-gray-900 mb-6">Send Us a Message (via WhatsApp)</h3>
                    <form class="space-y-6">
                      <div>
                        <label for="name" class="block text-sm font-medium text-gray-700">Your Name</label>
                        <input type="text" id="name" name="name" required="" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm p-3 border" placeholder="John Smith" value="">
                      </div>
                      <div>
                        <label for="email" class="block text-sm font-medium text-gray-700">Email Address</label>
                        <input type="email" id="email" name="email" required="" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm p-3 border" placeholder="john@example.com" value="">
                      </div>
                      <div>
                        <label for="subject" class="block text-sm font-medium text-gray-700">Subject</label>
                        <input type="text" id="subject" name="subject" required="" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm p-3 border" placeholder="Subscription Inquiry" value="">
                      </div>
                      <div>
                        <label for="message" class="block text-sm font-medium text-gray-700">Message</label>
                        <textarea id="message" name="message" required="" rows="4" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm p-3 border" placeholder="Your message here..."></textarea>
                      </div>
                      <div>
                        <button class="inline-flex items-center justify-center rounded-md text-sm font-medium ring-offset-background transition-colors focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-ring focus-visible:ring-offset-2 disabled:pointer-events-none disabled:opacity-50 bg-primary text-primary-foreground hover:bg-primary/90 h-10 px-4 py-2 w-full" type="submit">Send Message via WhatsApp</button>
                      </div>
                    </form>
                    <script>
  document.querySelector("form").addEventListener("submit", function (e) {
    e.preventDefault(); // Stop default form submission

    const name = document.getElementById("name").value.trim();
    const email = document.getElementById("email").value.trim();
    const subject = document.getElementById("subject").value.trim();
    const message = document.getElementById("message").value.trim();

    const whatsappNumber = "{{ $setting->whatsapp }}"; // Correct WhatsApp format for Pakistan

    const greeting = "Hi {{ $setting->webname }}, I have a question. I need help."; // Your custom opening line

    const formattedMessage =
      `${greeting}%0A%0A` + // 2 line breaks after greeting
      `Name: ${name}%0A` +
      `Email: ${email}%0A` +
      `Subject: ${subject}%0A` +
      `Message: ${message}`;

    const whatsappURL = `https://wa.me/${whatsappNumber}?text=${formattedMessage}`;

    window.open(whatsappURL, "_blank"); // Open in new tab
  });
</script>

                  </div>
                </div>
              </div>
            </div>
          </section>
        </main>


         @endsection