@extends('layouts.master')  
@section('meta')  
<title>{{ $category->name }} - BWPExperts.Com</title>
<meta name="description" content="{{ $category->description }}">
<meta name="keywords" content="{{ $category->description }}">
@endsection
@section('content') 
    <div class="breadcumb-wrapper">
      <div class="container">
        <div class="breadcumb-content">
          <h1 class="breadcumb-title">{{ $category->name }}</h1>
          <ul class="breadcumb-menu">
            <li>
              <a href="{{ route('website') }}">Home</a>
            </li>
            <li>{{ $category->name }}</li>
          </ul>
        </div>
      </div>
    </div>
    <script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "BreadcrumbList",
  "itemListElement": [
    {
      "@type": "ListItem",
      "position": 1,
      "name": "Home",
      "item": "{{ route('website') }}"
    },
    {
      "@type": "ListItem",
      "position": 2,
      "name": "{{ $category->name }}",
      "item": "{{ route('website.category', ['slug' => $category->slug]) }}"
    }
  ]
}
</script>
    <section class="th-blog-wrapper space-top space-extra-bottom">
      <div class="container">
        <div class="row">
          <div class="col-xxl-8 col-lg-7">



  @foreach($posts as $post)
            <div class="th-blog blog-single has-post-thumbnail">
              <div class="blog-img th-carousel" data-arrows="true" data-slide-show="1" data-fade="true">
                <a href="{{ route('website.post', ['slug' => $post->slug]) }}">
                  <img src="{{ $post->image }}" alt="{{ $post->title }}">
                </a>               
              </div>
              <div class="blog-content">
                <div class="blog-meta">
                  <a class="author" href="{{ route('website.post', ['slug' => $post->slug]) }}">
                    <img src="@if($post->user->image){{ asset($post->user->image) }} @else {{ asset('website/images/user.png') }} @endif" alt="{{ $post->title }}"> By {{ $post->user->name }} </a>
                  <a href="{{ route('website.post', ['slug' => $post->slug]) }}">
                    <i class="fa-light fa-calendar-days"></i>{{ $post->created_at->format('M d, Y') }} </a>
                  <a href="{{ route('website.post', ['slug' => $post->slug]) }}">
                    <i class="fa-regular fa-comments"></i>Comments (3) </a>
                </div>
                <h2 class="blog-title">
                  <a href="{{ route('website.post', ['slug' => $post->slug]) }}">{{ $post->title }}</a>
                </h2>
                <p class="blog-text">{{ Str::limit(strip_tags($post->description), 170) }}</p>
                <a href="{{ route('website.post', ['slug' => $post->slug]) }}" class="line-btn">Read More</a>
              </div>
            </div>
  @endforeach

            <div class="th-pagination text-center">
              <ul>
               
                <li>
                {{ $posts->links() }}
                </li>
              </ul>
            </div>
          </div>
          <div class="col-xxl-4 col-lg-5">
            <aside class="sidebar-area">
              <div class="widget widget_search">
                <form class="search-form">
                  <input type="text" placeholder="Enter Keyword">
                  <button type="submit">
                    <i class="far fa-search"></i>
                  </button>
                </form>
              </div>
              <div class="widget widget_categories">
                <h3 class="widget_title">Categories</h3>
               <ul>
                 @foreach($categories as $category)
                        <li><a href="{{ route('website.category', ['slug' => $category->slug]) }}">{{ $category->name }}  </a></li>
                        @endforeach
                  
                </ul>
              </div>
              <div class="widget">
                <h3 class="widget_title">Recent Posts</h3>
                <div class="recent-post-wrap">
                   @foreach($posts as $post)
                  <div class="recent-post">
                    <div class="media-img"><a href="{{ route('website.post', ['slug' => $post->slug]) }}"><img src="{{ $post->image }}" alt="{{ $post->title }}"></a></div>
                    <div class="media-body">
                      <h4 class="post-title"><a class="text-inherit" href="{{ route('website.post', ['slug' => $post->slug]) }}">{{ $post->title }}</a></h4>
                      <div class="recent-post-meta"><a href="{{ route('website.post', ['slug' => $post->slug]) }}"><i class="fal fa-calendar-days"></i>{{ $post->created_at->format('M d, Y')}}</a></div>
                    </div>
                  </div>
                   @endforeach
                </div>
              </div>
          
            </aside>
          </div>
        </div>
      </div>
    </section>
   @endsection