<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>IPTV UK Admin Login</title>
    <style>
        body {
            background: #0f0f0f;
            font-family: Arial, sans-serif;
            color: white;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
        }
        .login-container {
            background: #1c1c1c;
            padding: 25px;
            border-radius: 10px;
            width: 350px;
            box-shadow: 0 0 20px rgba(0,0,0,0.7);
        }
        .logo {
            text-align: center;
            margin-bottom: 20px;
        }
        .logo h1 {
            font-size: 2rem;
            color: #fff; /* White text */
            text-shadow: 0 0 10px rgba(255,255,255,0.5);
        }
        form {
            display: flex;
            flex-direction: column;
        }
        input {
            padding: 10px;
            margin: 8px 0;
            border: none;
            border-radius: 5px;
        }
        .error-text {
            color: red;
            font-size: 0.85rem;
            margin-bottom: 5px;
        }
        button.login-btn {
            background: #ff4b4b;
            color: white;
            padding: 10px;
            border: none;
            border-radius: 5px;
            font-weight: bold;
            cursor: pointer;
            margin-top: 10px;
        }
        button.login-btn:hover {
            background: #ff1f1f;
        }
        .purchase-box {
            margin-top: 20px;
            background: #292929;
            padding: 15px;
            border-radius: 8px;
            text-align: center;
        }
        .purchase-btn {
            background: #ffc107;
            color: black;
            padding: 8px 15px;
            text-decoration: none;
            border-radius: 5px;
            font-weight: bold;
            display: inline-block;
            margin-bottom: 8px;
        }
        .purchase-btn:hover {
            background: #e0a800;
        }
        .note {
            font-size: 0.85rem;
            color: #ccc;
        }
    </style>
</head>
<body>
    <div class="login-container">
        <div class="logo">
            <h1>IPTV UK Admin</h1>
        </div>

        <form method="POST" action="{{ route('login') }}">
            @csrf

            <label for="email">Email</label>
            <input id="email" type="email" name="email" value="{{ old('email') }}" required>
            @error('email')
                <span class="error-text">{{ $message }}</span>
            @enderror

            <label for="password">Password</label>
            <input id="password" type="password" name="password" required>
            @error('password')
                <span class="error-text">{{ $message }}</span>
            @enderror

            <button type="submit" class="login-btn">Login</button>
        </form>

        <div class="purchase-box">
            <a href="https://gbiptv.com" target="_blank" class="purchase-btn">Purchase Now</a>
            <p class="note">After purchase, you will receive your login via Email and WhatsApp.</p>
        </div>
    </div>
</body>
</html>
