<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Setting;
use Session;
use Illuminate\Support\Facades\Storage;

class SettingController extends Controller
{
    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Setting  $setting
     * @return \Illuminate\Http\Response
     */
    public function edit(Setting $setting)
    {
        $setting = Setting::first();
        
        return view('admin.setting.edit', compact('setting'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Setting  $setting
     * @return \Illuminate\Http\Response
     */



public function update(Request $request)
{
    $setting = Setting::first();

    if (!$setting) {
        $setting = new Setting();
    }

    $setting->fill($request->only([
        'webname',
        'facebook',
        'twitter',
        'instagram',
        'pinterest',
        'linkedin',
        'webemail',
        'webnumber',
        'whatsapp',
        'webaddress',
        'seotitle',
        'description',
    ]));

    if ($request->hasFile('image')) {
        $image = $request->file('image');
        $image_new_name = time() . '.' . $image->getClientOriginalExtension();
        Storage::disk('custom_public')->putFileAs('setting', $image, $image_new_name);
        $setting->image = 'custom-storage/setting/' . $image_new_name;
    }

    if ($request->hasFile('favicone')) {
        $image = $request->file('favicone');
        $image_new_name = time() . '.' . $image->getClientOriginalExtension();
        Storage::disk('custom_public')->putFileAs('setting', $image, $image_new_name);
        $setting->favicone = 'custom-storage/setting/' . $image_new_name;
    }

    if ($request->hasFile('banner')) {
        $image = $request->file('banner');
        $image_new_name = time() . '.' . $image->getClientOriginalExtension();
        Storage::disk('custom_public')->putFileAs('setting', $image, $image_new_name);
        $setting->banner = 'custom-storage/setting/' . $image_new_name;
    }

     if ($request->hasFile('banner2')) {
        $image = $request->file('banner2');
        $image_new_name = time() . '.' . $image->getClientOriginalExtension();
        Storage::disk('custom_public')->putFileAs('setting', $image, $image_new_name);
        $setting->banner2 = 'custom-storage/setting/' . $image_new_name;
    }

    $setting->save();

    Session::flash('success', 'Setting updated successfully');
    return redirect()->back();
}

}
