  
<?php $__env->startSection('meta'); ?>  
<title>Terms of Service - <?php echo e($setting->webname); ?> IPTV</title>
<meta name="description" content="Read the Terms of Service for <?php echo e($setting->webname); ?> IPTV. Understand your rights and responsibilities when using our UK IPTV service. Policies on usage, subscriptions, and content.">
<meta name="keywords" content="<?php echo e($setting->webname); ?> IPTV terms, IPTV terms of service UK, UK IPTV legal, IPTV user agreement, <?php echo e($setting->webname); ?> IPTV policies">
<meta name="author" content="<?php echo e($setting->webname); ?>">
<!-- Canonical URL -->
<link rel="canonical" href="<?php echo e(url()->current()); ?>">

<!-- Open Graph / Facebook -->
<meta property="og:title" content="Terms of Service - <?php echo e($setting->webname); ?> IPTV">
<meta property="og:description" content="Review the legal terms and user agreement for <?php echo e($setting->webname); ?> IPTV. Learn about subscription rules, content use, and platform policies.">
<meta property="og:url" content="<?php echo e(url()->current()); ?>">
<meta property="og:type" content="article">
<meta property="og:site_name" content="<?php echo e($setting->webname); ?>">

<!-- Twitter Card -->
<meta name="twitter:card" content="summary_large_image">
<meta name="twitter:title" content="Terms of Service | <?php echo e($setting->webname); ?> IPTV">
<meta name="twitter:description" content="Understand your rights and obligations as a <?php echo e($setting->webname); ?> IPTV subscriber. View our terms of use, policies, and service conditions.">
<meta name="twitter:site" content="<?php echo e($setting->webname); ?>"> 
<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "BreadcrumbList",
  "itemListElement": [
    {
      "@type": "ListItem",
      "position": 1,
      "name": "Home",
      "item": "<?php echo e(route('website')); ?>"
    },
    {
      "@type": "ListItem",
      "position": 2,
      "name": "Terms of Service"
    }
  ]
}
</script>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?> 
  <main class="flex-grow">
  <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 py-12" style="opacity: 1; transform: none;">
    <h1 class="text-3xl font-extrabold text-gray-900 sm:text-4xl mb-8">Terms of Service</h1>
    <div class="prose prose-lg max-w-none text-gray-700">
     
      <h2 class="text-2xl font-bold mt-6 mb-3">1. Acceptance of Terms</h2>
      <p>By accessing or using <?php echo e($setting->webname); ?> IPTV ("Service"), you agree to be bound by these Terms of Service ("Terms"). If you disagree with any part of the terms, then you may not access the Service. <?php echo e($setting->webname); ?> IPTV is accessible via the domain <a href="/" target="_blank" rel="noopener noreferrer" class="text-blue-600 hover:underline"><?php echo e($setting->webname); ?></a>. Please also review our <a class="text-blue-600 hover:underline" href="/privacy-policy">Privacy Policy</a> which governs the collection and use of your personal information. </p>
      <h2 class="text-2xl font-bold mt-6 mb-3">2. Description of Service</h2>
      <p><?php echo e($setting->webname); ?> IPTV provides users with access to a collection of television channels and on-demand content streamed over the internet. The Service is intended for personal, non-commercial use only. For more details on acceptable usage, see our <a class="text-blue-600 hover:underline" href="/acceptable-use-policy">Acceptable Use Policy</a>. </p>
      <h2 class="text-2xl font-bold mt-6 mb-3">3. User Responsibilities</h2>
      <p>You are responsible for obtaining and maintaining all equipment and services needed for access to and use of the Service. You are also responsible for ensuring that your use of the Service complies with all applicable local, national, and international laws and regulations. You agree not to use the service for any illegal or unauthorized purpose. You are responsible for the content you access and must ensure you have the legal right to view such content in your jurisdiction. Refer to resources like the <a href="https://www.gov.uk/copyright" target="_blank" rel="noopener noreferrer" class="text-blue-600 hover:underline">UK Government's Copyright Guidance</a> for more information on copyright. </p>
      <h2 class="text-2xl font-bold mt-6 mb-3">4. Subscription and Payment</h2>
      <p>Access to the Service requires a paid subscription. Subscription fees are non-refundable except as expressly stated in our <a class="text-blue-600 hover:underline" href="/refund-policy">Refund Policy</a>. We reserve the right to change subscription fees at any time, with prior notice to you. Details on current plans can be found on our <a class="text-blue-600 hover:underline" href="/pricing">Pricing Page</a>. </p>
      <h2 class="text-2xl font-bold mt-6 mb-3">5. Content and Copyright</h2>
      <p>All content provided through the Service is the property of its respective owners. <?php echo e($setting->webname); ?> IPTV does not host, provide, archive, store, or distribute media of any kind. We act as an index or directory of media posted by other enthusiasts on the internet. Users are responsible for ensuring they have the rights to access any content streamed through the Service. We respect intellectual property rights and expect our users to do the same. For copyright infringement claims, please refer to our <a class="text-blue-600 hover:underline" href="/dmca">DMCA Policy</a>. </p>
      <h2 class="text-2xl font-bold mt-6 mb-3">6. Prohibited Uses</h2>
      <p>You may not use the Service for any unlawful purpose or in any way that interrupts, damages, or impairs the service. Prohibited activities include, but are not limited to: sharing your account credentials, re-streaming or redistributing content, using VPNs or proxies to bypass geographical restrictions if such restrictions are mandated by content providers or law, or attempting to gain unauthorized access to our systems. A full list of prohibited activities can be found in our <a class="text-blue-600 hover:underline" href="/acceptable-use-policy">Acceptable Use Policy</a>. </p>
      <h2 class="text-2xl font-bold mt-6 mb-3">7. Termination</h2>
      <p>We may terminate or suspend your access to the Service immediately, without prior notice or liability, for any reason whatsoever, including without limitation if you breach the Terms. Upon termination, your right to use the Service will immediately cease.</p>
      <h2 class="text-2xl font-bold mt-6 mb-3">8. Disclaimer of Warranties</h2>
      <p>The Service is provided on an "AS IS" and "AS AVAILABLE" basis. <?php echo e($setting->webname); ?> IPTV makes no warranties, expressed or implied, and hereby disclaims and negates all other warranties including, without limitation, implied warranties or conditions of merchantability, fitness for a particular purpose, or non-infringement of intellectual property or other violation of rights.</p>
      <h2 class="text-2xl font-bold mt-6 mb-3">9. Limitation of Liability</h2>
      <p>In no event shall <?php echo e($setting->webname); ?> IPTV or its suppliers be liable for any damages (including, without limitation, damages for loss of data or profit, or due to business interruption) arising out of the use or inability to use the materials on <?php echo e($setting->webname); ?> IPTV's website, even if <?php echo e($setting->webname); ?> IPTV or a <?php echo e($setting->webname); ?> IPTV authorized representative has been notified orally or in writing of the possibility of such damage.</p>
      <h2 class="text-2xl font-bold mt-6 mb-3">10. Governing Law</h2>
      <p>These Terms shall be governed and construed in accordance with the laws of the United Kingdom, without regard to its conflict of law provisions. For information on UK consumer rights, you may visit the <a href="https://www.citizensadvice.org.uk/" target="_blank" rel="noopener noreferrer" class="text-blue-600 hover:underline">Citizens Advice Bureau</a>. </p>
      <h2 class="text-2xl font-bold mt-6 mb-3">11. Changes to Terms</h2>
      <p>We reserve the right, at our sole discretion, to modify or replace these Terms at any time. If a revision is material, we will try to provide at least 30 days' notice prior to any new terms taking effect. What constitutes a material change will be determined at our sole discretion.</p>
      <h2 class="text-2xl font-bold mt-6 mb-3">12. Contact Us</h2>
      <p>If you have any questions about these Terms, please <a class="text-blue-600 hover:underline" href="/#contact">contact us</a> via the contact methods provided on our website. </p>
    </div>
  </div>
</main>
    
   <?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u882570979/domains/gbiptv.com/public_html/resources/views/website/service/terms.blade.php ENDPATH**/ ?>