@extends('layouts.master')  
@section('meta')  
<title>Refund Policy - {{ $setting->webname }} IPTV | UK IPTV Subscription Refunds</title>
<meta name="description" content="Understand the {{ $setting->webname }} IPTV refund policy for UK subscriptions. Learn about eligibility, how to request a refund, and non-refundable circumstances for our IPTV service.">
<meta name="keywords" content="{{ $setting->webname }} IPTV refund, IPTV refund policy UK, UK IPTV money back, cancel IPTV subscription UK, IPTV trial refund">
<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "BreadcrumbList",
  "itemListElement": [
    {
      "@type": "ListItem",
      "position": 1,
      "name": "Home",
      "item": "{{ route('website') }}"
    },
    {
      "@type": "ListItem",
      "position": 2,
      "name": "Graphic Designing Services"
    }
  ]
}
</script>
@endsection
@section('content') 
  <main class="flex-grow">
  <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 py-12" style="opacity: 1; transform: none;">
    <h1 class="text-3xl font-extrabold text-gray-900 sm:text-4xl mb-8">Refund Policy</h1>
    <div class="prose prose-lg max-w-none text-gray-700">
      <h2 class="text-2xl font-bold mt-6 mb-3">1. General Policy</h2>
      <p>At {{ $setting->webname }} IPTV ( <a href="/" target="_blank" rel="noopener noreferrer" class="text-blue-600 hover:underline">{{ $setting->webname }}</a>), we strive to provide our customers with high-quality IPTV services. Due to the nature of digital services and the immediate access provided upon subscription, we generally do not offer refunds once a subscription has been activated and the service has been used. However, we understand that exceptional circumstances may occur. This policy should be read in conjunction with our <a class="text-blue-600 hover:underline" href="/terms-of-service">Terms of Service</a>. </p>
      <h2 class="text-2xl font-bold mt-6 mb-3">2. Free Trial</h2>
      <p>We encourage all potential subscribers to take advantage of our free trial period (if offered) to evaluate the service and ensure it meets their needs before committing to a paid subscription. The trial allows you to test channel availability, quality, and compatibility with your devices. Details about trials can be found on our main page or by <a class="text-blue-600 hover:underline" href="/#contact">contacting support</a>. </p>
      <h2 class="text-2xl font-bold mt-6 mb-3">3. Eligibility for a Refund</h2>
      <p>Refunds may be considered under the following circumstances:</p>
      <ul class="list-disc pl-6">
        <li>
          <strong>Major Service Outage:</strong> If the service is completely unavailable for an extended period (e.g., more than 72 consecutive hours) due to issues on our end, and not related to your internet connection, device, or local network configuration.
        </li>
        <li>
          <strong>Non-Delivery of Service:</strong> If you paid for a subscription but did not receive access to the service, and our support team is unable to resolve the issue within a reasonable timeframe (e.g., 48 hours).
        </li>
        <li>
          <strong>Billing Errors:</strong> If you were charged incorrectly due to a system error (e.g., duplicate charges for the same subscription period).
        </li>
      </ul>
      <h2 class="text-2xl font-bold mt-6 mb-3">4. Non-Refundable Circumstances</h2>
      <p>Refunds will generally not be issued in the following situations:</p>
      <ul class="list-disc pl-6">
        <li>You are dissatisfied with the channel lineup or content available. We recommend checking the channel list or using the free trial before subscribing.</li>
        <li>You experience issues due to your internet speed, ISP throttling, device incompatibility, or incorrect setup on your end. For setup assistance, please see our <a class="text-blue-600 hover:underline" href="/installation-guides">Installation Guides</a>. </li>
        <li>You have violated our <a class="text-blue-600 hover:underline" href="/terms-of-service">Terms of Service</a> or <a class="text-blue-600 hover:underline" href="/acceptable-use-policy">Acceptable Use Policy</a>. </li>
        <li>You forgot to cancel your subscription before the renewal date.</li>
        <li>You change your mind after subscribing and using the service.</li>
        <li>Minor or temporary service interruptions or buffering issues.</li>
        <li>Specific channels being temporarily unavailable, as channel availability can fluctuate due to factors beyond our control.</li>
      </ul>
      <h2 class="text-2xl font-bold mt-6 mb-3">5. How to Request a Refund</h2>
      <p>To request a refund, you must contact our customer support team via the contact methods provided on our website within 7 days of the transaction or the occurrence of the issue. Please provide the following information:</p>
      <ul class="list-disc pl-6">
        <li>Your registered email address and username.</li>
        <li>The date of the transaction and subscription plan.</li>
        <li>A detailed explanation of why you are requesting a refund.</li>
        <li>Any relevant screenshots or evidence supporting your claim.</li>
      </ul>
      <p>Our team will review your request and respond within 5-7 business days. All refund requests are processed on a case-by-case basis.</p>
      <h2 class="text-2xl font-bold mt-6 mb-3">6. Processing Refunds</h2>
      <p>If your refund request is approved, the refund will be processed to your original method of payment within 7-14 business days. Please note that it may take additional time for the refund to appear on your bank or credit card statement, depending on your financial institution. For information on consumer rights regarding refunds in the UK, you can consult <a href="https://www.gov.uk/consumer-protection-rights" target="_blank" rel="noopener noreferrer" class="text-blue-600 hover:underline">GOV.UK Consumer Protection Rights</a>. </p>
      <h2 class="text-2xl font-bold mt-6 mb-3">7. Subscription Cancellations</h2>
      <p>You can cancel your subscription at any time to avoid future charges from our <a class="text-blue-600 hover:underline" href="/pricing">Pricing Page</a> or your account dashboard (if available). Cancelling a subscription does not automatically entitle you to a refund for the current or previous billing periods. You will continue to have access to the service until the end of your current paid subscription period. </p>
      <h2 class="text-2xl font-bold mt-6 mb-3">8. Changes to This Policy</h2>
      <p>{{ $setting->webname }} IPTV reserves the right to modify this Refund Policy at any time. Any changes will be posted on this page with an updated "Last Updated" date. It is your responsibility to review this policy periodically.</p>
      <h2 class="text-2xl font-bold mt-6 mb-3">9. Contact Us</h2>
      <p>If you have any questions about our Refund Policy, please <a class="text-blue-600 hover:underline" href="/#contact">contact us</a>. </p>
    </div>
  </div>
</main>
    
   @endsection