@extends('layouts.master')  
@section('meta')  
<title>{{ ucwords(str_replace('-', ' ', $tag)) }} - {{ $setting->webname }}</title>
<meta name="description" content="{{ ucwords(str_replace('-', ' ', $tag)) }}, @foreach ($datalist as $post){{ $post->seodes }}@endforeach">
<meta name="keywords" content="{{ ucwords(str_replace('-', ' ', $tag)) }}, @foreach ($datalist as $post){{ $post->seodes }}@endforeach">
@endsection
@section('content') 





<style>
  h1 {
  font-size: 1.5rem; /* Very large heading */
  font-weight: bold;
}

h2 {
  font-size: 1.2rem; /* Large heading */
  font-weight: bold;
}

h3 {
  font-size: 1.2rem; /* Medium-large heading */
  font-weight: bold;
}

h4 {
  font-size: 1.2rem; /* Medium heading */
  font-weight: 600;
}

h5 {
  font-size: 1.2rem; /* Small heading */
  font-weight: 600;
}

h6 {
  font-size: 1.2rem; /* Smallest heading */
  font-weight: 600;
}

</style>


   <main class="flex-grow">
  <div style="opacity: 1;">
    <section  class="py-20 bg-gray-50">
  
@foreach ($datalist as $post)
<div class="blog-post" style="font-family: sans-serif; line-height: 1.6; max-width: 1200px; margin: auto; padding: 20px; background: #fff; color: #333;">
  <h1 style="font-size: 2rem; font-weight: bold; margin-bottom: 10px;">{{ ucwords(str_replace('-', ' ', $tag)) }}</h1>


  <img src="{{ asset($post->image) }}" alt="{{ ucwords(str_replace('-', ' ', $tag)) }}" style="width: 100%; margin: 20px 0; border-radius: 8px;">

{!! $post->description !!}

</div>
@endforeach

    </section>
  </div>


 <section id="pricing" class="py-20 bg-gray-50">
      <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center" style="opacity: 1; transform: none;">
          <h2 class="text-3xl font-extrabold text-gray-900 sm:text-4xl">Simple, Transparent Pricing</h2>
          <p class="mt-4 max-w-2xl text-xl text-gray-500 mx-auto">Choose the plan that works best for you. All plans include our 30-Day Money-Back Guarantee.</p>
        </div>
        <div class="my-8 p-4 bg-gradient-to-r from-red-500 to-orange-500 rounded-xl shadow-lg text-white text-center" style="opacity: 1; transform: none;">
          <div class="flex items-center justify-center mb-2">
            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-8 w-8 mr-3 animate-bounce">
              <circle cx="12" cy="13" r="8"></circle>
              <path d="M12 9v4l2 2"></path>
              <path d="M5 3 2 6"></path>
              <path d="m22 6-3-3"></path>
              <path d="M6.38 18.7 4 21"></path>
              <path d="M17.64 18.67 20 21"></path>
            </svg>
            <h3 class="text-2xl font-bold tracking-wider">Limited Time Flash Sale!</h3>
          </div>
          <p class="text-lg mb-3">Prices will return to normal after the timer ends.</p>
          <div class="flex justify-center space-x-4">
            <div class="flex flex-col items-center">
              <span class="text-4xl font-extrabold bg-white/20 px-3 py-1 rounded-lg">02</span>
              <span class="text-xs font-semibold uppercase tracking-wider mt-1">Hours</span>
            </div>
            <div class="text-4xl font-extrabold">:</div>
            <div class="flex flex-col items-center">
              <span class="text-4xl font-extrabold bg-white/20 px-3 py-1 rounded-lg">47</span>
              <span class="text-xs font-semibold uppercase tracking-wider mt-1">Minutes</span>
            </div>
            <div class="text-4xl font-extrabold">:</div>
            <div class="flex flex-col items-center">
              <span class="text-4xl font-extrabold bg-white/20 px-3 py-1 rounded-lg">20</span>
              <span class="text-xs font-semibold uppercase tracking-wider mt-1">Seconds</span>
            </div>
          </div>
        </div>
        <div class="mt-16 grid gap-8 lg:grid-cols-4 md:grid-cols-2 sm:grid-cols-1">
          <div class="pricing-card relative rounded-xl shadow-lg overflow-hidden flex flex-col transition-all duration-300 ease-in-out border border-gray-200 hover:shadow-blue-100" style="opacity: 1; transform: none;">
            <div class="p-8 bg-white">
              <h3 class="text-2xl font-bold text-gray-900">Monthly</h3>
              <div class="mt-4 flex items-baseline text-gray-900">
                <span class="text-5xl font-extrabold tracking-tight">£12.99</span>
                <span class="ml-1 text-xl font-semibold">per month</span>
              </div>
              <p class="mt-5 text-base text-gray-500">Perfect for trying out our service</p>
            </div>
            <div class="pt-6 pb-8 px-6 bg-white flex-grow flex flex-col justify-between">
              <ul role="list" class="space-y-3">
                <li class="flex items-start">
                  <div class="flex-shrink-0">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-5 w-5 text-green-500" aria-hidden="true">
                      <polyline points="20 6 9 17 4 12"></polyline>
                    </svg>
                  </div>
                  <p class="ml-3 text-sm text-gray-700">28,000+ Live TV Channels</p>
                </li>
                <li class="flex items-start">
                  <div class="flex-shrink-0">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-5 w-5 text-green-500" aria-hidden="true">
                      <polyline points="20 6 9 17 4 12"></polyline>
                    </svg>
                  </div>
                  <p class="ml-3 text-sm text-gray-700">Full HD &amp; 4K Quality</p>
                </li>
                <li class="flex items-start">
                  <div class="flex-shrink-0">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-5 w-5 text-green-500" aria-hidden="true">
                      <polyline points="20 6 9 17 4 12"></polyline>
                    </svg>
                  </div>
                  <p class="ml-3 text-sm text-gray-700">7-Day Catch Up</p>
                </li>
                <li class="flex items-start">
                  <div class="flex-shrink-0">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-5 w-5 text-green-500" aria-hidden="true">
                      <polyline points="20 6 9 17 4 12"></polyline>
                    </svg>
                  </div>
                  <p class="ml-3 text-sm text-gray-700">VOD Library (Movies &amp; Series)</p>
                </li>
                <li class="flex items-start">
                  <div class="flex-shrink-0">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-5 w-5 text-green-500" aria-hidden="true">
                      <polyline points="20 6 9 17 4 12"></polyline>
                    </svg>
                  </div>
                  <p class="ml-3 text-sm text-gray-700">Use on 1 Device</p>
                </li>
                <li class="flex items-start">
                  <div class="flex-shrink-0">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-5 w-5 text-green-500" aria-hidden="true">
                      <polyline points="20 6 9 17 4 12"></polyline>
                    </svg>
                  </div>
                  <p class="ml-3 text-sm text-gray-700">24/7 Support via WhatsApp</p>
                </li>
              </ul>
              <div class="mt-8">
                <a href="https://wa.me/{{ $setting->whatsapp }}?text=Hello%20{{ $setting->webname }}%20IPTV%2C%20I'm%20interested%20in%20the%20Monthly%20plan." target="_blank" rel="noopener noreferrer" class="inline-flex items-center justify-center rounded-md text-sm font-medium ring-offset-background transition-colors focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-ring focus-visible:ring-offset-2 disabled:pointer-events-none disabled:opacity-50 h-10 px-4 py-2 w-full bg-blue-600 hover:bg-blue-700 text-white">Get Started</a>
              </div>
            </div>
          </div>
          <div class="pricing-card relative rounded-xl shadow-lg overflow-hidden flex flex-col transition-all duration-300 ease-in-out border border-gray-200 hover:shadow-blue-100" style="opacity: 1; transform: none;">
            <div class="p-8 bg-white">
              <h3 class="text-2xl font-bold text-gray-900">3 Months</h3>
              <div class="mt-4 flex items-baseline text-gray-900">
                <span class="text-5xl font-extrabold tracking-tight">£29.99</span>
                <span class="ml-1 text-xl font-semibold">every 3 months</span>
              </div>
              <p class="mt-5 text-base text-gray-500">Great value for short term</p>
            </div>
            <div class="pt-6 pb-8 px-6 bg-white flex-grow flex flex-col justify-between">
              <ul role="list" class="space-y-3">
                <li class="flex items-start">
                  <div class="flex-shrink-0">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-5 w-5 text-green-500" aria-hidden="true">
                      <polyline points="20 6 9 17 4 12"></polyline>
                    </svg>
                  </div>
                  <p class="ml-3 text-sm text-gray-700">28,000+ Live TV Channels</p>
                </li>
                <li class="flex items-start">
                  <div class="flex-shrink-0">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-5 w-5 text-green-500" aria-hidden="true">
                      <polyline points="20 6 9 17 4 12"></polyline>
                    </svg>
                  </div>
                  <p class="ml-3 text-sm text-gray-700">Full HD &amp; 4K Quality</p>
                </li>
                <li class="flex items-start">
                  <div class="flex-shrink-0">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-5 w-5 text-green-500" aria-hidden="true">
                      <polyline points="20 6 9 17 4 12"></polyline>
                    </svg>
                  </div>
                  <p class="ml-3 text-sm text-gray-700">7-Day Catch Up</p>
                </li>
                <li class="flex items-start">
                  <div class="flex-shrink-0">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-5 w-5 text-green-500" aria-hidden="true">
                      <polyline points="20 6 9 17 4 12"></polyline>
                    </svg>
                  </div>
                  <p class="ml-3 text-sm text-gray-700">VOD Library (Movies &amp; Series)</p>
                </li>
                <li class="flex items-start">
                  <div class="flex-shrink-0">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-5 w-5 text-green-500" aria-hidden="true">
                      <polyline points="20 6 9 17 4 12"></polyline>
                    </svg>
                  </div>
                  <p class="ml-3 text-sm text-gray-700">Use on 2 Devices Simultaneously</p>
                </li>
                <li class="flex items-start">
                  <div class="flex-shrink-0">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-5 w-5 text-green-500" aria-hidden="true">
                      <polyline points="20 6 9 17 4 12"></polyline>
                    </svg>
                  </div>
                  <p class="ml-3 text-sm text-gray-700">24/7 Support via WhatsApp</p>
                </li>
                <li class="flex items-start">
                  <div class="flex-shrink-0">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-5 w-5 text-green-500" aria-hidden="true">
                      <polyline points="20 6 9 17 4 12"></polyline>
                    </svg>
                  </div>
                  <p class="ml-3 text-sm text-gray-700">Save over 20% vs Monthly</p>
                </li>
              </ul>
              <div class="mt-8">
                <a href="https://wa.me/{{ $setting->whatsapp }}?text=Hello%20{{ $setting->webname }}%20IPTV%2C%20I'm%20interested%20in%20the%203%20Months%20plan." target="_blank" rel="noopener noreferrer" class="inline-flex items-center justify-center rounded-md text-sm font-medium ring-offset-background transition-colors focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-ring focus-visible:ring-offset-2 disabled:pointer-events-none disabled:opacity-50 h-10 px-4 py-2 w-full bg-blue-600 hover:bg-blue-700 text-white">Get Started</a>
              </div>
            </div>
          </div>
          <div class="pricing-card relative rounded-xl shadow-lg overflow-hidden flex flex-col transition-all duration-300 ease-in-out border-4 border-orange-500 transform scale-105 ring-4 ring-orange-500 ring-opacity-50" style="opacity: 1; transform: none;">
            <div class="absolute top-0 -right-1 transform translate-x-0 -translate-y-0">
              <div class="absolute top-0 right-0 h-16 w-16">
                <div class="absolute transform rotate-45 bg-gradient-to-r from-orange-500 to-red-500 text-center text-white font-semibold py-1 right-[-34px] top-[32px] w-[170px] shadow-md">Hot Sale!</div>
              </div>
            </div>
            <div class="p-8 bg-orange-50">
              <h3 class="text-2xl font-bold text-gray-900">Annual</h3>
              <div class="mt-4 flex items-baseline text-gray-900">
                <span class="text-5xl font-extrabold tracking-tight">£45</span>
                <span class="ml-1 text-xl font-semibold">per year</span>
              </div>
              <p class="mt-5 text-base text-gray-500">Best value for loyal customers</p>
              <div class="mt-4 p-3 bg-red-100 border-l-4 border-red-500 rounded-r-lg">
                <p class="font-bold text-red-800">12 Months + 2 Months FREE</p>
                <div class="flex items-center mt-1 text-sm text-red-600">
                  <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-4 w-4 mr-1.5">
                    <circle cx="12" cy="12" r="10"></circle>
                    <polyline points="12 6 12 12 16 14"></polyline>
                  </svg>
                  <span>Offer valid for next 5 hours!</span>
                </div>
              </div>
            </div>
            <div class="pt-6 pb-8 px-6 bg-white flex-grow flex flex-col justify-between">
              <ul role="list" class="space-y-3">
                <li class="flex items-start">
                  <div class="flex-shrink-0">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-5 w-5 text-green-500" aria-hidden="true">
                      <polyline points="20 6 9 17 4 12"></polyline>
                    </svg>
                  </div>
                  <p class="ml-3 text-sm text-gray-700">28,000+ Live TV Channels</p>
                </li>
                <li class="flex items-start">
                  <div class="flex-shrink-0">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-5 w-5 text-green-500" aria-hidden="true">
                      <polyline points="20 6 9 17 4 12"></polyline>
                    </svg>
                  </div>
                  <p class="ml-3 text-sm text-gray-700">Full HD &amp; 4K Quality</p>
                </li>
                <li class="flex items-start">
                  <div class="flex-shrink-0">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-5 w-5 text-green-500" aria-hidden="true">
                      <polyline points="20 6 9 17 4 12"></polyline>
                    </svg>
                  </div>
                  <p class="ml-3 text-sm text-gray-700">7-Day Catch Up &amp; Recording</p>
                </li>
                <li class="flex items-start">
                  <div class="flex-shrink-0">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-5 w-5 text-green-500" aria-hidden="true">
                      <polyline points="20 6 9 17 4 12"></polyline>
                    </svg>
                  </div>
                  <p class="ml-3 text-sm text-gray-700">Premium VOD Library (Updated Daily)</p>
                </li>
                <li class="flex items-start">
                  <div class="flex-shrink-0">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-5 w-5 text-green-500" aria-hidden="true">
                      <polyline points="20 6 9 17 4 12"></polyline>
                    </svg>
                  </div>
                  <p class="ml-3 text-sm text-gray-700">Use on 3 Devices Simultaneously</p>
                </li>
                <li class="flex items-start">
                  <div class="flex-shrink-0">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-5 w-5 text-green-500" aria-hidden="true">
                      <polyline points="20 6 9 17 4 12"></polyline>
                    </svg>
                  </div>
                  <p class="ml-3 text-sm text-gray-700">VIP 24/7 Support</p>
                </li>
                <li class="flex items-start">
                  <div class="flex-shrink-0">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-5 w-5 text-green-500" aria-hidden="true">
                      <polyline points="20 6 9 17 4 12"></polyline>
                    </svg>
                  </div>
                  <p class="ml-3 text-sm text-gray-700">Save over 60% vs Monthly</p>
                </li>
                <li class="flex items-start">
                  <div class="flex-shrink-0">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-5 w-5 text-green-500" aria-hidden="true">
                      <polyline points="20 6 9 17 4 12"></polyline>
                    </svg>
                  </div>
                  <p class="ml-3 text-sm text-gray-700">Free Setup Assistance</p>
                </li>
              </ul>
              <div class="mt-8">
                <a href="https://wa.me/{{ $setting->whatsapp }}?text=Hello%20{{ $setting->webname }}%20IPTV%2C%20I'm%20interested%20in%20the%20Annual%20plan." target="_blank" rel="noopener noreferrer" class="inline-flex items-center justify-center rounded-md text-sm font-medium ring-offset-background transition-colors focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-ring focus-visible:ring-offset-2 disabled:pointer-events-none disabled:opacity-50 bg-primary hover:bg-primary/90 h-10 px-4 py-2 w-full bg-gradient-to-r from-orange-500 to-red-600 hover:from-orange-600 hover:to-red-700 text-white shadow-lg hover:shadow-xl">Get Started</a>
              </div>
            </div>
          </div>
          <div class="pricing-card relative rounded-xl shadow-lg overflow-hidden flex flex-col transition-all duration-300 ease-in-out border border-gray-200 hover:shadow-blue-100" style="opacity: 1; transform: none;">
            <div class="p-8 bg-white">
              <h3 class="text-2xl font-bold text-gray-900">Quarterly</h3>
              <div class="mt-4 flex items-baseline text-gray-900">
                <span class="text-5xl font-extrabold tracking-tight">£34.99</span>
                <span class="ml-1 text-xl font-semibold">per quarter</span>
              </div>
              <p class="mt-5 text-base text-gray-500">Popular choice for commitment</p>
            </div>
            <div class="pt-6 pb-8 px-6 bg-white flex-grow flex flex-col justify-between">
              <ul role="list" class="space-y-3">
                <li class="flex items-start">
                  <div class="flex-shrink-0">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-5 w-5 text-green-500" aria-hidden="true">
                      <polyline points="20 6 9 17 4 12"></polyline>
                    </svg>
                  </div>
                  <p class="ml-3 text-sm text-gray-700">28,000+ Live TV Channels</p>
                </li>
                <li class="flex items-start">
                  <div class="flex-shrink-0">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-5 w-5 text-green-500" aria-hidden="true">
                      <polyline points="20 6 9 17 4 12"></polyline>
                    </svg>
                  </div>
                  <p class="ml-3 text-sm text-gray-700">Full HD &amp; 4K Quality</p>
                </li>
                <li class="flex items-start">
                  <div class="flex-shrink-0">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-5 w-5 text-green-500" aria-hidden="true">
                      <polyline points="20 6 9 17 4 12"></polyline>
                    </svg>
                  </div>
                  <p class="ml-3 text-sm text-gray-700">7-Day Catch Up &amp; Recording</p>
                </li>
                <li class="flex items-start">
                  <div class="flex-shrink-0">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-5 w-5 text-green-500" aria-hidden="true">
                      <polyline points="20 6 9 17 4 12"></polyline>
                    </svg>
                  </div>
                  <p class="ml-3 text-sm text-gray-700">Extensive VOD Library</p>
                </li>
                <li class="flex items-start">
                  <div class="flex-shrink-0">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-5 w-5 text-green-500" aria-hidden="true">
                      <polyline points="20 6 9 17 4 12"></polyline>
                    </svg>
                  </div>
                  <p class="ml-3 text-sm text-gray-700">Use on 2 Devices Simultaneously</p>
                </li>
                <li class="flex items-start">
                  <div class="flex-shrink-0">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-5 w-5 text-green-500" aria-hidden="true">
                      <polyline points="20 6 9 17 4 12"></polyline>
                    </svg>
                  </div>
                  <p class="ml-3 text-sm text-gray-700">Priority 24/7 Support</p>
                </li>
                <li class="flex items-start">
                  <div class="flex-shrink-0">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-5 w-5 text-green-500" aria-hidden="true">
                      <polyline points="20 6 9 17 4 12"></polyline>
                    </svg>
                  </div>
                  <p class="ml-3 text-sm text-gray-700">Early access to new features</p>
                </li>
              </ul>
              <div class="mt-8">
                <a href="https://wa.me/{{ $setting->whatsapp }}?text=Hello%20{{ $setting->webname }}%20IPTV%2C%20I'm%20interested%20in%20the%20Quarterly%20plan." target="_blank" rel="noopener noreferrer" class="inline-flex items-center justify-center rounded-md text-sm font-medium ring-offset-background transition-colors focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-ring focus-visible:ring-offset-2 disabled:pointer-events-none disabled:opacity-50 h-10 px-4 py-2 w-full bg-blue-600 hover:bg-blue-700 text-white">Get Started</a>
              </div>
            </div>
          </div>
        </div>
        <div class="mt-12 py-8 bg-gray-100 rounded-lg">
          <div class="text-center" style="opacity: 1; transform: none;">
            <div class="flex items-center justify-center mb-4">
              <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-8 w-8 text-green-500 mr-2">
                <path d="M12 22s8-4 8-10V5l-8-3-8 3v7c0 6 8 10 8 10"></path>
                <path d="m9 12 2 2 4-4"></path>
              </svg>
              <h4 class="text-xl font-semibold text-gray-800">Secure Payment Options</h4>
            </div>
            <p class="text-gray-600 mb-6">We accept various secure payment methods for your convenience.</p>
            <div class="flex justify-center items-center space-x-6 sm:space-x-12">
              <div class="flex flex-col items-center text-center" style="opacity: 1; transform: none;">
                <div class="p-3 bg-white rounded-full shadow-md mb-2">
                  <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-10 w-10 text-blue-600">
                    <rect width="20" height="14" x="2" y="5" rx="2"></rect>
                    <line x1="2" x2="22" y1="10" y2="10"></line>
                  </svg>
                </div>
                <span class="text-sm font-medium text-gray-700">Card Payments</span>
              </div>
              <div class="flex flex-col items-center text-center" style="opacity: 1; transform: none;">
                <div class="p-3 bg-white rounded-full shadow-md mb-2">
                  <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-10 w-10 text-blue-500">
                    <polyline points="22 7 13.5 15.5 8.5 10.5 2 17"></polyline>
                    <polyline points="16 7 22 7 22 13"></polyline>
                  </svg>
                </div>
                <span class="text-sm font-medium text-gray-700">PayPal</span>
              </div>
              <div class="flex flex-col items-center text-center" style="opacity: 1; transform: none;">
                <div class="p-3 bg-white rounded-full shadow-md mb-2">
                  <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-10 w-10 text-green-600">
                    <rect width="20" height="12" x="2" y="6" rx="2"></rect>
                    <circle cx="12" cy="12" r="2"></circle>
                    <path d="M6 12h.01M18 12h.01"></path>
                  </svg>
                </div>
                <span class="text-sm font-medium text-gray-700">Bank Transfer</span>
              </div>
            </div>
          </div>
        </div>
        <div class="mt-16 bg-gradient-to-r from-blue-600 to-indigo-700 rounded-lg shadow-xl p-8 md:p-12 border border-blue-700 text-white" style="opacity: 1; transform: none;">
          <div class="text-center">
            <h3 class="text-3xl font-extrabold sm:text-4xl">Ready for a Longer Test Drive?</h3>
            <p class="mt-4 text-lg sm:text-xl text-blue-100 max-w-3xl mx-auto">Experience the full power of {{ $setting->webname }} IPTV with our exclusive 24-hour free trial. Access all 28,000+ channels, VOD, and premium features with no obligation. It's the perfect way to see why we're the UK's favourite IPTV provider!</p>
            <div class="mt-8">
              <a class="inline-flex items-center justify-center ring-offset-background focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-ring focus-visible:ring-offset-2 disabled:pointer-events-none disabled:opacity-50 h-11 rounded-md bg-white text-blue-600 hover:bg-gray-100 shadow-md hover:shadow-lg transform hover:scale-105 transition-all duration-300 px-10 py-3 text-lg font-semibold" href="/trial">Request 24hr Trial Now</a>
            </div>
          </div>
        </div>
      </div>
    </section>

       <section id="contact" class="py-20 bg-white">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
              <div class="text-center mb-16" style="opacity: 1; transform: none;">
                <h2 class="text-3xl font-extrabold text-gray-900 sm:text-4xl">Contact Us</h2>
                <p class="mt-4 max-w-2xl text-xl text-gray-500 mx-auto">Have questions or need assistance? We're here to help!</p>
              </div>
              <div class="grid grid-cols-1 lg:grid-cols-2 gap-12">
                <div style="opacity: 1; transform: none;">
                  <div class="bg-gray-50 p-8 rounded-lg shadow-md border border-gray-200 h-full">
                    <h3 class="text-2xl font-bold text-gray-900 mb-6">Get in Touch</h3>
                    <div class="space-y-6">
                      <a href="https://wa.me/{{ $setting->whatsapp }}?text=Hello%20{{ $setting->webname }}%20IPTV%2C%20I'd%20like%20to%20contact%20you%20via%20email.%20Can%20you%20provide%20the%20best%20address%3F" target="_blank" rel="noopener noreferrer" class="flex items-start group">
                        <div class="flex-shrink-0">
                          <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-6 w-6 text-blue-600 group-hover:text-blue-700">
                            <rect width="20" height="16" x="2" y="4" rx="2"></rect>
                            <path d="m22 7-8.97 5.7a1.94 1.94 0 0 1-2.06 0L2 7"></path>
                          </svg>
                        </div>
                        <div class="ml-4">
                          <h4 class="text-lg font-medium text-gray-900 group-hover:text-blue-700">Email Us</h4>
                          <p class="mt-1 text-gray-600">{{ $setting->webemail }}</p>
                          <p class="mt-1 text-gray-600">Available 24/7</p>
                        </div>
                      </a>
                      <a href="https://wa.me/{{ $setting->whatsapp }}?text=Hello%20{{ $setting->webname }}%20IPTV%2C%20I'd%20like%20to%20call.%20What's%20the%20best%20number%3F" target="_blank" rel="noopener noreferrer" class="flex items-start group">
                        <div class="flex-shrink-0">
                          <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-6 w-6 text-blue-600 group-hover:text-blue-700">
                            <path d="M22 16.92v3a2 2 0 0 1-2.18 2 19.79 19.79 0 0 1-8.63-3.07 19.5 19.5 0 0 1-6-6 19.79 19.79 0 0 1-3.07-8.67A2 2 0 0 1 4.11 2h3a2 2 0 0 1 2 1.72 12.84 12.84 0 0 0 .7 2.81 2 2 0 0 1-.45 2.11L8.09 9.91a16 16 0 0 0 6 6l1.27-1.27a2 2 0 0 1 2.11-.45 12.84 12.84 0 0 0 2.81.7A2 2 0 0 1 22 16.92z"></path>
                          </svg>
                        </div>
                        <div class="ml-4">
                          <h4 class="text-lg font-medium text-gray-900 group-hover:text-blue-700">Call Us</h4>
                          <p class="mt-1 text-gray-600">{{ $setting->webnumber }}</p>
                          <p class="mt-1 text-gray-600">Available 24/7</p>
                        </div>
                      </a>
                      <a href="https://wa.me/{{ $setting->whatsapp }}?text=Hello%20{{ $setting->webname }}%20IPTV%2C%20I'd%20like%20to%20start%20a%20live%20chat." target="_blank" rel="noopener noreferrer" class="flex items-start group">
                        <div class="flex-shrink-0">
                          <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-6 w-6 text-blue-600 group-hover:text-blue-700">
                            <path d="M21 15a2 2 0 0 1-2 2H7l-4 4V5a2 2 0 0 1 2-2h14a2 2 0 0 1 2 2z"></path>
                          </svg>
                        </div>
                        <div class="ml-4">
                          <h4 class="text-lg font-medium text-gray-900 group-hover:text-blue-700">Live Chat</h4>
                          <p class="mt-1 text-gray-600">Available on our website</p>
                          <p class="mt-1 text-gray-600">Response time: Under 5 minutes</p>
                        </div>
                      </a>
                    </div>
                    <div class="mt-8">
                      <h4 class="text-lg font-medium text-gray-900 mb-4">Our Hours</h4>
                      <p class="text-gray-600">Customer Support: 24/7</p>
                      <p class="text-gray-600">Sales Department: Mon-Fri, 9am-6pm GMT</p>
                      <p class="text-gray-600">Technical Support: 24/7</p>
                    </div>
                  </div>
                </div>
                <div style="opacity: 1; transform: none;">
                  <div class="bg-white p-8 rounded-lg shadow-md border border-gray-200">
                    <h3 class="text-2xl font-bold text-gray-900 mb-6">Send Us a Message (via WhatsApp)</h3>
                    <form class="space-y-6">
                      <div>
                        <label for="name" class="block text-sm font-medium text-gray-700">Your Name</label>
                        <input type="text" id="name" name="name" required="" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm p-3 border" placeholder="John Smith" value="">
                      </div>
                      <div>
                        <label for="email" class="block text-sm font-medium text-gray-700">Email Address</label>
                        <input type="email" id="email" name="email" required="" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm p-3 border" placeholder="john@example.com" value="">
                      </div>
                      <div>
                        <label for="subject" class="block text-sm font-medium text-gray-700">Subject</label>
                        <input type="text" id="subject" name="subject" required="" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm p-3 border" placeholder="Subscription Inquiry" value="">
                      </div>
                      <div>
                        <label for="message" class="block text-sm font-medium text-gray-700">Message</label>
                        <textarea id="message" name="message" required="" rows="4" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm p-3 border" placeholder="Your message here..."></textarea>
                      </div>
                      <div>
                        <button class="inline-flex items-center justify-center rounded-md text-sm font-medium ring-offset-background transition-colors focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-ring focus-visible:ring-offset-2 disabled:pointer-events-none disabled:opacity-50 bg-primary text-primary-foreground hover:bg-primary/90 h-10 px-4 py-2 w-full" type="submit">Send Message via WhatsApp</button>
                      </div>
                    </form>
                    <script>
  document.querySelector("form").addEventListener("submit", function (e) {
    e.preventDefault(); // Stop default form submission

    const name = document.getElementById("name").value.trim();
    const email = document.getElementById("email").value.trim();
    const subject = document.getElementById("subject").value.trim();
    const message = document.getElementById("message").value.trim();

    const whatsappNumber = "{{ $setting->whatsapp }}"; // Correct WhatsApp format for Pakistan

    const greeting = "Hi {{ $setting->webname }}, I have a question. I need help."; // Your custom opening line

    const formattedMessage =
      `${greeting}%0A%0A` + // 2 line breaks after greeting
      `Name: ${name}%0A` +
      `Email: ${email}%0A` +
      `Subject: ${subject}%0A` +
      `Message: ${message}`;

    const whatsappURL = `https://wa.me/${whatsappNumber}?text=${formattedMessage}`;

    window.open(whatsappURL, "_blank"); // Open in new tab
  });
</script>

                  </div>
                </div>
              </div>
            </div>
          </section>



  
</main>
    
   @endsection