@extends('layouts.master')  
@section('meta')  
<title>Contact Us - BWPExperts.Com</title>
<meta name="description" content="Contact Us - BWPExperts.Com">
<meta name="keywords" content="Contact Us - BWPExperts.Com">
@endsection
@section('content') 
    <div class="breadcumb-wrapper">
      <div class="container">
        <div class="breadcumb-content">
          <h1 class="breadcumb-title">Contact Us</h1>
          <ul class="breadcumb-menu">
            <li><a href="{{ route('website') }}">Home</a></li>
            <li>Contact Us</li>
          </ul>
        </div>
      </div>
    </div>
    <script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "BreadcrumbList",
  "itemListElement": [
    {
      "@type": "ListItem",
      "position": 1,
      "name": "Home",
      "item": "{{ route('website') }}"
    },
    {
      "@type": "ListItem",
      "position": 2,
      "name": "Contact Us",
      "item": "{{ route('website.contact') }}"
    }
  ]
}
</script>
    <div class="space">
      <div class="container">
        <div class="row gy-4">
          <div class="col-xl-4 col-md-6">
            <div class="contact-info">
              <div class="contact-info_icon"><i class="fas fa-location-dot"></i></div>
              <div class="media-body">
                <h4 class="box-title">Our Office Address</h4><span class="contact-info_text">{{ $setting->webaddress }},<br>Pakistan</span>
              </div>
            </div>
          </div>
          <div class="col-xl-4 col-md-6">
            <div class="contact-info">
              <div class="contact-info_icon"><i class="fas fa-phone"></i></div>
              <div class="media-body">
                <h4 class="box-title">Call Us Anytime</h4><span class="contact-info_text"><a href="tel:{{ $setting->webnumber }}">{{ $setting->webnumber }}</a></span>
              </div>
            </div>
          </div>
          <div class="col-xl-4 col-md-6">
            <div class="contact-info">
              <div class="contact-info_icon"><i class="fas fa-envelope"></i></div>
              <div class="media-body">
                <h4 class="box-title">Send An Email</h4><span class="contact-info_text"><a href="mailto:{{ $setting->webemail }}">{{ $setting->webemail }}</a></span>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
    <div class="bg-smoke space" data-bg-src="{{ asset('storage') }}/img/bg/contact_bg_1.webp" id="contact-sec">
      <div class="container">
        <div class="row">
          <div class="col-xl-8">
            <div class="title-area mb-35 text-xl-start text-center"><span class="sub-title">
                <div class="icon-masking me-2"><span class="mask-icon" data-mask-src="{{ asset('storage') }}/img/theme-img/title_shape_2.svg"></span><img src="{{ asset('storage') }}/img/theme-img/title_shape_2.svg" alt="shape"></div>contact with us!
              </span>
              <h2 class="sec-title">Have Any Questions?</h2>
              <p class="sec-text">Request A Free Consultation
</p>
            </div>
            <form action="{{ route('website.contact.send') }}" method="post" class="contact-form ajax-contact" >
    @csrf
    @include('includes.errors')   
    <div class="row">
        <div class="form-group col-md-6">
            <input type="text" class="form-control" name="name" id="name" placeholder="Your Name">
            <i class="fal fa-user"></i>
        </div>
        <div class="form-group col-md-6">
            <input type="email" class="form-control" name="email" id="email" placeholder="Email Address">
            <i class="fal fa-envelope"></i>
        </div>
        <div class="form-group col-md-6">
            <select name="subject" id="subject" class="form-select">
                <option value="" disabled selected hidden>Select Subject</option>
                <option value="Web Development">Web Development</option>
                <option value="Shopify Developer">Shopify Developer</option>
                <option value="Social Media Marketing">Social Media Marketing</option>
                <option value="Digital Marketing">Digital Marketing</option>
                <option value="Graphic Designing">Graphic Designing</option>
                <option value="SEO">SEO</option>
                <option value="SEO Article Writing">SEO Article Writing</option>
                <option value="Lead Generation">Lead Generation</option>
                <option value="Data Entry">Data Entry</option>
                <option value="Affiliate Marketing">Affiliate Marketing</option>
            </select>
            <i class="fal fa-chevron-down"></i>
        </div>
        <div class="form-group col-md-6">
            <input type="tel" class="form-control" name="number" id="number" placeholder="Phone Number">
            <i class="fal fa-phone"></i>
        </div>
        <div class="form-group col-12">
            <textarea name="message" id="message" cols="30" rows="3" class="form-control" placeholder="Your Message"></textarea>
            <i class="fal fa-comment"></i>
        </div>
        <div class="form-btn text-xl-start text-center col-12">
            <button type="submit" class="th-btn">Send Message<i class="fa-regular fa-arrow-right ms-2"></i></button>
        </div>

    </div>
   
</form>
<div id="success-alert" class="alert alert-success d-none" role="alert" style="padding-top: 20px">
  Your Message Was Successfully Delivered! Our Staff Will Get In Touch With You As Soon As They Can.
</div>



          </div>
        </div>
      </div>
    </div>
    <div class="map-sec"><iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3476.0942858620842!2d71.71711187606635!3d29.396797748964353!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x393b9103d26ab3ff%3A0xf9e4417cc1046f98!2sHassan%20town%20Bahawalpur!5e0!3m2!1sen!2s!4v1713856376329!5m2!1sen!2s" allowfullscreen="" loading="lazy"></iframe></div>
       @endsection