@extends('layouts.master')  
@section('meta')  
<title>IPTV Sitemap - {{ $setting->webname }} IPTV | Test Our Premium IPTV Service</title>
<meta name="description" content="IPTV Sitemap- Get a 24-hour free trial of {{ $setting->webname }} IPTV. Experience our full range of 28,000+ HD channels, live sports, movies, and VOD. No commitment, just pure entertainment.">
<meta name="keywords" content="IPTV free trial UK, {{ $setting->webname }} IPTV trial, 24 hour IPTV trial, test IPTV service UK, free UK TV trial, live sports trial, premium IPTV trial">
<meta name="author" content="{{ $setting->webname }}">

<!-- Canonical URL -->
<link rel="canonical" href="{{ url()->current() }}">

<!-- Open Graph / Facebook -->
<meta property="og:title" content="IPTV Sitemap - {{ $setting->webname }}">
<meta property="og:description" content="Enjoy 24 hours of free IPTV access. Explore {{ $setting->webname }} 28,000+ HD channels, sports, movies & more — no credit card required.">
<meta property="og:url" content="{{ url()->current() }}">
<meta property="og:type" content="website">
<meta property="og:site_name" content="{{ $setting->webname }}">

<!-- Twitter Card -->
<meta name="twitter:card" content="summary_large_image">
<meta name="twitter:title" content="IPTV Sitemap | {{ $setting->webname }}">
<meta name="twitter:description" content="Test our premium IPTV service with a no-obligation 24hr free trial. Access 28,000+ HD channels & VOD instantly.">
<meta name="twitter:site" content="{{ $setting->webname }}"> 


<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "BreadcrumbList",
  "itemListElement": [
    {
      "@type": "ListItem",
      "position": 1,
      "name": "Home",
      "item": "{{ route('website') }}"
    },
    {
      "@type": "ListItem",
      "position": 2,
      "name": "Blog"
    }
  ]
}
</script>
@endsection
@section('content') 
<main class="flex-grow">
<div class="bg-gradient-to-br from-gray-100 to-slate-200 text-gray-800 flex flex-col items-center justify-center py-12 px-4 sm:px-6 lg:px-8">

  <style>
    .blog-container {
      display: flex;
      flex-wrap: wrap;
      justify-content: center;
      max-width: 1100px;
      margin: auto;
      gap: 20px;
    }

    .blog-card-link {
      width: calc(50% - 10px);
      text-decoration: none;
      display: none; /* Hidden by default, JS will reveal */
    }

    .blog-card-link.show {
      display: block;
    }

    .blog-card {
      background-color: #ff6c00;
      color: white;
      font-weight: bold;
      padding: 30px 20px;
      text-align: center;
      border-radius: 6px;
      box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
      box-sizing: border-box;
      transition: transform 0.3s ease;
    }

    .blog-card:hover {
      transform: translateY(-5px);
    }

    .load-more {
      margin-top: 30px;
      padding: 12px 30px;
      font-size: 16px;
      font-weight: bold;
      background: #f25e42;
      color: #fff;
      border: none;
      border-radius: 5px;
      cursor: pointer;
    }

    .load-more:hover {
      background: #d74d36;
    }

    @media (max-width: 640px) {
      .blog-card-link {
        width: 100%;
      }
    }
  </style>

  <div class="blog-container" id="blogContainer">
    @foreach($recentPosts as $post)
      <a href="{{ route('website.post', ['slug' => $post->slug]) }}" class="blog-card-link">
        <div class="blog-card">{{ $post->title }}</div>
      </a>
    @endforeach
  </div>

  <button class="load-more" id="loadMoreBtn">Load More</button>

  <script>
    const blogLinks = document.querySelectorAll('.blog-card-link');
    const loadMoreBtn = document.getElementById('loadMoreBtn');
    let currentIndex = 0;
    const perLoad = 10;

    function showNextBlogs() {
      for (let i = currentIndex; i < currentIndex + perLoad; i++) {
        if (blogLinks[i]) {
          blogLinks[i].classList.add('show');
        }
      }
      currentIndex += perLoad;

      if (currentIndex >= blogLinks.length) {
        loadMoreBtn.style.display = 'none';
      }
    }

    // Initial load
    showNextBlogs();

    loadMoreBtn.addEventListener('click', showNextBlogs);
  </script>

</div>


</main>
    
   @endsection