      
  <nav class="bg-white shadow-md sticky top-0 z-50">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
      <div class="flex justify-between h-16">
        <div class="flex items-center">
          <a class="flex-shrink-0 flex items-center" href="/">
  <img src="{{ asset($setting->image ?? '') }}" alt="BritView IPTV Logo" class="h-80 w-80">

</a>

          <div class="hidden md:ml-6 md:flex md:space-x-1 lg:space-x-4 h-full">
            <a aria-current="page" class="inline-flex items-center px-1 pt-1 border-b-2 text-sm font-medium h-full border-blue-500 text-gray-900" href="/">Home</a>
            <a class="inline-flex items-center px-1 pt-1 border-b-2 text-sm font-medium h-full border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300" href="{{ route('website.service.installation') }}">Installation Guide</a>
            <a class="inline-flex items-center px-1 pt-1 border-b-2 text-sm font-medium h-full border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300" href="{{ route('website.service.reviews') }}">Reviews</a>
         
            <a class="inline-flex items-center px-1 pt-1 border-b-2 text-sm font-medium h-full border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300" href="{{ route('website.service.pricing') }}">Pricing</a>
            <a href="/#features" class="inline-flex items-center px-1 pt-1 border-b-2 text-sm font-medium h-full border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300">Features</a>
            <a href="/#faq" class="inline-flex items-center px-1 pt-1 border-b-2 text-sm font-medium h-full border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300">FAQ</a>
            <a href="/#contact" class="inline-flex items-center px-1 pt-1 border-b-2 text-sm font-medium h-full border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300">Contact</a>
          </div>
        </div>
        <div class="hidden md:flex items-center space-x-3">
          <a class="inline-flex items-center justify-center rounded-md text-sm font-medium ring-offset-background transition-colors focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-ring focus-visible:ring-offset-2 disabled:pointer-events-none disabled:opacity-50 border bg-background h-10 px-4 py-2 border-green-500 text-green-600 hover:bg-green-50 hover:text-green-700" href="{{ route('website.service.trial') }}">
            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
              viewBox="0 0 24 24" fill="none" stroke="currentColor"
              stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
              class="mr-2 h-4 w-4">
              <circle cx="12" cy="12" r="10"></circle>
              <polygon points="10 8 16 12 10 16 10 8"></polygon>
            </svg> 24hr Free Trial
          </a>
          <a href="https://wa.me/{{ $setting->whatsapp }}?text=Hello {{ $setting->webname }} IPTV, I'd like to get started!" target="_blank" rel="noopener noreferrer" class="inline-flex items-center justify-center rounded-md text-sm font-medium ring-offset-background transition-colors focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-ring focus-visible:ring-offset-2 disabled:pointer-events-none disabled:opacity-50 bg-primary text-primary-foreground hover:bg-primary/90 h-10 px-4 py-2">Get Started</a>
        </div>
        <!-- Mobile Toggle Button -->
        <div class="flex items-center md:hidden">
          <button id="menu-toggle" class="inline-flex items-center justify-center p-2 rounded-md text-gray-400 hover:text-gray-500 hover:bg-gray-100 focus:outline-none focus:ring-2 focus:ring-inset focus:ring-blue-500">
            <span class="sr-only">Open main menu</span>
            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
              viewBox="0 0 24 24" fill="none" stroke="currentColor"
              stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
              class="block h-6 w-6">
              <line x1="4" x2="20" y1="12" y2="12"></line>
              <line x1="4" x2="20" y1="6" y2="6"></line>
              <line x1="4" x2="20" y1="18" y2="18"></line>
            </svg>
          </button>
        </div>
      </div>
    </div>

    <!-- Mobile Menu Content -->
    <div id="mobile-menu" class="md:hidden hidden px-4 pt-2 pb-3 space-y-1 bg-white shadow">
      <a href="/" class="block text-gray-700 hover:text-blue-600">Home</a>
      <a href="{{ route('website.service.installation') }}" class="block text-gray-700 hover:text-blue-600">Installation Guide</a>
      <a href="{{ route('website.service.reviews') }}" class="block text-gray-700 hover:text-blue-600">Reviews</a>
      <a href="{{ route('website.service.pricing') }}" class="block text-gray-700 hover:text-blue-600">Pricing</a>
      <a href="/#features" class="block text-gray-700 hover:text-blue-600">Features</a>
      <a href="/#faq" class="block text-gray-700 hover:text-blue-600">FAQ</a>
      <a href="/#contact" class="block text-gray-700 hover:text-blue-600">Contact</a>
      <a href="{{ route('website.service.trial') }}" class="block text-green-600 font-medium hover:text-green-700">24hr Free Trial</a>
      <a href="https://wa.me/{{ $setting->whatsapp }}?text=Hello {{ $setting->webname }} IPTV, I'd like to get started!" target="_blank" class="block text-blue-600 font-medium hover:text-blue-700">Get Started</a>
    </div>
  </nav>

  <script>
    document.getElementById('menu-toggle').addEventListener('click', function () {
      document.getElementById('mobile-menu').classList.toggle('hidden');
    });
  </script>