<?php

namespace App\Http\Controllers;

use Session;
use App\Tag;
use App\User;
use App\Post;
use App\Contact;
use App\Category;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB; // Import the DB facade

class FrontEndController extends Controller
{
    public function blog(){
        $posts = Post::with('category', 'user')->orderBy('created_at', 'DESC')->take(5)->get();
        $firstPosts2 = $posts->splice(0, 2);
        $middlePost = $posts->splice(0, 1);
        $lastPosts = $posts->splice(0);

        $footerPosts = Post::with('category', 'user')->inRandomOrder()->limit(4)->get();
        $firstFooterPost = $footerPosts->splice(0, 1);
        $firstfooterPosts2 = $footerPosts->splice(0, 2);
        $lastFooterPost = $footerPosts->splice(0, 1);

        $recentPosts = Post::with('category', 'user')->orderBy('created_at', 'DESC')->paginate(9);
        return view('website.blog', compact(['posts', 'recentPosts', 'firstPosts2', 'middlePost', 'lastPosts', 'firstFooterPost', 'firstfooterPosts2', 'lastFooterPost']));
    }



   public function home(){
   

    $posts = Post::with('category', 'user')->orderBy('created_at', 'DESC')->take(5)->get();
    $firstPosts2 = $posts->splice(0, 2);
    $middlePost = $posts->splice(0, 1);
    $lastPosts = $posts->splice(0);

    $footerPosts = Post::with('category', 'user')->inRandomOrder()->limit(4)->get();
    $firstFooterPost = $footerPosts->splice(0, 1);
    $firstfooterPosts2 = $footerPosts->splice(0, 2);
    $lastFooterPost = $footerPosts->splice(0, 1);

    $recentPosts = Post::with('category', 'user')->orderBy('created_at', 'DESC')->paginate(9);
    return view('website.home', compact(['posts', 'recentPosts', 'firstPosts2', 'middlePost', 'lastPosts', 'firstFooterPost', 'firstfooterPosts2', 'lastFooterPost', ]));
}

    public function about(){
        $user = User::first();

        return view('website.about', compact('user'));
    }

     public function services(){
        $user = User::first();

        return view('website.services', compact('user'));
    }

    public function team(){
        $user = User::first();

        return view('website.team', compact('user'));
    }


   
    public function category($slug){
        $category = Category::where('slug', $slug)->first();
        if($category){
            $posts = Post::where('category_id', $category->id)->paginate(9);

            return view('website.category', compact(['category', 'posts']));
        }else {
            return redirect()->route('website');
        }
    }
   
    public function tag($slug){
        $tag = Tag::where('slug', $slug)->first();
        if($tag){
            $posts = $tag->posts()->orderBy('created_at', 'desc')->paginate(9);

            return view('website.tag', compact(['tag', 'posts']));
        }else {
            return redirect()->route('website');
        }
    }
   
    public function contact(){
            return view('website.contact');
    }
   
  public function post($slug){
    $user = Auth::user(); // Get the authenticated user
    $post = Post::with('category', 'user')->where('slug', $slug)->first();
    $posts = Post::with('category', 'user')->inRandomOrder()->limit(3)->get();

    // More related posts
    $relatedPosts = Post::orderBy('category_id', 'desc')->inRandomOrder()->take(4)->get();
    $firstRelatedPost = $relatedPosts->splice(0, 1);
    $firstRelatedPosts2 = $relatedPosts->splice(0, 2);
    $lastRelatedPost = $relatedPosts->splice(0, 1);

    $categories = Category::all();
    $tags = Tag::all();

    // Call the singletagdata method to get datalist
    $datalist = $this->singletagdata($post->posttags); // Assuming 'posttags' is the field containing tags

    if($post){
        // Pass 'datalist' along with other variables to the view
        return view('website.post', compact(['post', 'posts', 'categories', 'tags', 'firstRelatedPost', 'firstRelatedPosts2', 'lastRelatedPost', 'user', 'datalist']));
    }else {
        return redirect('/');
    }
}


public function posttags($title) {
     
    // Get the tag data using singletagdata function
    $datalist = $this->singletagdata($title);
    
    // Pass the $datalist and $tag to the view
    return view('website.posttags', ['datalist' => $datalist, 'tag' => $title]);
}




 public function singletagdata($title)
    {
        $tag = str_replace('-', ' ', $title);
        $tag = ucwords($tag);

        $datalist = DB::table('posts')
            ->where('posttags', 'LIKE', '%' . $tag . '%')
            ->orderBy('id', 'desc')
            ->get();

        return $datalist;

    }

 

 public function send_message(Request $request)
{
    $this->validate($request, [
        'name' => 'required|max:200',
        'email' => 'required|email|max:200',
        'number' => 'required|max:200',
        'subject' => 'required',
        'message' => 'required',
    ]);

    $contact = Contact::create($request->all());

    Session::flash('message-send', 'Contact message sent successfully');
    return redirect()->back();
}




 public function installation(){
        $user = User::first();

        return view('website.service.installation', compact('user'));
    }

     public function pricing(){
        $user = User::first();

        return view('website.service.pricing', compact('user'));
    }

     public function trial(){
        $user = User::first();

        return view('website.service.trial', compact('user'));
    }

     public function reviews(){
        $user = User::first();

        return view('website.service.reviews', compact('user'));
    }

     public function terms(){
        $user = User::first();

        return view('website.service.terms', compact('user'));
    }

     public function policy(){
        $user = User::first();

        return view('website.service.policy', compact('user'));
    }

     public function refund(){
        $user = User::first();

        return view('website.service.refund', compact('user'));
    }

      public function acceptable(){
        $user = User::first();

        return view('website.service.acceptable', compact('user'));
    }

     public function gdpr(){
        $user = User::first();

        return view('website.service.gdpr', compact('user'));
    }

    public function dmca(){
        $user = User::first();

        return view('website.service.dmca', compact('user'));
    }


 public function affiliate(){
        $user = User::first();

        return view('website.service.affiliate', compact('user'));
    }
    
         public function sitemap() {
    $category = Category::all();
    $post = Post::all();  

      

    return response()->view('website.sitemap', [
        
        'category' => $category,        
        'post' => $post
    ])->header('Content-Type', 'text/xml');
}



}
